/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications.condition;

public interface InventoryChecker {
    public static final InventoryChecker EQUAL = new InventoryChecker(){

        @Override
        public boolean isFulfilled(int count, int param) {
            return count == 0;
        }

        @Override
        public boolean takesParam() {
            return true;
        }

        public String toString() {
            return "=";
        }
    };
    public static final InventoryChecker LESS_THAN = new InventoryChecker(){

        @Override
        public boolean isFulfilled(int count, int param) {
            return count < 0;
        }

        @Override
        public boolean takesParam() {
            return true;
        }

        public String toString() {
            return "<";
        }
    };
    public static final InventoryChecker GREATER_THAN = new InventoryChecker(){

        @Override
        public boolean isFulfilled(int count, int param) {
            return count > 0;
        }

        @Override
        public boolean takesParam() {
            return true;
        }

        public String toString() {
            return ">";
        }
    };
    public static final InventoryChecker LESS_OR_EQUAL = new InventoryChecker(){

        @Override
        public boolean isFulfilled(int count, int param) {
            return count <= 0;
        }

        @Override
        public boolean takesParam() {
            return true;
        }

        public String toString() {
            return "\u2264";
        }
    };
    public static final InventoryChecker GREATER_OR_EQUAL = new InventoryChecker(){

        @Override
        public boolean isFulfilled(int count, int param) {
            return count >= 0;
        }

        @Override
        public boolean takesParam() {
            return true;
        }

        public String toString() {
            return "\u2265";
        }
    };
    public static final InventoryChecker[] CHECKERS = new InventoryChecker[]{EQUAL, LESS_THAN, GREATER_THAN, LESS_OR_EQUAL, GREATER_OR_EQUAL};

    public boolean isFulfilled(int var1, int var2);

    public boolean takesParam();

    public static class Pointer {
        public InventoryChecker object;

        public Pointer(InventoryChecker object) {
            this.object = object;
        }
    }
}

