/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications.condition;

import com.github.zakru.advancednotifications.AdvancedNotificationsPlugin;
import com.github.zakru.advancednotifications.condition.CheckerAdapter;
import com.github.zakru.advancednotifications.condition.Condition;
import com.github.zakru.advancednotifications.condition.ConditionType;
import com.github.zakru.advancednotifications.condition.ConditionTypes;
import com.github.zakru.advancednotifications.condition.InventoryChecker;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

public class ConditionAdapter
extends TypeAdapter<Condition> {
    private final AdvancedNotificationsPlugin plugin;
    private final Gson gson;

    public ConditionAdapter(AdvancedNotificationsPlugin plugin) {
        this.plugin = plugin;
        this.gson = new GsonBuilder().registerTypeAdapter(Condition.class, (Object)this).registerTypeAdapter(InventoryChecker.Pointer.class, (Object)new CheckerAdapter()).create();
    }

    public void write(JsonWriter out, Condition o) throws IOException {
        if (o != null) {
            JsonObject jo = this.gson.toJsonTree((Object)o).getAsJsonObject();
            jo.addProperty("type", this.idOf(o));
            this.gson.toJson((JsonElement)jo, out);
        } else {
            out.nullValue();
        }
    }

    public Condition read(JsonReader in) throws IOException {
        JsonObject jo = (JsonObject)this.gson.fromJson(in, JsonObject.class);
        String conditionType = jo.get("type").getAsString();
        jo.remove("type");
        Condition condition = this.ofType((JsonElement)jo, conditionType);
        condition.setPlugin(this.plugin);
        return condition;
    }

    private Condition ofType(JsonElement in, String type) throws IOException {
        ConditionType t = ConditionTypes.REGISTRY.entrySet().stream().filter(e -> ((String)e.getKey()).equals(type)).map(Map.Entry::getValue).findAny().orElse(null);
        if (t != null) {
            return (Condition)this.gson.fromJson(in, t.getTargetClass());
        }
        throw new RuntimeException("Unknown condition type " + type);
    }

    private String idOf(Condition o) {
        Optional<String> id = ConditionTypes.REGISTRY.entrySet().stream().filter(e -> ((ConditionType)e.getValue()).getTargetClass() == o.getClass()).map(Map.Entry::getKey).findAny();
        if (id.isPresent()) {
            return id.get();
        }
        throw new RuntimeException("Unknown condition class " + o.getClass());
    }
}

