/*
 * Decompiled with CFR 0.152.
 */
package com.github.zakru.advancednotifications;

import com.github.zakru.advancednotifications.DraggableContainer;
import com.github.zakru.advancednotifications.InventoryEvent;
import com.github.zakru.advancednotifications.condition.ConditionTypes;
import com.github.zakru.advancednotifications.notification.LegacyNotificationAdapter;
import com.github.zakru.advancednotifications.notification.Notification;
import com.github.zakru.advancednotifications.notification.NotificationAdapter;
import com.github.zakru.advancednotifications.notification.NotificationTypes;
import com.github.zakru.advancednotifications.ui.AdvancedNotificationsPluginPanel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import joptsimple.internal.Strings;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;

@PluginDescriptor(name="Advanced Notifications", tags={"notifications", "inventory", "item", "idle"}, description="An advanced notification system")
public class AdvancedNotificationsPlugin
extends Plugin
implements DraggableContainer<Notification> {
    private static final String CONFIG_GROUP = "advancednotifications";
    private static final String CONFIG_KEY = "notifications";
    private static final String CONFIG_KEY_FORMAT = "format";
    private static final String ICON_FILE = "panel_icon.png";
    private static final String PLUGIN_NAME = "Advanced Notifications";
    private static final int FORMAT_CURRENT_VERSION = 1;
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private Notifier notifier;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ConfigManager configManager;
    private AdvancedNotificationsPluginPanel pluginPanel;
    private NavigationButton navigationButton;
    private Item[] previousItems;
    private List<Notification> notifications;

    protected void startUp() throws Exception {
        this.notifications = new ArrayList<Notification>();
        this.previousItems = null;
        int version = 0;
        String versionString = this.configManager.getConfiguration(CONFIG_GROUP, CONFIG_KEY_FORMAT);
        try {
            if (!Strings.isNullOrEmpty((String)versionString)) {
                version = Integer.parseInt(versionString);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.loadConfig(this.configManager.getConfiguration(CONFIG_GROUP, CONFIG_KEY), version);
        this.pluginPanel = new AdvancedNotificationsPluginPanel(this);
        this.pluginPanel.rebuild();
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(this.getClass(), (String)ICON_FILE);
        this.navigationButton = NavigationButton.builder().tooltip(PLUGIN_NAME).icon(icon).priority(5).panel((PluginPanel)this.pluginPanel).build();
        this.clientToolbar.addNavigation(this.navigationButton);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.notifications = null;
        this.pluginPanel = null;
        this.navigationButton = null;
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (this.notifications.isEmpty() && event.getGroup().equals(CONFIG_GROUP) && event.getKey().equals(CONFIG_KEY)) {
            this.loadConfig(event.getNewValue(), 1);
        }
    }

    private void loadConfig(String json, int version) {
        if (Strings.isNullOrEmpty((String)json)) {
            this.notifications = new ArrayList<Notification>();
            return;
        }
        if (version == 0) {
            Gson gson = new GsonBuilder().registerTypeAdapter(Notification.class, (Object)new LegacyNotificationAdapter(this)).create();
            this.notifications = (List)gson.fromJson(json, new TypeToken<ArrayList<Notification>>(){}.getType());
        } else if (version == 1) {
            Gson gson = new GsonBuilder().registerTypeAdapter(Notification.class, (Object)new NotificationAdapter(this)).create();
            this.notifications = (List)gson.fromJson(json, new TypeToken<ArrayList<Notification>>(){}.getType());
        }
    }

    private void notify(Object event) {
        for (Notification n : this.notifications) {
            n.tryNotify(event);
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() == this.client.getItemContainer(InventoryID.INVENTORY)) {
            Item[] items = event.getItemContainer().getItems();
            if (this.previousItems == null) {
                this.previousItems = items;
                return;
            }
            if (this.client.getWidget(WidgetInfo.BANK_CONTAINER) == null) {
                HashSet<Integer> uniqueItems = new HashSet<Integer>();
                this.addUniqueItems(uniqueItems, items);
                this.addUniqueItems(uniqueItems, this.previousItems);
                Iterator iterator = uniqueItems.iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    this.notify(new InventoryEvent(id, this.countItems(items, id), this.countItems(this.previousItems, id)));
                }
            }
            this.previousItems = items;
        }
    }

    private void addUniqueItems(Set<Integer> set, Item[] items) {
        for (Item i : items) {
            set.add(i.getId());
        }
    }

    private int countItems(Item[] items, int id) {
        int c = 0;
        for (Item i : items) {
            if (i.getId() != id) continue;
            c += Math.max(i.getQuantity(), 1);
        }
        return c;
    }

    public void updateConfig() {
        if (this.notifications.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, CONFIG_KEY_FORMAT);
            this.configManager.unsetConfiguration(CONFIG_GROUP, CONFIG_KEY);
            return;
        }
        this.configManager.unsetConfiguration(CONFIG_GROUP, CONFIG_KEY_FORMAT);
        Gson gson = new GsonBuilder().registerTypeAdapter(Notification.class, (Object)new NotificationAdapter(this)).create();
        String json = gson.toJson(this.notifications, new TypeToken<ArrayList<Notification>>(){}.getType());
        this.configManager.setConfiguration(CONFIG_GROUP, CONFIG_KEY, json);
        this.configManager.setConfiguration(CONFIG_GROUP, CONFIG_KEY_FORMAT, (Object)1);
    }

    public void rebuildPluginPanel() {
        this.pluginPanel.rebuild();
    }

    @Override
    public List<Notification> getDraggableItems() {
        return this.notifications;
    }

    public Client getClient() {
        return this.client;
    }

    public ItemManager getItemManager() {
        return this.itemManager;
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    static {
        NotificationTypes.registerAll();
        ConditionTypes.registerAll();
    }
}

