/*
 * Decompiled with CFR 0.152.
 */
package com.afkspot;

import com.afkspot.AfkSpotConfig;
import com.afkspot.AfkSpotOverlay;
import com.google.inject.Provides;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="AFK Spot Finder", description="Finds dense tiles of enemies to identify the best afk spot", tags={"combat", "afk", "markers", "density", "tile"})
public class AfkSpotPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AfkSpotPlugin.class);
    private static final Comparator<Map.Entry<WorldPoint, Set<Integer>>> COMPARATOR = Comparator.comparingInt(e -> ((Set)e.getValue()).size());
    private static final Pattern DELIM = Pattern.compile("[,;\\n]");
    @Inject
    private Client client;
    @Inject
    private AfkSpotConfig config;
    @Inject
    private AfkSpotOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    private final Set<String> npcNameFilters = Collections.synchronizedSet(new HashSet());
    private final Map<WorldPoint, Set<Integer>> tileDensity = new HashMap<WorldPoint, Set<Integer>>();
    private int region = 0;
    private int plane = 0;

    protected void startUp() {
        log.info("AFK Spot Finder started!");
        this.parseFilters(this.config.npcNames());
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        log.info("AFK Spot Finder stopped!");
        this.plane = 0;
        this.region = 0;
        this.clear();
        this.npcNameFilters.clear();
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.clear();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        int plane = this.client.getPlane();
        int region = this.client.getLocalPlayer().getWorldLocation().getRegionID();
        if (this.plane != plane || this.region != region) {
            this.plane = plane;
            this.region = region;
            this.clear();
        }
        NPC[] npcs = this.client.getCachedNPCs();
        int n = npcs.length;
        for (int index = 0; index < n; ++index) {
            NPC npc = npcs[index];
            if (npc == null || npc.isDead() || !this.isAttackable(npc)) continue;
            String name = npc.getName();
            if (!this.npcNameFilters.isEmpty() && (name == null || !this.npcNameFilters.contains(name.toLowerCase()))) continue;
            WorldPoint npcTile = npc.getWorldLocation();
            NPCComposition comp = npc.getTransformedComposition();
            int size = comp != null ? comp.getSize() : 1;
            for (int x = 0; x < size; ++x) {
                for (int y = 0; y < size; ++y) {
                    WorldPoint occupiedTile = npcTile.dx(x).dy(y);
                    this.tileDensity.computeIfAbsent(occupiedTile, k -> new HashSet()).add(index);
                }
            }
        }
        this.overlay.updateTopTiles(this.getTopTiles(this.config.numberOfTiles()));
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("afkspot")) {
            return;
        }
        if (event.getKey().equals("npcNames")) {
            this.parseFilters(event.getNewValue());
            this.clear();
        }
    }

    private void clear() {
        this.tileDensity.clear();
        this.overlay.updateTopTiles(Collections.emptyList());
    }

    private void parseFilters(String npcNames) {
        this.npcNameFilters.clear();
        DELIM.splitAsStream(npcNames).filter(StringUtils::isNotBlank).map(String::trim).map(String::toLowerCase).forEach(this.npcNameFilters::add);
    }

    @Provides
    AfkSpotConfig provideConfig(ConfigManager configManager) {
        return (AfkSpotConfig)configManager.getConfig(AfkSpotConfig.class);
    }

    private boolean isAttackable(NPC npc) {
        NPCComposition comp = npc.getTransformedComposition();
        return comp != null && ArrayUtils.contains((Object[])comp.getActions(), (Object)"Attack");
    }

    private Collection<Map.Entry<WorldPoint, Set<Integer>>> getTopTiles(int count) {
        if (this.tileDensity.isEmpty()) {
            return Collections.emptyList();
        }
        PriorityQueue<Map.Entry<WorldPoint, Set<Integer>>> heap = new PriorityQueue<Map.Entry<WorldPoint, Set<Integer>>>(count + 1, COMPARATOR);
        for (Map.Entry<WorldPoint, Set<Integer>> entry : this.tileDensity.entrySet()) {
            int n = heap.size();
            if (n >= count && COMPARATOR.compare(entry, (Map.Entry)heap.peek()) <= 0) continue;
            if (n + 1 > count) {
                heap.poll();
            }
            heap.offer(entry);
        }
        return heap;
    }
}

