/*
 * Decompiled with CFR 0.152.
 */
package com.afkspot;

import com.afkspot.AfkSpotPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class AfkSpotOverlay
extends Overlay {
    private final Client client;
    private final AfkSpotPlugin plugin;
    private Collection<Map.Entry<WorldPoint, Set<Integer>>> topTiles;

    @Inject
    public AfkSpotOverlay(Client client, AfkSpotPlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.topTiles = Collections.emptyList();
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        for (Map.Entry<WorldPoint, Set<Integer>> entry : this.topTiles) {
            Polygon tilePoly;
            LocalPoint localPoint;
            WorldPoint worldPoint = entry.getKey();
            if (this.client.getPlane() != worldPoint.getPlane() || (localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint)) == null || (tilePoly = Perspective.getCanvasTilePoly((Client)this.client, (LocalPoint)localPoint)) == null) continue;
            Color color = this.getColorForDensity(entry.getValue().size());
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)tilePoly, (Color)color);
        }
        return null;
    }

    public void updateTopTiles(Collection<Map.Entry<WorldPoint, Set<Integer>>> topTiles) {
        this.topTiles = topTiles;
    }

    private Color getColorForDensity(int density) {
        if (density >= 3) {
            return Color.RED;
        }
        if (density == 2) {
            return Color.YELLOW;
        }
        return Color.GREEN;
    }
}

