/*
 * Decompiled with CFR 0.152.
 */
package com.ywcode.randomeventhider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.ywcode.randomeventhider.RandomEventHiderConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.GraphicsObject;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Renderable;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AreaSoundEffectPlayed;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.SoundEffectPlayed;
import net.runelite.client.callback.Hooks;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Random Event Hider", description="Adds the ability to hide specific random events that interact with you or with other players.", tags={"random event,hider,random event hider,ra hider,messenger,strange plant,poof,smoke,star mining,shooting stars,forestry"})
public class RandomEventHiderPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RandomEventHiderPlugin.class);
    private static final Set<Integer> RANDOM_EVENT_NPCS = ImmutableSet.of((Object)6747, (Object)5426, (Object)12551, (Object)12552, (Object)307, (Object)314, (Object[])new Integer[]{322, 6749, 390, 6754, 6744, 6748, 5429, 5430, 5431, 5432, 312, 5434, 5435, 326, 327, 5438, 5441, 6746, 5437, 5440, 6750, 6751, 6752, 6753, 5436, 5439, 380, 6738, 6755, 375, 376, 5510, 6743});
    private static final Set<Integer> MESSENGER_NPCS = ImmutableSet.of((Object)3439, (Object)11287, (Object)11814, (Object)11815, (Object)11816, (Object)11817, (Object[])new Integer[0]);
    private static final Set<Integer> EVENT_NPCS;
    private static final Set<Integer> FROGS_NPCS;
    private static final int POOF_SOUND = 1930;
    private static final int DRUNKEN_DWARF_SOUND = 2297;
    private static final int EVIL_BOB_MEOW = 333;
    private static final int FROG_SPLASH = 838;
    private static final int POOF_GRAPHICSOBJECT_ID = 86;
    private static final int FROG_REALM_REGIONID = 9802;
    private boolean hideOtherBeekeeper;
    private boolean hideOtherCaptArnav;
    private boolean hideOtherNiles;
    private boolean hideOtherCountCheck;
    private boolean hideOtherDrillDemon;
    private boolean hideOtherDrunkenDwarf;
    private boolean hideOtherEvilBob;
    private boolean hideOtherEvilTwin;
    private boolean hideOtherFreakyForester;
    private boolean hideOtherGenie;
    private boolean hideOtherGravedigger;
    private boolean hideOtherJekyllHyde;
    private boolean hideOtherKissTheFrog;
    private boolean hideOtherMaze;
    private boolean hideOtherMime;
    private boolean hideOtherMysteriousOldMan;
    private boolean hideOtherPilloryGuard;
    private boolean hideOtherPinball;
    private boolean hideOtherPrisonPete;
    private boolean hideOtherQuizMaster;
    private boolean hideOtherRickTurpentine;
    private boolean hideOtherSandwichLady;
    private boolean hideOtherSurpriseExam;
    private boolean hideOwnBeekeeper;
    private boolean hideOwnCaptArnav;
    private boolean hideOwnCountCheck;
    private boolean hideOwnNiles;
    private boolean hideOwnDrillDemon;
    private boolean hideOwnDrunkenDwarf;
    private boolean hideOwnEvilBob;
    private boolean hideOwnEvilTwin;
    private boolean hideOwnFreakyForester;
    private boolean hideOwnGenie;
    private boolean hideOwnGravedigger;
    private boolean hideOwnJekyllHyde;
    private boolean hideOwnKissTheFrog;
    private boolean hideOwnMaze;
    private boolean hideOwnMime;
    private boolean hideOwnMysteriousOldMan;
    private boolean hideOwnPilloryGuard;
    private boolean hideOwnPinball;
    private boolean hideOwnPrisonPete;
    private boolean hideOwnQuizMaster;
    private boolean hideOwnRickTurpentine;
    private boolean hideOwnSandwichLady;
    private boolean hideOwnSurpriseExam;
    private boolean hideAllStrangePlant;
    private boolean muteDwarf;
    private boolean muteBob;
    private boolean muteFrogs;
    private boolean mutePoof;
    private boolean muteOtherRandomSounds;
    private boolean hidePoof;
    private boolean hideOtherMessengers;
    private final LinkedHashMap<Integer, Integer> ownRandomsMap = new LinkedHashMap();
    private final LinkedHashMap<Integer, Integer> otherRandomsMap = new LinkedHashMap();
    private final LinkedHashMap<WorldPoint, Integer> spawnedDespawnedNpcLocations = new LinkedHashMap();
    private final LinkedHashMap<WorldPoint, Integer> spawnedDespawnedNpcLocationsDeletion = new LinkedHashMap();
    private static boolean shouldCleanMap;
    private static int currentRegionID;
    private final Hooks.RenderableDrawListener drawListener = this::shouldDraw;
    @Inject
    private Client client;
    @Inject
    private RandomEventHiderConfig config;
    @Inject
    private Hooks hooks;

    public void startUp() {
        this.hooks.registerRenderableDrawListener(this.drawListener);
        this.updateConfig();
    }

    public void shutDown() {
        this.hooks.unregisterRenderableDrawListener(this.drawListener);
        this.ownRandomsMap.clear();
        this.otherRandomsMap.clear();
        this.spawnedDespawnedNpcLocations.clear();
        this.spawnedDespawnedNpcLocationsDeletion.clear();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("RandomEventHider")) {
            this.updateConfig();
        }
    }

    private void updateConfig() {
        this.hideOtherBeekeeper = this.config.hideOtherBeekeeper();
        this.hideOtherCaptArnav = this.config.hideOtherCaptArnav();
        this.hideOtherNiles = this.config.hideOtherNiles();
        this.hideOtherCountCheck = this.config.hideOtherCountCheck();
        this.hideOtherDrillDemon = this.config.hideOtherDrillDemon();
        this.hideOtherDrunkenDwarf = this.config.hideOtherDrunkenDwarf();
        this.hideOtherEvilBob = this.config.hideOtherEvilBob();
        this.hideOtherEvilTwin = this.config.hideOtherEvilTwin();
        this.hideOtherFreakyForester = this.config.hideOtherFreakyForester();
        this.hideOtherGenie = this.config.hideOtherGenie();
        this.hideOtherGravedigger = this.config.hideOtherGravedigger();
        this.hideOtherJekyllHyde = this.config.hideOtherJekyllHyde();
        this.hideOtherKissTheFrog = this.config.hideOtherKissTheFrog();
        this.hideOtherMaze = this.config.hideOtherMaze();
        this.hideOtherMime = this.config.hideOtherMime();
        this.hideOtherMysteriousOldMan = this.config.hideOtherMysteriousOldMan();
        this.hideOtherPilloryGuard = this.config.hideOtherPilloryGuard();
        this.hideOtherPinball = this.config.hideOtherPinball();
        this.hideOtherPrisonPete = this.config.hideOtherPrisonPete();
        this.hideOtherQuizMaster = this.config.hideOtherQuizMaster();
        this.hideOtherRickTurpentine = this.config.hideOtherRickTurpentine();
        this.hideOtherSandwichLady = this.config.hideOtherSandwichLady();
        this.hideOtherSurpriseExam = this.config.hideOtherSurpriseExam();
        this.hideOwnBeekeeper = this.config.hideOwnBeekeeper();
        this.hideOwnCaptArnav = this.config.hideOwnCaptArnav();
        this.hideOwnNiles = this.config.hideOwnNiles();
        this.hideOwnCountCheck = this.config.hideOwnCountCheck();
        this.hideOwnDrillDemon = this.config.hideOwnDrillDemon();
        this.hideOwnDrunkenDwarf = this.config.hideOwnDrunkenDwarf();
        this.hideOwnEvilBob = this.config.hideOwnEvilBob();
        this.hideOwnEvilTwin = this.config.hideOwnEvilTwin();
        this.hideOwnFreakyForester = this.config.hideOwnFreakyForester();
        this.hideOwnGenie = this.config.hideOwnGenie();
        this.hideOwnGravedigger = this.config.hideOwnGravedigger();
        this.hideOwnJekyllHyde = this.config.hideOwnJekyllHyde();
        this.hideOwnKissTheFrog = this.config.hideOwnKissTheFrog();
        this.hideOwnMaze = this.config.hideOwnMaze();
        this.hideOwnMime = this.config.hideOwnMime();
        this.hideOwnMysteriousOldMan = this.config.hideOwnMysteriousOldMan();
        this.hideOwnPilloryGuard = this.config.hideOwnPilloryGuard();
        this.hideOwnPinball = this.config.hideOwnPinball();
        this.hideOwnPrisonPete = this.config.hideOwnPrisonPete();
        this.hideOwnQuizMaster = this.config.hideOwnQuizMaster();
        this.hideOwnRickTurpentine = this.config.hideOwnRickTurpentine();
        this.hideOwnSandwichLady = this.config.hideOwnSandwichLady();
        this.hideOwnSurpriseExam = this.config.hideOwnSurpriseExam();
        this.hideAllStrangePlant = this.config.hideAllStrangePlant();
        this.muteDwarf = this.config.muteDwarf();
        this.muteBob = this.config.muteBob();
        this.muteFrogs = this.config.muteFrogs();
        this.mutePoof = this.config.mutePoof();
        this.muteOtherRandomSounds = this.config.muteOtherRandomSounds();
        this.hidePoof = this.config.hidePoof();
        this.hideOtherMessengers = this.config.hideOtherMessengers();
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged interactingChanged) {
        Actor source = interactingChanged.getSource();
        Actor target = interactingChanged.getTarget();
        Player player = this.client.getLocalPlayer();
        if (player != null && source instanceof NPC && target instanceof Player && EVENT_NPCS.contains(((NPC)source).getId())) {
            int sourceIndex = ((NPC)source).getIndex();
            int sourceId = ((NPC)source).getId();
            if (target == player && !this.ownRandomsMap.containsKey(sourceIndex) && !this.otherRandomsMap.containsKey(sourceIndex)) {
                this.ownRandomsMap.put(sourceIndex, sourceId);
            }
            if (!(target == player || this.ownRandomsMap.containsKey(sourceIndex) || this.otherRandomsMap.containsKey(sourceIndex) || FROGS_NPCS.contains(sourceId) && this.mapContainsFrogId(this.ownRandomsMap))) {
                this.otherRandomsMap.put(sourceIndex, sourceId);
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN || gameStateChanged.getGameState() == GameState.HOPPING) {
            this.ownRandomsMap.clear();
            this.otherRandomsMap.clear();
            this.spawnedDespawnedNpcLocations.clear();
            this.spawnedDespawnedNpcLocationsDeletion.clear();
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        int npcSpawnedId = npcSpawned.getNpc().getId();
        int npcSpawnedIndex = npcSpawned.getNpc().getIndex();
        Actor npcSpawnedActor = npcSpawned.getActor();
        this.addPoofLocationToList(npcSpawnedId, npcSpawnedIndex, npcSpawnedActor, true);
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        int npcDespawnedId = npcDespawned.getNpc().getId();
        int npcDespawnedIndex = npcDespawned.getNpc().getIndex();
        Actor npcDespawnedActor = npcDespawned.getActor();
        this.addPoofLocationToList(npcDespawnedId, npcDespawnedIndex, npcDespawnedActor, false);
        if (EVENT_NPCS.contains(npcDespawnedId)) {
            if (this.ownRandomsMap.containsKey(npcDespawnedIndex)) {
                this.ownRandomsMap.remove(npcDespawnedIndex, npcDespawnedId);
            }
            if (this.otherRandomsMap.containsKey(npcDespawnedIndex)) {
                this.otherRandomsMap.remove(npcDespawnedIndex, npcDespawnedId);
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        currentRegionID = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID();
        if (!this.spawnedDespawnedNpcLocations.isEmpty()) {
            int currentGameCycle = this.client.getGameCycle();
            for (Map.Entry<WorldPoint, Integer> entry : this.spawnedDespawnedNpcLocations.entrySet()) {
                int npcGameCycle = entry.getValue();
                if (currentGameCycle - npcGameCycle <= 150) continue;
                this.spawnedDespawnedNpcLocationsDeletion.put(entry.getKey(), entry.getValue());
                shouldCleanMap = true;
            }
            this.cleanupMap();
        }
    }

    @Subscribe
    public void onSoundEffectPlayed(SoundEffectPlayed soundEffectPlayed) {
        int sourceNpcId;
        int soundId = soundEffectPlayed.getSoundId();
        if (soundEffectPlayed.getSource() != null && soundEffectPlayed.getSource() instanceof NPC && (EVENT_NPCS.contains(sourceNpcId = ((NPC)soundEffectPlayed.getSource()).getId()) || sourceNpcId == 323) && this.shouldMute(soundId)) {
            soundEffectPlayed.consume();
        }
        if ((soundId == 1930 || soundId == 333 || soundId == 2297 || soundId == 838) && this.shouldMute(soundId)) {
            soundEffectPlayed.consume();
        }
    }

    @Subscribe
    public void onAreaSoundEffectPlayed(AreaSoundEffectPlayed areaSoundEffectPlayed) {
        int sourceNpcId;
        int soundId = areaSoundEffectPlayed.getSoundId();
        if (areaSoundEffectPlayed.getSource() != null && areaSoundEffectPlayed.getSource() instanceof NPC && (EVENT_NPCS.contains(sourceNpcId = ((NPC)areaSoundEffectPlayed.getSource()).getId()) || sourceNpcId == 323) && this.shouldMute(soundId)) {
            areaSoundEffectPlayed.consume();
        }
        if ((soundId == 1930 || soundId == 333 || soundId == 2297 || soundId == 838) && this.shouldMute(soundId)) {
            areaSoundEffectPlayed.consume();
        }
    }

    @VisibleForTesting
    boolean shouldDraw(Renderable renderable, boolean drawingUI) {
        WorldPoint graphicsObjectWorldPoint;
        GraphicsObject graphicsObject;
        NPC npc;
        int npcId;
        if (renderable instanceof NPC && (EVENT_NPCS.contains(npcId = (npc = (NPC)renderable).getId()) || npcId == 323)) {
            int npcIndex = npc.getIndex();
            return !this.shouldHideBasedOnMaps(npcIndex, npcId);
        }
        if (renderable instanceof GraphicsObject && (graphicsObject = (GraphicsObject)renderable).getId() == 86 && this.spawnedDespawnedNpcLocations.containsKey(graphicsObjectWorldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)graphicsObject.getLocation()))) {
            graphicsObject.setFinished(true);
            return !this.hidePoof;
        }
        return true;
    }

    private void addPoofLocationToList(int npcId, int npcIndex, Actor npcActor, boolean NpcSpawned2) {
        if (EVENT_NPCS.contains(npcId) || npcId == 323) {
            WorldPoint npcWorldPoint = npcActor.getWorldLocation();
            if (NpcSpawned2 && this.shouldHideBasedOnMaps(npcIndex, npcId)) {
                this.spawnedDespawnedNpcLocations.put(npcWorldPoint, this.client.getGameCycle());
            }
            if (!NpcSpawned2) {
                this.spawnedDespawnedNpcLocations.put(npcWorldPoint, this.client.getGameCycle());
            }
        }
    }

    private void cleanupMap() {
        if (shouldCleanMap) {
            for (Map.Entry<WorldPoint, Integer> entry : this.spawnedDespawnedNpcLocationsDeletion.entrySet()) {
                this.spawnedDespawnedNpcLocations.remove(entry.getKey(), entry.getValue());
            }
            this.spawnedDespawnedNpcLocationsDeletion.clear();
            shouldCleanMap = false;
        }
    }

    private boolean mapContainsFrogId(LinkedHashMap Map2) {
        return Map2.containsValue(5429) || Map2.containsValue(5430) || Map2.containsValue(5431) || Map2.containsValue(5432) || Map2.containsValue(312) || Map2.containsValue(5434) || Map2.containsValue(5435);
    }

    private boolean shouldHideBasedOnMaps(int npcIndex, int npcId) {
        if (currentRegionID == 9802) {
            return false;
        }
        if (this.ownRandomsMap.containsKey(npcIndex)) {
            return this.shouldHide(npcId, true);
        }
        if (this.otherRandomsMap.containsKey(npcIndex)) {
            return this.shouldHide(npcId, false);
        }
        if (FROGS_NPCS.contains(npcId)) {
            if (this.mapContainsFrogId(this.ownRandomsMap)) {
                return this.shouldHide(npcId, true);
            }
            if (this.mapContainsFrogId(this.otherRandomsMap)) {
                return this.shouldHide(npcId, false);
            }
        }
        if (npcId == 323) {
            return this.hideAllStrangePlant;
        }
        return this.shouldHide(npcId, true) || this.shouldHide(npcId, false);
    }

    private boolean shouldHide(int id, boolean OwnEvent) {
        if (OwnEvent) {
            switch (id) {
                case 6747: {
                    return this.hideOwnBeekeeper;
                }
                case 5426: {
                    return this.hideOwnCaptArnav;
                }
                case 5436: 
                case 5437: 
                case 5438: 
                case 5439: 
                case 5440: 
                case 5441: {
                    return this.hideOwnNiles;
                }
                case 12551: 
                case 12552: {
                    return this.hideOwnCountCheck;
                }
                case 6743: {
                    return this.hideOwnDrillDemon;
                }
                case 322: {
                    return this.hideOwnDrunkenDwarf;
                }
                case 390: {
                    return this.hideOwnEvilBob;
                }
                case 6738: {
                    return this.hideOwnEvilTwin;
                }
                case 6748: {
                    return this.hideOwnFreakyForester;
                }
                case 326: 
                case 327: {
                    return this.hideOwnGenie;
                }
                case 6746: {
                    return this.hideOwnGravedigger;
                }
                case 307: 
                case 314: {
                    return this.hideOwnJekyllHyde;
                }
                case 312: 
                case 5429: 
                case 5430: 
                case 5431: 
                case 5432: 
                case 5434: 
                case 5435: {
                    return this.hideOwnKissTheFrog;
                }
                case 6752: {
                    return this.hideOwnMaze;
                }
                case 6753: {
                    return this.hideOwnMime;
                }
                case 6750: 
                case 6751: {
                    return this.hideOwnMysteriousOldMan;
                }
                case 380: {
                    return this.hideOwnPilloryGuard;
                }
                case 6744: {
                    return this.hideOwnPinball;
                }
                case 6754: {
                    return this.hideOwnPrisonPete;
                }
                case 6755: {
                    return this.hideOwnQuizMaster;
                }
                case 375: 
                case 376: {
                    return this.hideOwnRickTurpentine;
                }
                case 5510: {
                    return this.hideOwnSandwichLady;
                }
                case 6749: {
                    return this.hideOwnSurpriseExam;
                }
            }
        } else {
            switch (id) {
                case 6747: {
                    return this.hideOtherBeekeeper;
                }
                case 5426: {
                    return this.hideOtherCaptArnav;
                }
                case 5436: 
                case 5437: 
                case 5438: 
                case 5439: 
                case 5440: 
                case 5441: {
                    return this.hideOtherNiles;
                }
                case 12551: 
                case 12552: {
                    return this.hideOtherCountCheck;
                }
                case 6743: {
                    return this.hideOtherDrillDemon;
                }
                case 322: {
                    return this.hideOtherDrunkenDwarf;
                }
                case 390: {
                    return this.hideOtherEvilBob;
                }
                case 6738: {
                    return this.hideOtherEvilTwin;
                }
                case 6748: {
                    return this.hideOtherFreakyForester;
                }
                case 326: 
                case 327: {
                    return this.hideOtherGenie;
                }
                case 6746: {
                    return this.hideOtherGravedigger;
                }
                case 307: 
                case 314: {
                    return this.hideOtherJekyllHyde;
                }
                case 312: 
                case 5429: 
                case 5430: 
                case 5431: 
                case 5432: 
                case 5434: 
                case 5435: {
                    return this.hideOtherKissTheFrog;
                }
                case 6752: {
                    return this.hideOtherMaze;
                }
                case 6753: {
                    return this.hideOtherMime;
                }
                case 6750: 
                case 6751: {
                    return this.hideOtherMysteriousOldMan;
                }
                case 380: {
                    return this.hideOtherPilloryGuard;
                }
                case 6744: {
                    return this.hideOtherPinball;
                }
                case 6754: {
                    return this.hideOtherPrisonPete;
                }
                case 6755: {
                    return this.hideOtherQuizMaster;
                }
                case 375: 
                case 376: {
                    return this.hideOtherRickTurpentine;
                }
                case 5510: {
                    return this.hideOtherSandwichLady;
                }
                case 6749: {
                    return this.hideOtherSurpriseExam;
                }
                case 3439: 
                case 11287: 
                case 11814: 
                case 11815: 
                case 11816: 
                case 11817: {
                    return this.hideOtherMessengers;
                }
            }
        }
        return false;
    }

    private boolean shouldMute(int soundId) {
        switch (soundId) {
            case 2297: {
                return this.muteDwarf;
            }
            case 333: {
                return this.muteBob;
            }
            case 838: {
                return this.muteFrogs;
            }
            case 1930: {
                return this.mutePoof;
            }
        }
        return this.muteOtherRandomSounds;
    }

    @Provides
    RandomEventHiderConfig provideConfig(ConfigManager configManager) {
        return (RandomEventHiderConfig)configManager.getConfig(RandomEventHiderConfig.class);
    }

    static {
        HashSet<Integer> combinedSets = new HashSet<Integer>();
        combinedSets.addAll(RANDOM_EVENT_NPCS);
        combinedSets.addAll(MESSENGER_NPCS);
        EVENT_NPCS = Collections.unmodifiableSet(combinedSets);
        FROGS_NPCS = ImmutableSet.of((Object)5429, (Object)5430, (Object)5431, (Object)5432, (Object)312, (Object)5434, (Object[])new Integer[]{5435});
        shouldCleanMap = false;
        currentRegionID = 0;
    }
}

