/*
 * Decompiled with CFR 0.152.
 */
package com.taskjingle;

import com.google.inject.Provides;
import com.taskjingle.TaskJingleConfig;
import jaco.mp3.player.MP3Player;
import java.io.File;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="TaskJingle")
public class TaskJinglePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TaskJinglePlugin.class);
    @Inject
    private Client client;
    @Inject
    private TaskJingleConfig config;
    private static final Pattern CHAT_COMPLETE_MESSAGE = Pattern.compile("You've completed (?:at least )?(?<tasks>[\\d,]+) (?:Wilderness )?tasks?(?: and received \\d+ points, giving you a total of (?<points>[\\d,]+)| and reached the maximum amount of Slayer points \\((?<points2>[\\d,]+)\\))?");
    private MP3Player trackPlayer = new MP3Player(((Object)((Object)this)).getClass().getClassLoader().getResource("task-jingle.mp3"));
    private MP3Player customtrack = new MP3Player(((Object)((Object)this)).getClass().getClassLoader().getResource("task-jingle.mp3"));

    @Subscribe
    public void onChatMessage(ChatMessage event) throws Exception {
        Matcher mComplete;
        this.trackPlayer.setVolume(this.config.volume());
        String chatMsg = Text.removeTags((String)event.getMessage());
        if (chatMsg.startsWith("You've completed") && (chatMsg.contains("Slayer master") || chatMsg.contains("Slayer Master")) && (mComplete = CHAT_COMPLETE_MESSAGE.matcher(chatMsg)).find()) {
            if (this.config.customjingle()) {
                if (this.config.custompath().endsWith(".mp3") || this.config.custompath().endsWith(".MP3")) {
                    if (this.config.custompath().startsWith("http://") || this.config.custompath().startsWith("https://")) {
                        this.customtrack = new MP3Player(new URL(this.config.custompath()));
                    }
                    this.customtrack = new MP3Player(new File(this.config.custompath()));
                } else {
                    this.customtrack = new MP3Player(((Object)((Object)this)).getClass().getClassLoader().getResource("task-jingle.mp3"));
                }
                this.customtrack.play();
            } else {
                this.trackPlayer.play();
            }
        }
    }

    @Provides
    TaskJingleConfig provideConfig(ConfigManager configManager) {
        return (TaskJingleConfig)configManager.getConfig(TaskJingleConfig.class);
    }
}

