/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.scope;

import com.ericversteeg.scope.DayScope;
import com.ericversteeg.scope.HourScope;
import com.ericversteeg.scope.MonthScope;
import com.ericversteeg.scope.WeekScope;
import com.ericversteeg.scope.YearScope;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalField;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public abstract class Scope {
    protected LocalDate estLocalDate;
    protected LocalDateTime refLocalDate;
    protected LocalDate nowLocalDate = LocalDate.now();
    protected Scope parent = null;
    private List<Scope> children = new LinkedList<Scope>();
    private Type type;
    private Date estDate;
    protected TemporalField temporalField;
    protected int value;
    private int offset;
    private int interval;

    public Scope() {
    }

    public Scope(Scope parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public Scope(Scope parent, int value) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.type = Type.FIXED;
        this.value = value;
    }

    public Scope(Scope parent, TemporalField temporalField, int value) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.type = Type.FIXED;
        this.temporalField = temporalField;
        this.value = value;
        this.setReferenceDate();
    }

    public Scope(Scope parent, int offset, int interval) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.type = Type.REPEAT;
        this.offset = offset;
        this.interval = interval;
        this.setReferenceDate();
    }

    public Scope(Date estDate, int offset, int interval) {
        this.type = Type.REPEAT;
        this.estLocalDate = estDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        this.offset = offset;
        this.interval = interval;
        this.setReferenceDate();
    }

    void setReferenceDate() {
        if (this.parent == null) {
            if (this instanceof HourScope) {
                this.refLocalDate = this.estLocalDate.atTime(this.estLocalDate.get(ChronoField.HOUR_OF_DAY), 0);
            } else if (this instanceof DayScope) {
                this.refLocalDate = this.estLocalDate.atStartOfDay();
            } else if (this instanceof WeekScope) {
                this.refLocalDate = this.estLocalDate.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).atStartOfDay();
            } else if (this instanceof MonthScope) {
                this.refLocalDate = this.estLocalDate.withDayOfMonth(1).atStartOfDay();
            } else if (this instanceof YearScope) {
                this.refLocalDate = this.estLocalDate.withDayOfYear(1).atStartOfDay();
            }
        } else if (this.parent instanceof YearScope) {
            this.refLocalDate = this.nowLocalDate.withDayOfYear(1).atStartOfDay();
        } else if (this.parent instanceof MonthScope) {
            this.refLocalDate = this.nowLocalDate.withDayOfMonth(1).atStartOfDay();
        } else if (this.parent instanceof WeekScope) {
            this.refLocalDate = this.nowLocalDate.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).atStartOfDay();
        } else if (this.parent instanceof DayScope) {
            this.refLocalDate = this.nowLocalDate.atStartOfDay();
        }
    }

    public boolean matches(boolean alsoParents) {
        if (this.type == null) {
            if (this.parent != null && alsoParents) {
                return this.parent.matches(true);
            }
            return true;
        }
        if (this.type == Type.FIXED) {
            if (this.parent != null && alsoParents) {
                return this.parent.matches(true) && this.matchesFixed();
            }
            return this.matchesFixed();
        }
        if (this.parent != null && alsoParents) {
            return this.parent.matches(true) && this.matchesInterval(this.refLocalDate, this.nowLocalDate, this.offset, this.interval);
        }
        return this.matchesInterval(this.refLocalDate, this.nowLocalDate, this.offset, this.interval);
    }

    protected boolean matchesFixed() {
        if (this instanceof HourScope) {
            return this.nowLocalDate.atTime(LocalTime.now()).get(this.temporalField) == this.value;
        }
        return this.nowLocalDate.get(this.temporalField) == this.value;
    }

    abstract boolean matchesInterval(LocalDateTime var1, LocalDate var2, int var3, int var4);

    public void addChild(Scope scope) {
        this.children.add(scope);
    }

    public List<Scope> getChildren() {
        return this.children;
    }

    public String toString() {
        return "Scope{estLocalDate=" + this.estLocalDate + ", refLocalDate=" + this.refLocalDate + ", nowLocalDate=" + this.nowLocalDate + ", parent=" + this.parent + ", type=" + this.type + ", estDate=" + this.estDate + ", temporalField=" + this.temporalField + ", value=" + this.value + ", offset=" + this.offset + ", interval=" + this.interval + "}";
    }

    public static enum Type {
        FIXED,
        REPEAT;

    }
}

