/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.scope;

import com.ericversteeg.scope.Scope;
import com.ericversteeg.scope.YearScope;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class MonthScope
extends Scope {
    public MonthScope() {
    }

    public MonthScope(Scope parent) {
        super(parent);
    }

    public MonthScope(Scope parent, int value) {
        super(parent, value);
        if (parent instanceof YearScope) {
            this.temporalField = ChronoField.MONTH_OF_YEAR;
        }
    }

    public MonthScope(Scope parent, int offset, int interval) {
        super(parent, offset, interval);
    }

    public MonthScope(Date estDate, int offset, int interval) {
        super(estDate, offset, interval);
    }

    @Override
    boolean matchesInterval(LocalDateTime refLocalDate, LocalDate nowLocalDate, int offset, int interval) {
        LocalDateTime nowSoM = nowLocalDate.withDayOfMonth(1).atStartOfDay();
        long monthsSince = ChronoUnit.MONTHS.between(refLocalDate, nowSoM);
        return monthsSince - (long)offset >= 0L && (monthsSince - (long)offset) % (long)interval == 0L;
    }
}

