/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.scope;

import com.ericversteeg.scope.MonthScope;
import com.ericversteeg.scope.Scope;
import com.ericversteeg.scope.WeekScope;
import com.ericversteeg.scope.YearScope;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class DayScope
extends Scope {
    public DayScope(Scope parent) {
        super(parent);
    }

    public DayScope(Scope parent, int value) {
        super(parent, value);
        if (parent instanceof YearScope) {
            this.temporalField = ChronoField.DAY_OF_YEAR;
        } else if (parent instanceof MonthScope) {
            this.temporalField = ChronoField.DAY_OF_MONTH;
        } else if (parent instanceof WeekScope) {
            this.temporalField = ChronoField.DAY_OF_WEEK;
        }
    }

    public DayScope(Scope parent, int offset, int interval) {
        super(parent, offset, interval);
    }

    public DayScope(Date estDate, int offset, int interval) {
        super(estDate, offset, interval);
    }

    @Override
    boolean matchesInterval(LocalDateTime refLocalDate, LocalDate nowLocalDate, int offset, int interval) {
        LocalDateTime nowSoD = nowLocalDate.atStartOfDay();
        long daysSince = ChronoUnit.DAYS.between(refLocalDate, nowSoD);
        return daysSince - (long)offset >= 0L && (daysSince - (long)offset) % (long)interval == 0L;
    }
}

