/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg.pattern;

import com.ericversteeg.scope.DayScope;
import com.ericversteeg.scope.HourScope;
import com.ericversteeg.scope.MonthScope;
import com.ericversteeg.scope.Scope;
import com.ericversteeg.scope.WeekScope;
import com.ericversteeg.scope.YearScope;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;

public class Pattern {
    private Scope[] roots;
    private Scope[] scopes;

    public Pattern(Scope[] roots, Scope[] scopes) {
        this.roots = roots;
        this.scopes = scopes;
    }

    public boolean matches() {
        for (Scope root : this.roots) {
            if (!this.stepMatch(root)) continue;
            return true;
        }
        return false;
    }

    private boolean stepMatch(Scope scope) {
        if (scope.getChildren().size() == 0) {
            return scope.matches(false);
        }
        for (Scope child : scope.getChildren()) {
            if (!this.stepMatch(child)) continue;
            return scope.matches(false);
        }
        return false;
    }

    public static Pattern parse(String pattern, Date estDate) {
        String removedRepeatsPattern = Pattern.removeRepeatScopes(pattern);
        if (!removedRepeatsPattern.equals(pattern.trim())) {
            return Pattern.parse(removedRepeatsPattern, estDate);
        }
        LinkedList<Scope> roots = new LinkedList<Scope>();
        LinkedList allScopes = new LinkedList();
        String[] scopeStrings = pattern.trim().split("->");
        LinkedList parentScopes = new LinkedList();
        StringBuilder rebuiltPrefix = new StringBuilder();
        for (int i = 0; i < scopeStrings.length; ++i) {
            String scopeString = scopeStrings[i];
            LinkedList<Scope> scopes = new LinkedList<Scope>();
            if (scopeString.contains("^")) {
                String fixedFormat;
                if (i == 0 && !(fixedFormat = Pattern.specificFixedFormat(scopeString)).isEmpty()) {
                    return Pattern.parse(fixedFormat + Pattern.rebuiltSuffix(scopeStrings, i + 1), estDate);
                }
                String[] fixedParts = scopeString.trim().replace("[", "").replace("]", "").split("\\^");
                String type = fixedParts[0].replace("(", "").replace(")", "").trim();
                if (fixedParts.length > 1) {
                    String[] fixedValueParts;
                    String fixedValueString = fixedParts[1].trim().replace("(", "").replace(")", "");
                    if (fixedValueString.contains("-")) {
                        String[] rangeParts = fixedValueString.split("-");
                        String low = rangeParts[0].trim();
                        String high = rangeParts[1].trim();
                        fixedValueParts = Pattern.numberRangeValues(low, high);
                    } else {
                        fixedValueParts = fixedValueString.split(",");
                    }
                    for (String fixedValuePart : fixedValueParts) {
                        int fixedValue = Integer.parseInt(fixedValuePart.trim());
                        if (parentScopes.isEmpty()) {
                            scopes.add(Pattern.fixedScope(null, type, fixedValue));
                            roots.add((Scope)scopes.get(scopes.size() - 1));
                            continue;
                        }
                        for (Scope parent : parentScopes) {
                            scopes.add(Pattern.fixedScope(parent, type, fixedValue));
                        }
                    }
                }
            } else {
                String low;
                String[] scopeParts = scopeString.trim().replace("[", "").replace("]", "").split("\\|");
                int[] extras = Pattern.getRepeatExtras(scopeParts);
                int offset = extras[0];
                int interval = extras[1];
                String type = scopeParts[0].trim().replace("(", "").replace(")", "");
                if (type.matches(".*[0-9]{4}")) {
                    String[] typeValues;
                    if (type.contains("-")) {
                        String[] rangeParts = type.split("-");
                        low = rangeParts[0].trim();
                        String high = rangeParts[1].trim();
                        typeValues = Pattern.numberRangeValues(low, high);
                    } else {
                        typeValues = type.split(",");
                    }
                    return Pattern.parse(Pattern.specificYearsFormat(typeValues) + Pattern.rebuiltSuffix(scopeStrings, i + 1), estDate);
                }
                if (Pattern.monthNumber(type) > 0) {
                    String[] typeValues;
                    if (type.contains("-")) {
                        String[] rangeParts = type.split("-");
                        low = rangeParts[0].trim();
                        String high = rangeParts[1].trim();
                        typeValues = Pattern.monthRangeValues(low, high);
                    } else {
                        typeValues = type.split(",");
                    }
                    return Pattern.parse(rebuiltPrefix + Pattern.specificMonthsFormat(typeValues, i, offset, interval) + Pattern.rebuiltSuffix(scopeStrings, i + 1), estDate);
                }
                if (Pattern.dayOfWeekNumber(type) > 0) {
                    String[] typeValues;
                    if (type.contains("-")) {
                        String[] rangeParts = type.split("-");
                        low = rangeParts[0].trim();
                        String high = rangeParts[1].trim();
                        typeValues = Pattern.dayOfWeekRangeValues(low, high);
                    } else {
                        typeValues = type.split(",");
                    }
                    return Pattern.parse(rebuiltPrefix + Pattern.specificDaysOfWeekFormat(typeValues, offset, interval) + Pattern.rebuiltSuffix(scopeStrings, i + 1), estDate);
                }
                if (Pattern.hourOfDayNumber(type) > 0) {
                    String[] typeValues;
                    if (type.contains("-")) {
                        String[] rangeParts = type.split("-");
                        low = rangeParts[0].trim();
                        String high = rangeParts[1].trim();
                        typeValues = Pattern.hourOfDayRangeValues(low, high);
                    } else {
                        typeValues = type.split(",");
                    }
                    return Pattern.parse(rebuiltPrefix + Pattern.specificHoursFormat(typeValues, offset, interval) + Pattern.rebuiltSuffix(scopeStrings, i + 1), estDate);
                }
                if (parentScopes.isEmpty()) {
                    scopes.add(Pattern.repeatScope(null, estDate, type, offset, interval));
                    roots.add((Scope)scopes.get(scopes.size() - 1));
                } else {
                    for (Scope parent : parentScopes) {
                        scopes.add(Pattern.repeatScope(parent, estDate, type, offset, interval));
                    }
                }
            }
            allScopes.addAll(scopes);
            parentScopes.clear();
            parentScopes.addAll(scopes);
            rebuiltPrefix.append(scopeString).append("->");
        }
        return new Pattern(roots.toArray(new Scope[0]), allScopes.toArray(new Scope[0]));
    }

    private static String removeRepeatScopes(String pattern) {
        String[] scopeStrings = pattern.trim().split("->");
        StringBuilder rebuiltPattern = new StringBuilder();
        HashSet<String> scopeTypes = new HashSet<String>();
        for (int i = 0; i < scopeStrings.length; ++i) {
            String type;
            String scopeString = scopeStrings[i].replace("[", "").replace("]", "").replace("(", "").replace(")", "");
            if (scopeString.contains("^")) {
                type = scopeString.split("\\^")[0].trim().toLowerCase();
                if (scopeTypes.contains(type)) continue;
                scopeTypes.add(type);
                rebuiltPattern.append(scopeStrings[i]);
                rebuiltPattern.append("->");
                continue;
            }
            type = scopeString.split("\\|")[0].trim().toLowerCase();
            if (scopeTypes.contains(type)) continue;
            scopeTypes.add(type);
            rebuiltPattern.append(scopeStrings[i]);
            rebuiltPattern.append("->");
        }
        return rebuiltPattern.substring(0, rebuiltPattern.length() - 2);
    }

    private static String rebuiltSuffix(String[] scopeStrings, int fromIndex) {
        StringBuilder sb = new StringBuilder();
        for (int i = fromIndex; i < scopeStrings.length; ++i) {
            sb.append("->");
            sb.append(scopeStrings[i]);
        }
        return sb.toString();
    }

    private static Scope fixedScope(Scope parent, String type, int value) {
        switch (type.toLowerCase()) {
            case "y": {
                return new YearScope(parent, value);
            }
            case "m": {
                return new MonthScope(parent, value);
            }
            case "w": {
                return new WeekScope(parent, value);
            }
            case "d": {
                return new DayScope(parent, value);
            }
            case "h": {
                return new HourScope(parent, value);
            }
        }
        return null;
    }

    private static Scope repeatScope(Scope parent, Date estDate, String type, int offset, int interval) {
        switch (type.toLowerCase()) {
            case "y": {
                return new YearScope(estDate, offset, interval);
            }
            case "m": {
                if (parent != null) {
                    return new MonthScope(parent, offset, interval);
                }
                return new MonthScope(estDate, offset, interval);
            }
            case "w": {
                if (parent != null) {
                    return new WeekScope(parent, offset, interval);
                }
                return new WeekScope(estDate, offset, interval);
            }
            case "d": {
                if (parent != null) {
                    return new DayScope(parent, offset, interval);
                }
                return new DayScope(estDate, offset, interval);
            }
            case "h": {
                if (parent != null) {
                    return new HourScope(parent, offset, interval);
                }
                return new HourScope(estDate, offset, interval);
            }
        }
        return null;
    }

    private static int[] getRepeatExtras(String[] scopeParts) {
        int offset = 0;
        int interval = 1;
        String[] extraParts = new String[]{};
        if (scopeParts.length > 1) {
            extraParts = new String[]{scopeParts[1].trim()};
        }
        if (scopeParts.length > 2) {
            extraParts = new String[]{scopeParts[1].trim(), scopeParts[2].trim()};
        }
        for (String part : extraParts) {
            if (part.startsWith("~")) {
                offset = Integer.parseInt(part.substring(1));
                continue;
            }
            interval = Integer.parseInt(part);
        }
        return new int[]{offset, interval};
    }

    private static String specificFixedFormat(String scopeString) {
        if (scopeString.toLowerCase().contains("m")) {
            return "[Y]->" + scopeString;
        }
        if (scopeString.toLowerCase().contains("w") || scopeString.toLowerCase().contains("d")) {
            return "[M]->" + scopeString;
        }
        return "";
    }

    private static String specificYearsFormat(String[] years) {
        StringBuilder yearsCsv = new StringBuilder();
        for (String year : years) {
            yearsCsv.append(year).append(",");
        }
        return "[Y^" + yearsCsv.substring(0, yearsCsv.length() - 1) + "]";
    }

    private static String specificMonthsFormat(String[] months, int scopeIndex, int offset, int interval) {
        StringBuilder monthCsv = new StringBuilder();
        for (String month : months) {
            monthCsv.append(Pattern.monthNumber(month)).append(",");
        }
        Object format = "";
        if (scopeIndex == 0) {
            format = (String)format + "[Y|~" + offset + "|" + interval + "]->";
        }
        format = (String)format + "[M^" + monthCsv.substring(0, monthCsv.length() - 1) + "]";
        return format;
    }

    private static int monthNumber(String month) {
        String lcMonth = month.toLowerCase().trim();
        if (lcMonth.startsWith("jan")) {
            return 1;
        }
        if (lcMonth.startsWith("feb")) {
            return 2;
        }
        if (lcMonth.startsWith("mar")) {
            return 3;
        }
        if (lcMonth.startsWith("apr")) {
            return 4;
        }
        if (lcMonth.startsWith("may")) {
            return 5;
        }
        if (lcMonth.startsWith("jun")) {
            return 6;
        }
        if (lcMonth.startsWith("jul")) {
            return 7;
        }
        if (lcMonth.startsWith("aug")) {
            return 8;
        }
        if (lcMonth.startsWith("sep")) {
            return 9;
        }
        if (lcMonth.startsWith("oct")) {
            return 10;
        }
        if (lcMonth.startsWith("nov")) {
            return 11;
        }
        if (lcMonth.startsWith("dec")) {
            return 12;
        }
        return -1;
    }

    private static String month(int number) {
        if (number == 1) {
            return "jan";
        }
        if (number == 2) {
            return "feb";
        }
        if (number == 3) {
            return "mar";
        }
        if (number == 4) {
            return "apr";
        }
        if (number == 5) {
            return "may";
        }
        if (number == 6) {
            return "jun";
        }
        if (number == 7) {
            return "jul";
        }
        if (number == 8) {
            return "aug";
        }
        if (number == 9) {
            return "sep";
        }
        if (number == 10) {
            return "oct";
        }
        if (number == 11) {
            return "nov";
        }
        if (number == 12) {
            return "dec";
        }
        return "";
    }

    private static String specificDaysOfWeekFormat(String[] daysOfWeek, int offset, int interval) {
        StringBuilder daysOfWeekCsv = new StringBuilder();
        for (String day : daysOfWeek) {
            daysOfWeekCsv.append(Pattern.dayOfWeekNumber(day)).append(",");
        }
        return "[W|~" + offset + "|" + interval + "]->[D^" + daysOfWeekCsv.substring(0, daysOfWeekCsv.length() - 1) + "]";
    }

    private static int dayOfWeekNumber(String dayOfWeek) {
        String lcDayOfWeek = dayOfWeek.toLowerCase().trim();
        if (lcDayOfWeek.startsWith("mo")) {
            return 1;
        }
        if (lcDayOfWeek.startsWith("tu")) {
            return 2;
        }
        if (lcDayOfWeek.startsWith("we")) {
            return 3;
        }
        if (lcDayOfWeek.startsWith("th")) {
            return 4;
        }
        if (lcDayOfWeek.startsWith("fr")) {
            return 5;
        }
        if (lcDayOfWeek.startsWith("sa")) {
            return 6;
        }
        if (lcDayOfWeek.startsWith("su")) {
            return 7;
        }
        return -1;
    }

    private static String dayOfWeek(int number) {
        if (number == 1) {
            return "mo";
        }
        if (number == 2) {
            return "tu";
        }
        if (number == 3) {
            return "we";
        }
        if (number == 4) {
            return "th";
        }
        if (number == 5) {
            return "fr";
        }
        if (number == 6) {
            return "sa";
        }
        if (number == 7) {
            return "su";
        }
        return "";
    }

    private static String specificHoursFormat(String[] hoursOfDay, int offset, int interval) {
        StringBuilder hoursOfDayCsv = new StringBuilder();
        for (String hour : hoursOfDay) {
            hoursOfDayCsv.append(Pattern.hourOfDayNumber(hour)).append(",");
        }
        return "[W|~" + offset + "|" + interval + "]->[H^" + hoursOfDayCsv.substring(0, hoursOfDayCsv.length() - 1) + "]";
    }

    private static int hourOfDayNumber(String dayOfWeek) {
        String lcHour = dayOfWeek.toLowerCase().trim().replace(" ", "");
        if (lcHour.startsWith("12am")) {
            return 0;
        }
        if (lcHour.startsWith("1am")) {
            return 1;
        }
        if (lcHour.startsWith("2am")) {
            return 2;
        }
        if (lcHour.startsWith("3am")) {
            return 3;
        }
        if (lcHour.startsWith("4am")) {
            return 4;
        }
        if (lcHour.startsWith("5am")) {
            return 5;
        }
        if (lcHour.startsWith("6am")) {
            return 6;
        }
        if (lcHour.startsWith("7am")) {
            return 7;
        }
        if (lcHour.startsWith("8am")) {
            return 8;
        }
        if (lcHour.startsWith("9am")) {
            return 9;
        }
        if (lcHour.startsWith("10am")) {
            return 10;
        }
        if (lcHour.startsWith("11am")) {
            return 11;
        }
        if (lcHour.startsWith("12pm")) {
            return 12;
        }
        if (lcHour.startsWith("1pm")) {
            return 13;
        }
        if (lcHour.startsWith("2pm")) {
            return 14;
        }
        if (lcHour.startsWith("3pm")) {
            return 15;
        }
        if (lcHour.startsWith("4pm")) {
            return 16;
        }
        if (lcHour.startsWith("5pm")) {
            return 17;
        }
        if (lcHour.startsWith("6pm")) {
            return 18;
        }
        if (lcHour.startsWith("7pm")) {
            return 19;
        }
        if (lcHour.startsWith("8pm")) {
            return 20;
        }
        if (lcHour.startsWith("9pm")) {
            return 21;
        }
        if (lcHour.startsWith("10pm")) {
            return 22;
        }
        if (lcHour.startsWith("11pm")) {
            return 23;
        }
        return -1;
    }

    private static String hourOfDay(int number) {
        if (number == 0) {
            return "12am";
        }
        if (number == 1) {
            return "1am";
        }
        if (number == 2) {
            return "2am";
        }
        if (number == 3) {
            return "3am";
        }
        if (number == 4) {
            return "4am";
        }
        if (number == 5) {
            return "5am";
        }
        if (number == 6) {
            return "6am";
        }
        if (number == 7) {
            return "7am";
        }
        if (number == 8) {
            return "8am";
        }
        if (number == 9) {
            return "9am";
        }
        if (number == 10) {
            return "10am";
        }
        if (number == 11) {
            return "11am";
        }
        if (number == 12) {
            return "12pm";
        }
        if (number == 13) {
            return "1pm";
        }
        if (number == 14) {
            return "2pm";
        }
        if (number == 15) {
            return "3pm";
        }
        if (number == 16) {
            return "4pm";
        }
        if (number == 17) {
            return "5pm";
        }
        if (number == 18) {
            return "6pm";
        }
        if (number == 19) {
            return "7pm";
        }
        if (number == 20) {
            return "8pm";
        }
        if (number == 21) {
            return "9pm";
        }
        if (number == 22) {
            return "10pm";
        }
        if (number == 23) {
            return "11pm";
        }
        return "";
    }

    private static String[] numberRangeValues(String low, String high) {
        int lowNum = Integer.parseInt(low);
        int highNum = Integer.parseInt(high);
        if (highNum < lowNum) {
            int temp = highNum;
            highNum = lowNum;
            lowNum = temp;
        }
        String[] values = new String[highNum - lowNum + 1];
        for (int i = lowNum; i <= highNum; ++i) {
            values[i - lowNum] = String.valueOf(i);
        }
        return values;
    }

    private static String[] monthRangeValues(String low, String high) {
        int lowNum = Pattern.monthNumber(low);
        int highNum = Pattern.monthNumber(high);
        if (highNum < lowNum) {
            int temp = highNum;
            highNum = lowNum;
            lowNum = temp;
        }
        String[] values = new String[highNum - lowNum + 1];
        for (int i = lowNum; i <= highNum; ++i) {
            values[i - lowNum] = Pattern.month(i);
        }
        return values;
    }

    private static String[] dayOfWeekRangeValues(String low, String high) {
        int lowNum = Pattern.dayOfWeekNumber(low);
        int highNum = Pattern.dayOfWeekNumber(high);
        if (highNum < lowNum) {
            int temp = highNum;
            highNum = lowNum;
            lowNum = temp;
        }
        String[] values = new String[highNum - lowNum + 1];
        for (int i = lowNum; i <= highNum; ++i) {
            values[i - lowNum] = Pattern.dayOfWeek(i);
        }
        return values;
    }

    private static String[] hourOfDayRangeValues(String low, String high) {
        int lowNum = Pattern.hourOfDayNumber(low);
        int highNum = Pattern.hourOfDayNumber(high);
        if (highNum == 0) {
            highNum = 24;
        }
        if (highNum < lowNum) {
            int temp = highNum;
            highNum = lowNum;
            lowNum = temp;
        } else if (highNum == lowNum) {
            return new String[]{Pattern.hourOfDay(highNum)};
        }
        String[] values = new String[--highNum - lowNum + 1];
        for (int i = lowNum; i <= highNum; ++i) {
            values[i - lowNum] = Pattern.hourOfDay(i);
        }
        return values;
    }
}

