/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg;

import com.ericversteeg.XpGoalsConfig;
import com.ericversteeg.XpGoalsOverlay;
import com.ericversteeg.config.DayCadence;
import com.ericversteeg.config.Hour;
import com.ericversteeg.goal.Goal;
import com.ericversteeg.goal.GoalData;
import com.ericversteeg.goal.ResetType;
import com.ericversteeg.pattern.Pattern;
import com.google.gson.Gson;
import com.google.inject.Provides;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.StatChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.RuneScapeProfileChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Xp Goalz", description="Track xp goals.")
public class XpGoalsPlugin
extends Plugin {
    @Inject
    private XpGoalsOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    private XpGoalsConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private Gson gson;
    private static String DATA_KEY = "xp_goals_data_3";
    GoalData goalData;
    ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(LocalDate.now().atStartOfDay());
    LocalDateTime lastDateTime = null;
    boolean progressUpdated = false;
    private Map<Integer, Integer> skillsXp = new HashMap<Integer, Integer>();

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onRuneScapeProfileChanged(RuneScapeProfileChanged e) {
        String profile = this.configManager.getRSProfileKey();
        if (profile != null) {
            this.goalData = this.getSavedData();
            this.checkResets();
        } else {
            this.goalData = new GoalData();
            this.configSyncGoals();
        }
    }

    @Provides
    XpGoalsConfig provideConfig(ConfigManager configManager) {
        return (XpGoalsConfig)configManager.getConfig(XpGoalsConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged config) {
        this.configSyncGoals();
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.checkResets();
        if (this.progressUpdated) {
            this.writeSavedData();
        }
        this.progressUpdated = false;
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        Skill skill = statChanged.getSkill();
        int xp = statChanged.getXp();
        Goal goal = this.goalForSkillId(skill.ordinal());
        if (goal != null && goal.track) {
            int lastXp = xp;
            if (this.skillsXp.containsKey(skill.ordinal())) {
                lastXp = this.skillsXp.get(skill.ordinal());
            }
            if (goal.progressXp < 0) {
                goal.progressXp = 0;
            }
            goal.progressXp += xp - lastXp;
            this.progressUpdated = true;
        }
        this.skillsXp.put(skill.ordinal(), xp);
    }

    private void checkResets() {
        LocalDateTime dateTIme;
        if (this.goalData == null) {
            this.goalData = new GoalData();
        }
        if (this.lastDateTime == null) {
            this.lastDateTime = LocalDateTime.ofEpochSecond(this.goalData.lastCheck, 0, this.zoneOffset);
        }
        if ((dateTIme = LocalDateTime.now()).get(ChronoField.HOUR_OF_DAY) != this.lastDateTime.get(ChronoField.HOUR_OF_DAY) || dateTIme.get(ChronoField.DAY_OF_MONTH) != this.lastDateTime.get(ChronoField.DAY_OF_MONTH) || dateTIme.get(ChronoField.MONTH_OF_YEAR) != this.lastDateTime.get(ChronoField.MONTH_OF_YEAR) || dateTIme.get(ChronoField.YEAR) != this.lastDateTime.get(ChronoField.YEAR)) {
            this.resetGoals(0);
            this.configSyncGoals();
        }
        if (dateTIme.get(ChronoField.DAY_OF_MONTH) != this.lastDateTime.get(ChronoField.DAY_OF_MONTH) || dateTIme.get(ChronoField.MONTH_OF_YEAR) != this.lastDateTime.get(ChronoField.MONTH_OF_YEAR) || dateTIme.get(ChronoField.YEAR) != this.lastDateTime.get(ChronoField.YEAR)) {
            this.resetGoals(1);
        }
        if (dateTIme.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR) != this.lastDateTime.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR) || dateTIme.get(ChronoField.YEAR) != this.lastDateTime.get(ChronoField.YEAR)) {
            this.resetGoals(2);
        }
        if (dateTIme.get(ChronoField.MONTH_OF_YEAR) != this.lastDateTime.get(ChronoField.MONTH_OF_YEAR) || dateTIme.get(ChronoField.YEAR) != this.lastDateTime.get(ChronoField.YEAR)) {
            this.resetGoals(3);
        }
        if (dateTIme.get(ChronoField.YEAR) != this.lastDateTime.get(ChronoField.YEAR)) {
            this.resetGoals(4);
        }
        this.goalData.lastCheck = dateTIme.toEpochSecond(this.zoneOffset);
        this.lastDateTime = dateTIme;
    }

    private void resetGoals(int resetType) {
        for (Goal goal : this.goalData.goals) {
            if (goal.resetType != resetType) continue;
            goal.reset();
        }
        this.writeSavedData();
    }

    GoalData getSavedData() {
        String profile = this.configManager.getRSProfileKey();
        String json = this.configManager.getConfiguration("xpgoals_3", profile, DATA_KEY);
        if (json == null) {
            return new GoalData();
        }
        GoalData savedData = (GoalData)this.gson.fromJson(json, GoalData.class);
        if (savedData == null) {
            return new GoalData();
        }
        return savedData;
    }

    void writeSavedData() {
        String profile = this.configManager.getRSProfileKey();
        if (profile != null) {
            String json = this.gson.toJson((Object)this.goalData);
            this.configManager.setConfiguration("xpgoals_3", profile, DATA_KEY, json);
        }
    }

    void configSyncGoals() {
        if (this.goalData == null) {
            this.goalData = new GoalData();
        }
        if (this.goalData.goals.isEmpty()) {
            this.goalData.goals = Arrays.asList(new Goal(Skill.ATTACK.ordinal()), new Goal(Skill.STRENGTH.ordinal()), new Goal(Skill.DEFENCE.ordinal()), new Goal(Skill.RANGED.ordinal()), new Goal(Skill.PRAYER.ordinal()), new Goal(Skill.MAGIC.ordinal()), new Goal(Skill.RUNECRAFT.ordinal()), new Goal(Skill.CONSTRUCTION.ordinal()), new Goal(Skill.HITPOINTS.ordinal()), new Goal(Skill.AGILITY.ordinal()), new Goal(Skill.HERBLORE.ordinal()), new Goal(Skill.THIEVING.ordinal()), new Goal(Skill.CRAFTING.ordinal()), new Goal(Skill.FLETCHING.ordinal()), new Goal(Skill.SLAYER.ordinal()), new Goal(Skill.HUNTER.ordinal()), new Goal(Skill.MINING.ordinal()), new Goal(Skill.SMITHING.ordinal()), new Goal(Skill.FISHING.ordinal()), new Goal(Skill.COOKING.ordinal()), new Goal(Skill.FIREMAKING.ordinal()), new Goal(Skill.WOODCUTTING.ordinal()), new Goal(Skill.FARMING.ordinal()));
        }
        for (Goal goal : this.goalData.goals) {
            int skillId = goal.skillId;
            boolean enabled = this.isGoalEnabled(skillId);
            boolean hidden = this.isSkillHidden(skillId);
            boolean track = enabled;
            int goalXp = this.goalXp(skillId);
            ResetType resetType = this.goalResetType(skillId);
            boolean oneValidPattern = false;
            boolean patternError = false;
            if (enabled) {
                track = false;
                try {
                    String[] patterns;
                    LinkedList<Object> patternsList = new LinkedList<Object>();
                    String dayOfWeekPatternPart = this.dayOfWeekPatternPart(skillId);
                    String dayCadencePatternPart = this.dayCadencePatternPart(skillId);
                    String hourPatternPart = this.hourPatternPart(skillId);
                    String customPatterns = this.customPatterns(skillId);
                    if (!customPatterns.trim().isEmpty()) {
                        patternsList.addAll(Arrays.asList(customPatterns.split("\n")));
                    }
                    if (dayOfWeekPatternPart != null) {
                        if (hourPatternPart != null) {
                            patternsList.add(dayOfWeekPatternPart + "->" + hourPatternPart);
                        } else {
                            patternsList.add(dayOfWeekPatternPart);
                        }
                    }
                    if (dayCadencePatternPart != null) {
                        if (hourPatternPart != null) {
                            patternsList.add(dayCadencePatternPart + "->" + hourPatternPart);
                        } else {
                            patternsList.add(dayCadencePatternPart);
                        }
                    }
                    if (dayOfWeekPatternPart == null && dayCadencePatternPart == null && hourPatternPart != null) {
                        patternsList.add(hourPatternPart);
                    }
                    for (String patternStr : patterns = patternsList.toArray(new String[0])) {
                        if (patternStr.trim().isEmpty()) continue;
                        oneValidPattern = true;
                        String pattern = "";
                        int xp = goalXp;
                        if (patternStr.contains("=")) {
                            String[] patternParts = patternStr.split("=");
                            pattern = patternParts[0].trim();
                            if (patternParts.length > 1) {
                                xp = Integer.parseInt(patternParts[1].replace(",", "").replace(" ", "").trim());
                            }
                        } else {
                            pattern = patternStr;
                        }
                        if (!Pattern.parse(pattern, new Date()).matches()) continue;
                        goalXp = xp;
                        track = true;
                    }
                }
                catch (Exception exception) {
                    patternError = true;
                }
            } else if (goal.resetType == 5) {
                goal.reset();
                this.writeSavedData();
            }
            if (!oneValidPattern || patternError) {
                track = enabled;
            }
            goal.resetType = resetType.ordinal();
            goal.enabled = enabled;
            goal.track = track && !hidden;
            goal.goalXp = goalXp;
        }
    }

    Skill skillForSkillId(int skillId) {
        if (skillId == Skill.MINING.ordinal()) {
            return Skill.MINING;
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return Skill.RUNECRAFT;
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return Skill.AGILITY;
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return Skill.FISHING;
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return Skill.WOODCUTTING;
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return Skill.FARMING;
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return Skill.RANGED;
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return Skill.SLAYER;
        }
        if (skillId == Skill.ATTACK.ordinal()) {
            return Skill.ATTACK;
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return Skill.DEFENCE;
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return Skill.STRENGTH;
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return Skill.MAGIC;
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return Skill.PRAYER;
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return Skill.CONSTRUCTION;
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return Skill.HITPOINTS;
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return Skill.HERBLORE;
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return Skill.THIEVING;
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return Skill.CRAFTING;
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return Skill.FLETCHING;
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return Skill.HUNTER;
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return Skill.SMITHING;
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return Skill.COOKING;
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return Skill.FIREMAKING;
        }
        return null;
    }

    Goal goalForSkillId(int skillId) {
        for (Goal goal : this.goalData.goals) {
            if (goal.skillId != skillId) continue;
            return goal;
        }
        return null;
    }

    boolean isSkillHidden(int skillId) {
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.hideAttack();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.hideStrength();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.hideDefense();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.hideRanged();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.hidePrayer();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.hideMagic();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.hideRunecrafting();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.hideConstruction();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.hideHitpoints();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.hideAgility();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.hideHerblore();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.hideThieving();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.hideCrafting();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.hideFletching();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.hideSlayer();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.hideHunter();
        }
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.hideMining();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.hideSmithing();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.hideFishing();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.hideCooking();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.hideFiremaking();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.hideWoodcutting();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.hideFarming();
        }
        return true;
    }

    boolean isGoalEnabled(int skillId) {
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.enableMiningSkill();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.enableRunecraftingSkill();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.enableAgilitySkill();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.enableFishingSkill();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.enableWoodcuttingSkill();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.enableFarmingSkill();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.enableRangedSkill();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.enableSlayerSkill();
        }
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.enableAttackSkill();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.enableDefenseSkill();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.enableStrengthSkill();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.enableMagicSkill();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.enablePrayerSkill();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.enableConstructionSkill();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.enableHitpointsSkill();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.enableHerbloreSkill();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.enableThievingSkill();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.enableCraftingSkill();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.enableFletchingSkill();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.enableHunterSkill();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.enableSmithingSkill();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.enableCookingSkill();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.enableFiremakingSkill();
        }
        return false;
    }

    ResetType goalResetType(int skillId) {
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.miningResetType();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.runecraftingResetType();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.agilityResetType();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.fishingResetType();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.woodcuttingResetType();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.farmingResetType();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.rangedResetType();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.slayerResetType();
        }
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.attackResetType();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.defenseResetType();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.strengthResetType();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.magicResetType();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.prayerResetType();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.constructionResetType();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.hitpointsResetType();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.herbloreResetType();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.thievingResetType();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.craftingResetType();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.fletchingResetType();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.hunterResetType();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.smithingResetType();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.cookingResetType();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.firemakingResetType();
        }
        return ResetType.NONE;
    }

    int goalXp(int skillId) {
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.miningXpGoal();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.runecraftingXpGoal();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.agilityXpGoal();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.fishingXpGoal();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.woodcuttingXpGoal();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.farmingXpGoal();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.rangedXpGoal();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.slayerXpGoal();
        }
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.attackXpGoal();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.defenseXpGoal();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.strengthXpGoal();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.magicXpGoal();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.prayerXpGoal();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.constructionXpGoal();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.hitpointsXpGoal();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.herbloreXpGoal();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.thievingXpGoal();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.craftingXpGoal();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.fletchingXpGoal();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.hunterXpGoal();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.smithingXpGoal();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.cookingXpGoal();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.firemakingXpGoal();
        }
        return 0;
    }

    String customPatterns(int skillId) {
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.miningPattens();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.runecraftingPattens();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.agilityPattens();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.fishingPattens();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.woodcuttingPattens();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.farmingPattens();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.rangedPattens();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.slayerPattens();
        }
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.attackPattens();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.defensePattens();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.strengthPattens();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.magicPattens();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.prayerPattens();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.constructionPattens();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.hitpointsPattens();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.herblorePattens();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.thievingPattens();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.craftingPattens();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.fletchingPattens();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.hunterPattens();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.smithingPattens();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.cookingPattens();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.firemakingPattens();
        }
        return "";
    }

    boolean isMonday(int skillId) {
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.attackMonday();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.strengthMonday();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.defenseMonday();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.rangedMonday();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.prayerMonday();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.magicMonday();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.runecraftingMonday();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.constructionMonday();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.hitpointsMonday();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.agilityMonday();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.herbloreMonday();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.thievingMonday();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.craftingMonday();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.fletchingMonday();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.slayerMonday();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.hunterMonday();
        }
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.miningMonday();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.smithingMonday();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.fishingMonday();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.cookingMonday();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.firemakingMonday();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.woodcuttingMonday();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.farmingMonday();
        }
        return false;
    }

    boolean isTuesday(int skillId) {
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.attackTuesday();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.strengthTuesday();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.defenseTuesday();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.rangedTuesday();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.prayerTuesday();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.magicTuesday();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.runecraftingTuesday();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.constructionTuesday();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.hitpointsTuesday();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.agilityTuesday();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.herbloreTuesday();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.thievingTuesday();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.craftingTuesday();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.fletchingTuesday();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.slayerTuesday();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.hunterTuesday();
        }
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.miningTuesday();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.smithingTuesday();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.fishingTuesday();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.cookingTuesday();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.firemakingTuesday();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.woodcuttingTuesday();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.farmingTuesday();
        }
        return false;
    }

    boolean isWednesday(int skillId) {
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.attackWednesday();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.strengthWednesday();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.defenseWednesday();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.rangedWednesday();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.prayerWednesday();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.magicWednesday();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.runecraftingWednesday();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.constructionWednesday();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.hitpointsWednesday();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.agilityWednesday();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.herbloreWednesday();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.thievingWednesday();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.craftingWednesday();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.fletchingWednesday();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.slayerWednesday();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.hunterWednesday();
        }
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.miningWednesday();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.smithingWednesday();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.fishingWednesday();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.cookingWednesday();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.firemakingWednesday();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.woodcuttingWednesday();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.farmingWednesday();
        }
        return false;
    }

    boolean isThursday(int skillId) {
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.attackThursday();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.strengthThursday();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.defenseThursday();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.rangedThursday();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.prayerThursday();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.magicThursday();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.runecraftingThursday();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.constructionThursday();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.hitpointsThursday();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.agilityThursday();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.herbloreThursday();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.thievingThursday();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.craftingThursday();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.fletchingThursday();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.slayerThursday();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.hunterThursday();
        }
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.miningThursday();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.smithingThursday();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.fishingThursday();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.cookingThursday();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.firemakingThursday();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.woodcuttingThursday();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.farmingThursday();
        }
        return false;
    }

    boolean isFriday(int skillId) {
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.attackFriday();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.strengthFriday();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.defenseFriday();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.rangedFriday();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.prayerFriday();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.magicFriday();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.runecraftingFriday();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.constructionFriday();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.hitpointsFriday();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.agilityFriday();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.herbloreFriday();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.thievingFriday();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.craftingFriday();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.fletchingFriday();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.slayerFriday();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.hunterFriday();
        }
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.miningFriday();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.smithingFriday();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.fishingFriday();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.cookingFriday();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.firemakingFriday();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.woodcuttingFriday();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.farmingFriday();
        }
        return false;
    }

    boolean isSaturday(int skillId) {
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.attackSaturday();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.strengthSaturday();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.defenseSaturday();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.rangedSaturday();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.prayerSaturday();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.magicSaturday();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.runecraftingSaturday();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.constructionSaturday();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.hitpointsSaturday();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.agilitySaturday();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.herbloreSaturday();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.thievingSaturday();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.craftingSaturday();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.fletchingSaturday();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.slayerSaturday();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.hunterSaturday();
        }
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.miningSaturday();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.smithingSaturday();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.fishingSaturday();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.cookingSaturday();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.firemakingSaturday();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.woodcuttingSaturday();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.farmingSaturday();
        }
        return false;
    }

    boolean isSunday(int skillId) {
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.attackSunday();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.strengthSunday();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.defenseSunday();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.rangedSunday();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.prayerSunday();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.magicSunday();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.runecraftingSunday();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.constructionSunday();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.hitpointsSunday();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.agilitySunday();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.herbloreSunday();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.thievingSunday();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.craftingSunday();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.fletchingSunday();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.slayerSunday();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.hunterSunday();
        }
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.miningSunday();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.smithingSunday();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.fishingSunday();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.cookingSunday();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.firemakingSunday();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.woodcuttingSunday();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.farmingSunday();
        }
        return false;
    }

    Hour startTime(int skillId) {
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.attackStartTime();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.strengthStartTime();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.defenseStartTime();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.rangedStartTime();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.prayerStartTime();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.magicStartTime();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.runecraftingStartTime();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.constructionStartTime();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.hitpointsStartTime();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.agilityStartTime();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.herbloreStartTime();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.thievingStartTime();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.craftingStartTime();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.fletchingStartTime();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.slayerStartTime();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.hunterStartTime();
        }
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.miningStartTime();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.smithingStartTime();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.fishingStartTime();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.cookingStartTime();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.firemakingStartTime();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.woodcuttingStartTime();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.farmingStartTime();
        }
        return Hour.NONE;
    }

    Hour endTime(int skillId) {
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.attackEndTime();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.strengthEndTime();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.defenseEndTime();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.rangedEndTime();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.prayerEndTime();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.magicEndTime();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.runecraftingEndTime();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.constructionEndTime();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.hitpointsEndTime();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.agilityEndTime();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.herbloreEndTime();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.thievingEndTime();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.craftingEndTime();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.fletchingEndTime();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.slayerEndTime();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.hunterEndTime();
        }
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.miningEndTime();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.smithingEndTime();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.fishingEndTime();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.cookingEndTime();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.firemakingEndTime();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.woodcuttingEndTime();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.farmingEndTime();
        }
        return Hour.NONE;
    }

    DayCadence dayCadence(int skillId) {
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.attackDayCadence();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.strengthDayCadence();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.defenseDayCadence();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.rangedDayCadence();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.prayerDayCadence();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.magicDayCadence();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.runecraftingDayCadence();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.constructionDayCadence();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.hitpointsDayCadence();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.agilityDayCadence();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.herbloreDayCadence();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.thievingDayCadence();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.craftingDayCadence();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.fletchingDayCadence();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.slayerDayCadence();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.hunterDayCadence();
        }
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.miningDayCadence();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.smithingDayCadence();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.fishingDayCadence();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.cookingDayCadence();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.firemakingDayCadence();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.woodcuttingDayCadence();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.farmingDayCadence();
        }
        return DayCadence.NONE;
    }

    DayCadence dayCadenceDay(int skillId) {
        if (skillId == Skill.ATTACK.ordinal()) {
            return this.config.attackDayCadenceDay();
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return this.config.strengthDayCadenceDay();
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return this.config.defenseDayCadenceDay();
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return this.config.rangedDayCadenceDay();
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return this.config.prayerDayCadenceDay();
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return this.config.magicDayCadenceDay();
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return this.config.runecraftingDayCadenceDay();
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return this.config.constructionDayCadenceDay();
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return this.config.hitpointsDayCadenceDay();
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return this.config.agilityDayCadenceDay();
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return this.config.herbloreDayCadenceDay();
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return this.config.thievingDayCadenceDay();
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return this.config.craftingDayCadenceDay();
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return this.config.fletchingDayCadenceDay();
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return this.config.slayerDayCadenceDay();
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return this.config.hunterDayCadenceDay();
        }
        if (skillId == Skill.MINING.ordinal()) {
            return this.config.miningDayCadenceDay();
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return this.config.smithingDayCadenceDay();
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return this.config.fishingDayCadenceDay();
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return this.config.cookingDayCadenceDay();
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return this.config.firemakingDayCadenceDay();
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return this.config.woodcuttingDayCadenceDay();
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return this.config.farmingDayCadenceDay();
        }
        return DayCadence.NONE;
    }

    String dayOfWeekPatternPart(int skillId) {
        StringBuilder daysOfWeekSb = new StringBuilder();
        if (this.isMonday(skillId)) {
            daysOfWeekSb.append("Mo,");
        }
        if (this.isTuesday(skillId)) {
            daysOfWeekSb.append("Tu,");
        }
        if (this.isWednesday(skillId)) {
            daysOfWeekSb.append("We,");
        }
        if (this.isThursday(skillId)) {
            daysOfWeekSb.append("Th,");
        }
        if (this.isFriday(skillId)) {
            daysOfWeekSb.append("Fr,");
        }
        if (this.isSaturday(skillId)) {
            daysOfWeekSb.append("Sa,");
        }
        if (this.isSunday(skillId)) {
            daysOfWeekSb.append("Su,");
        }
        String dayPart = null;
        if (daysOfWeekSb.length() > 0) {
            String daysOfWeekCsv = daysOfWeekSb.substring(0, daysOfWeekSb.length() - 1);
            dayPart = "[W]->[" + daysOfWeekCsv + "]";
        }
        return dayPart;
    }

    String dayCadencePatternPart(int skillId) {
        DayCadence dayCadence = this.dayCadence(skillId);
        DayCadence cadenceDay = this.dayCadenceDay(skillId);
        String dayPart = null;
        if (dayCadence != DayCadence.NONE && cadenceDay != DayCadence.NONE && cadenceDay.ordinal() <= dayCadence.ordinal()) {
            int cadence = dayCadence.ordinal();
            int offset = cadenceDay.ordinal() - 1;
            dayPart = "[2023]->[D|~" + offset + "|" + cadence + "]";
        }
        return dayPart;
    }

    String hourPatternPart(int skillId) {
        Hour sHour = this.startTime(skillId);
        Hour eHour = this.endTime(skillId);
        String hourPart = null;
        if (sHour != Hour.NONE && eHour != Hour.NONE) {
            hourPart = "[" + sHour.getName() + "-" + eHour.getName() + "]";
        }
        return hourPart;
    }
}

