/*
 * Decompiled with CFR 0.152.
 */
package com.ericversteeg;

import com.ericversteeg.XpGoalsConfig;
import com.ericversteeg.XpGoalsPlugin;
import com.ericversteeg.bar.BarTextAlignment;
import com.ericversteeg.bar.BarTextPosition;
import com.ericversteeg.bar.BarTextSize;
import com.ericversteeg.bar.BarTextType;
import com.ericversteeg.bar.DoneTextType;
import com.ericversteeg.config.AnchorType;
import com.ericversteeg.goal.Goal;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.SkillColor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ComponentConstants;
import net.runelite.client.ui.overlay.components.TextComponent;
import net.runelite.client.util.ImageUtil;

class XpGoalsOverlay
extends Overlay {
    private int ICON_SIZE = 16;
    private final Client client;
    private final XpGoalsPlugin plugin;
    private final XpGoalsConfig config;
    private final SkillIconManager iconManager;
    Widget viewportWidget;
    private Font font;
    private Color outerBorderColor = new Color(57, 41, 13, 124);
    private Color innerBorderColor = new Color(147, 141, 130, 37);
    private Color pastProgressBgColor = new Color(30, 30, 30, 125);
    private Color barBackgroundColor = Color.decode("#1b1b1b");
    private Color barBorderColor = Color.decode("#0b0b0b");
    int panelTopPadding = 4;
    int panelBottomPadding = 4;
    int panelHPadding = 4;
    int iconRightPadding = 3;
    private int panelX;
    private int panelY;
    private int panelWidth;
    private int panelHeight;
    private int topSectionHeight;
    boolean textOutsideOverride = false;
    boolean hideTextOverride = false;
    private int anchorX;
    private int anchorY;
    private int tooltipWidth = 120;
    int tooltipHeight = 120;

    @Inject
    private XpGoalsOverlay(Client client, XpGoalsPlugin plugin, XpGoalsConfig config, SkillIconManager iconManager) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.iconManager = iconManager;
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            InputStream inRunescapeSmall = FontManager.class.getResourceAsStream("runescape_small.ttf");
            Font smallFont = Font.createFont(0, inRunescapeSmall).deriveFont(0, 12.0f);
            ge.registerFont(smallFont);
            this.font = smallFont;
        }
        catch (Exception e) {
            this.font = FontManager.getRunescapeSmallFont();
        }
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.UNDER_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        this.viewportWidget = this.getViewportWidget();
        List<Goal> goals = this.getTrackedGoals();
        Point mouse = this.client.getMouseCanvasPosition();
        int mouseX = mouse.getX();
        int mouseY = mouse.getY();
        boolean hideIcons = this.config.hideSkillIcons();
        this.ICON_SIZE = hideIcons ? 0 : 16;
        AnchorType anchorType = this.config.anchorType();
        BarTextType textType = this.config.barTextType();
        BarTextPosition textPosition = this.config.barTextPosition();
        BarTextSize textSize = this.config.barTextSize();
        int barWidth = Math.max(Math.min(this.config.barWidth(), 1000), 45);
        int barHeight = Math.max(this.config.barHeight(), 2);
        int minBarSpacing = 0;
        if ((textPosition == BarTextPosition.OUTSIDE || this.textOutsideOverride) && textType != BarTextType.NONE) {
            minBarSpacing = textSize == BarTextSize.SMALL ? 13 : 16;
        } else if (barHeight < this.ICON_SIZE + 4) {
            minBarSpacing = (this.ICON_SIZE - barHeight) / 2 + 2;
        }
        if (this.config.pastProgressSpan() > 4) {
            this.tooltipWidth = 140;
            this.tooltipHeight = 140;
        }
        int barSpacing = this.config.barSpacing() + minBarSpacing;
        boolean hideLabel = this.config.hideLabel();
        if (!goals.isEmpty()) {
            if (hideLabel) {
                this.topSectionHeight = textPosition == BarTextPosition.OUTSIDE ? (textSize == BarTextSize.SMALL ? 9 : 12) : 0;
            } else {
                this.topSectionHeight = 18;
                if ((textPosition == BarTextPosition.OUTSIDE || this.textOutsideOverride) && textType != BarTextType.NONE && !this.hideTextOverride) {
                    this.topSectionHeight = textSize == BarTextSize.SMALL ? (this.topSectionHeight += 13) : (this.topSectionHeight += 16);
                }
            }
            int extraBottomPadding = 0;
            if (barHeight < this.ICON_SIZE) {
                extraBottomPadding = (this.ICON_SIZE - barHeight) / 2;
            }
            int iconSizeWPadding = this.ICON_SIZE + this.iconRightPadding;
            if (this.ICON_SIZE == 0) {
                iconSizeWPadding = 0;
            }
            this.panelWidth = iconSizeWPadding + barWidth + this.panelHPadding * 2;
            this.panelHeight = this.panelTopPadding + this.topSectionHeight + barHeight * goals.size() + barSpacing * Math.max(goals.size() - 1, 0) + this.panelBottomPadding + extraBottomPadding;
            this.anchorX = this.config.anchorX();
            if (anchorType == AnchorType.TOP_RIGHT || anchorType == AnchorType.BOTTOM_RIGHT) {
                this.anchorX = this.viewportWidget.getCanvasLocation().getX() + this.viewportWidget.getWidth() + 28 - this.anchorX - this.panelWidth;
            }
            this.anchorY = this.config.anchorY();
            if (anchorType == AnchorType.BOTTOM_LEFT || anchorType == AnchorType.BOTTOM_RIGHT) {
                this.anchorY = this.viewportWidget.getCanvasLocation().getY() + this.viewportWidget.getHeight() + 41 - this.anchorY - this.panelHeight;
            }
            this.panelX = this.anchorX - this.panelHPadding;
            this.panelY = this.anchorY - this.panelTopPadding;
            this.renderPanel(graphics, this.panelX, this.panelY, this.panelWidth, this.panelHeight);
            if (!hideLabel) {
                this.renderLabel(graphics);
            }
        }
        Goal tooltipGoal = null;
        int offsetY = this.topSectionHeight;
        for (int i = 0; i < goals.size(); ++i) {
            Goal goal = goals.get(i);
            if (!goal.enabled) continue;
            float progress = this.getXpProgress(goal.progressXp, goal.goalXp);
            this.renderSkillIcon(graphics, offsetY, goal);
            this.renderXpBar(graphics, barWidth, offsetY, progress, goal);
            this.renderBarText(graphics, barWidth, offsetY, goal, progress);
            Rectangle2D.Float rectangle = barHeight < this.ICON_SIZE ? new Rectangle2D.Float(this.panelX, (float)(this.anchorY + offsetY) - (float)(this.ICON_SIZE - barHeight) / 2.0f, this.panelWidth, this.ICON_SIZE) : new Rectangle2D.Float(this.panelX, this.anchorY + offsetY, this.panelWidth, barHeight);
            if (rectangle.contains(mouseX, mouseY)) {
                tooltipGoal = goal;
            }
            offsetY += barHeight + barSpacing;
        }
        if (tooltipGoal != null) {
            int x = mouseX + 15;
            int y = mouseY + 15;
            if (anchorType == AnchorType.TOP_RIGHT || anchorType == AnchorType.BOTTOM_RIGHT) {
                x -= this.tooltipWidth + 30;
            }
            if (anchorType == AnchorType.BOTTOM_LEFT || anchorType == AnchorType.BOTTOM_RIGHT) {
                y -= this.tooltipHeight + 30;
            }
            this.renderTooltip(graphics, x, y, tooltipGoal);
        }
        return null;
    }

    private void renderPanel(Graphics2D graphics, int x, int y, int width, int height) {
        graphics.setColor(ComponentConstants.STANDARD_BACKGROUND_COLOR);
        graphics.fillRect(x, y, width, height);
        graphics.setColor(this.outerBorderColor);
        graphics.drawRect(x, y, width, height);
        graphics.setColor(this.outerBorderColor);
        graphics.drawRect(x - 1, y - 1, width + 2, height + 2);
        graphics.setColor(this.innerBorderColor);
        graphics.drawRect(x + 1, y + 1, width - 2, height - 2);
    }

    private void renderLabel(Graphics2D graphics) {
        String label = this.config.labelText();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        TextComponent textComponent = new TextComponent();
        textComponent.setFont(FontManager.getRunescapeFont());
        textComponent.setText(label);
        textComponent.setColor(Color.GREEN);
        textComponent.setPosition(new java.awt.Point(this.panelWidth / 2 - fontMetrics.stringWidth(label) / 2 + this.panelX, this.anchorY + this.panelTopPadding + fontMetrics.getHeight() - 2));
        textComponent.render(graphics);
    }

    private void renderSkillIcon(Graphics2D graphics2D, int offsetY, Goal goal) {
        if (this.ICON_SIZE == 0) {
            return;
        }
        Skill skill = this.getSkillForId(goal.skillId);
        if (skill == null) {
            return;
        }
        BufferedImage icon = this.iconManager.getSkillImage(skill);
        icon = ImageUtil.resizeImage((BufferedImage)icon, (int)this.ICON_SIZE, (int)this.ICON_SIZE, (boolean)true);
        int barHeight = Math.max(this.config.barHeight(), 2);
        int y = this.anchorY + offsetY - (this.ICON_SIZE - barHeight) / 2;
        graphics2D.drawImage((Image)icon, this.anchorX, y, null);
    }

    private void renderXpBar(Graphics2D graphics, int barWidth, int offsetY, float progress, Goal goal) {
        Skill skill = this.plugin.skillForSkillId(goal.skillId);
        Color progressColor = skill != null ? SkillColor.find((Skill)skill).getColor() : Color.YELLOW;
        Color backColor = this.barBackgroundColor;
        Color frontColor = progressColor;
        Color overfillColor = this.config.overfillColor();
        float relPercent = progress;
        if (progress > 1.0f && this.config.enableOverfill()) {
            backColor = progressColor;
            frontColor = overfillColor;
            relPercent = progress - 1.0f;
            if (relPercent > 1.0f) {
                relPercent = 1.0f;
            }
        } else if (progress > 1.0f) {
            relPercent = 1.0f;
        }
        int h = Math.max(this.config.barHeight(), 2);
        int x = this.anchorX + this.ICON_SIZE + this.iconRightPadding;
        if (this.config.hideSkillIcons()) {
            x -= this.iconRightPadding;
        }
        int y = this.anchorY + offsetY;
        graphics.setColor(backColor);
        graphics.fillRect(x, y, barWidth, h);
        graphics.setColor(frontColor);
        graphics.fillRect(x, y, (int)(relPercent * (float)barWidth), h);
        graphics.setColor(this.barBorderColor);
        graphics.drawRect(x, y, barWidth, h);
    }

    private void renderBarText(Graphics2D graphics, int barWidth, int offsetY, Goal goal, float progress) {
        TextComponent textComponent = new TextComponent();
        BarTextSize textSize = this.config.barTextSize();
        BarTextPosition position = this.config.barTextPosition();
        BarTextAlignment textAlignment = this.config.barTextAlignment();
        if (textSize == BarTextSize.SMALL) {
            graphics.setFont(this.font);
        } else {
            graphics.setFont(FontManager.getRunescapeSmallFont());
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int barH = Math.max(this.config.barHeight(), 2);
        this.textOutsideOverride = false;
        if (position == BarTextPosition.INSIDE && barH < fontMetrics.getHeight()) {
            graphics.setFont(this.font);
            fontMetrics = graphics.getFontMetrics();
            if (barH < fontMetrics.getHeight()) {
                this.textOutsideOverride = true;
                if (textSize == BarTextSize.LARGE) {
                    graphics.setFont(FontManager.getRunescapeSmallFont());
                    fontMetrics = graphics.getFontMetrics();
                }
            }
        }
        int h = fontMetrics.getHeight();
        String preciseFormatStr = "%.3f%%";
        Color textColor = Color.WHITE;
        Object text = "";
        BarTextType textType = this.config.barTextType();
        switch (textType) {
            case FRACTION: {
                text = NumberFormat.getInstance(Locale.ENGLISH).format(Math.max(goal.progressXp, 0)) + " / " + NumberFormat.getInstance(Locale.ENGLISH).format(goal.goalXp);
                break;
            }
            case PERCENTAGE: {
                text = (int)(progress * 100.0f) + "%";
                break;
            }
            case PRECISE_PERCENTAGE: {
                text = String.format(preciseFormatStr, Float.valueOf(progress * 100.0f));
                break;
            }
            case GAINED: {
                text = NumberFormat.getInstance(Locale.ENGLISH).format(Math.max(goal.progressXp, 0));
                break;
            }
            case REMAINING: {
                text = NumberFormat.getInstance(Locale.ENGLISH).format(goal.goalXp - Math.max(goal.progressXp, 0));
            }
        }
        DoneTextType doneTextType = this.config.doneTextType();
        if (progress >= 1.0f && textType != BarTextType.NONE && doneTextType != DoneTextType.NONE) {
            text = doneTextType.getText();
        }
        if (this.config.includeResetType()) {
            String label;
            switch (goal.resetType) {
                case 0: {
                    label = "H";
                    break;
                }
                case 1: {
                    label = "D";
                    break;
                }
                case 2: {
                    label = "W";
                    break;
                }
                case 3: {
                    label = "M";
                    break;
                }
                case 4: {
                    label = "Y";
                    break;
                }
                case 5: {
                    label = "N";
                    break;
                }
                default: {
                    label = "";
                }
            }
            text = (String)text + " (" + label + ")";
        }
        if (position == BarTextPosition.INSIDE) {
            if (textAlignment == BarTextAlignment.LEADING) {
                text = "  " + (String)text;
            } else if (textAlignment == BarTextAlignment.TRAILING) {
                text = (String)text + "  ";
            }
        }
        int barW = Math.max(Math.min(this.config.barWidth(), 1000), 45);
        int w = fontMetrics.stringWidth((String)text);
        this.hideTextOverride = false;
        if (w > barW) {
            graphics.setFont(this.font);
            fontMetrics = graphics.getFontMetrics();
            w = fontMetrics.stringWidth((String)text);
            if (w > barW) {
                this.hideTextOverride = true;
                text = "";
            }
        }
        int x = 0;
        int iconPadding = this.iconRightPadding;
        if (this.config.hideSkillIcons()) {
            iconPadding = 0;
        }
        switch (textAlignment) {
            case LEADING: {
                x = this.anchorX + this.ICON_SIZE + iconPadding + 1;
                break;
            }
            case CENTER: {
                x = this.anchorX + this.ICON_SIZE + iconPadding + (barW - w) / 2;
                break;
            }
            case TRAILING: {
                x = this.anchorX + this.ICON_SIZE + iconPadding + barW - w;
            }
        }
        int y = position == BarTextPosition.OUTSIDE || this.textOutsideOverride ? this.anchorY + offsetY - 1 : this.anchorY + offsetY + (barH - h) / 2 + h;
        textComponent.setText((String)text);
        textComponent.setPosition(new java.awt.Point(x, y));
        textComponent.setColor(textColor);
        textComponent.render(graphics);
    }

    private void renderTooltip(Graphics2D graphics, int x, int y, Goal goal) {
        int w = this.tooltipWidth;
        int h = this.tooltipHeight;
        int border = 2;
        int span = Math.min(this.config.pastProgressSpan(), 5);
        if ((span = Math.max(span, 1)) > 4) {
            w += 20;
            h += 20;
        }
        w -= (w - border * 2) % span;
        h -= (h - border * 2) % span;
        this.renderPanel(graphics, x, y, w, h);
        int xx = x + border;
        int yy = y + border;
        int ww = w - border * 2;
        int hh = h - border * 2;
        int cW = ww / span;
        int rH = hh / span;
        List<Float> pastProgress = goal.pastProgress;
        if (pastProgress == null || pastProgress.isEmpty()) {
            String text = "No resets yet";
            TextComponent textComponent = new TextComponent();
            textComponent.setFont(FontManager.getRunescapeSmallFont());
            textComponent.setText(text);
            textComponent.setColor(Color.WHITE);
            graphics.setFont(FontManager.getRunescapeSmallFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            textComponent.setPosition(new java.awt.Point(x + (w - fontMetrics.stringWidth(text)) / 2, y + (h - fontMetrics.getHeight()) / 2 + fontMetrics.getHeight()));
            textComponent.render(graphics);
            return;
        }
        for (int r = 0; r < span; ++r) {
            for (int c = 0; c < span; ++c) {
                if (r * span + c >= pastProgress.size()) continue;
                float progress = pastProgress.get(r * span + c).floatValue();
                this.renderPastProgressItem(graphics, xx + cW * c, yy + rH * r, cW, rH, goal, progress);
            }
        }
    }

    private void renderPastProgressItem(Graphics2D graphics, int x, int y, int w, int h, Goal goal, float progress) {
        Color color = SkillColor.find((Skill)this.plugin.skillForSkillId(goal.skillId)).getColor();
        graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 125));
        float percentToFill = Math.min(progress, 1.0f);
        graphics.fillRect(x, y + (h - (int)((float)h * percentToFill)), w, (int)((float)h * percentToFill));
        graphics.setFont(FontManager.getRunescapeSmallFont());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String text = (int)(Math.min(progress, 9.99f) * 100.0f) + "%";
        TextComponent textComponent = new TextComponent();
        textComponent.setFont(FontManager.getRunescapeSmallFont());
        textComponent.setText(text);
        textComponent.setPosition(new java.awt.Point(x + (w - fontMetrics.stringWidth(text)) / 2, y + (h - fontMetrics.getHeight()) / 2 + 13));
        if (progress >= 1.0f) {
            textComponent.setColor(Color.GREEN);
        } else {
            textComponent.setColor(Color.WHITE);
        }
        textComponent.render(graphics);
    }

    private Widget getViewportWidget() {
        Widget widget = this.client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_INTERFACE_CONTAINER);
        if (widget != null) {
            return widget;
        }
        widget = this.client.getWidget(WidgetInfo.RESIZABLE_VIEWPORT_BOTTOM_LINE_INTERFACE_CONTAINER);
        if (widget != null) {
            return widget;
        }
        widget = this.client.getWidget(WidgetInfo.FIXED_VIEWPORT_INTERFACE_CONTAINER);
        if (widget != null) {
            return widget;
        }
        return this.client.getWidget(WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER);
    }

    private float getXpProgress(int progressXp, int goalXp) {
        if (goalXp == 0) {
            if (progressXp - goalXp <= 0) {
                return 1.0f;
            }
            return 2.0f;
        }
        return (float)Math.max(progressXp, 0) / (float)goalXp;
    }

    List<Goal> getTrackedGoals() {
        LinkedList<Goal> tracked = new LinkedList<Goal>();
        for (Goal goal : this.plugin.goalData.goals) {
            if (!goal.track) continue;
            tracked.add(goal);
        }
        return tracked.stream().sorted((obj, other) -> {
            int progress = (int)(this.getXpProgress(obj.progressXp, obj.goalXp) * 100.0f);
            if (progress >= 100 && progress < 200) {
                progress = -2;
            } else if (progress >= 200) {
                progress = -1;
            }
            int otherProgress = (int)(this.getXpProgress(other.progressXp, other.goalXp) * 100.0f);
            if (otherProgress >= 100 && otherProgress < 200) {
                otherProgress = -2;
            } else if (otherProgress >= 200) {
                otherProgress = -1;
            }
            return otherProgress - progress;
        }).collect(Collectors.toList());
    }

    Skill getSkillForId(int skillId) {
        if (skillId == Skill.ATTACK.ordinal()) {
            return Skill.ATTACK;
        }
        if (skillId == Skill.STRENGTH.ordinal()) {
            return Skill.STRENGTH;
        }
        if (skillId == Skill.DEFENCE.ordinal()) {
            return Skill.DEFENCE;
        }
        if (skillId == Skill.RANGED.ordinal()) {
            return Skill.RANGED;
        }
        if (skillId == Skill.PRAYER.ordinal()) {
            return Skill.PRAYER;
        }
        if (skillId == Skill.MAGIC.ordinal()) {
            return Skill.MAGIC;
        }
        if (skillId == Skill.RUNECRAFT.ordinal()) {
            return Skill.RUNECRAFT;
        }
        if (skillId == Skill.CONSTRUCTION.ordinal()) {
            return Skill.CONSTRUCTION;
        }
        if (skillId == Skill.HITPOINTS.ordinal()) {
            return Skill.HITPOINTS;
        }
        if (skillId == Skill.AGILITY.ordinal()) {
            return Skill.AGILITY;
        }
        if (skillId == Skill.HERBLORE.ordinal()) {
            return Skill.HERBLORE;
        }
        if (skillId == Skill.THIEVING.ordinal()) {
            return Skill.THIEVING;
        }
        if (skillId == Skill.CRAFTING.ordinal()) {
            return Skill.CRAFTING;
        }
        if (skillId == Skill.FLETCHING.ordinal()) {
            return Skill.FLETCHING;
        }
        if (skillId == Skill.SLAYER.ordinal()) {
            return Skill.SLAYER;
        }
        if (skillId == Skill.HUNTER.ordinal()) {
            return Skill.HUNTER;
        }
        if (skillId == Skill.MINING.ordinal()) {
            return Skill.MINING;
        }
        if (skillId == Skill.SMITHING.ordinal()) {
            return Skill.SMITHING;
        }
        if (skillId == Skill.FISHING.ordinal()) {
            return Skill.FISHING;
        }
        if (skillId == Skill.COOKING.ordinal()) {
            return Skill.COOKING;
        }
        if (skillId == Skill.FIREMAKING.ordinal()) {
            return Skill.FIREMAKING;
        }
        if (skillId == Skill.WOODCUTTING.ordinal()) {
            return Skill.WOODCUTTING;
        }
        if (skillId == Skill.FARMING.ordinal()) {
            return Skill.FARMING;
        }
        return null;
    }
}

