/*
 * Decompiled with CFR 0.152.
 */
package io.ryoung.heatmap;

import com.google.common.collect.ImmutableList;
import com.google.inject.Provides;
import io.ryoung.heatmap.HeatmapCalculation;
import io.ryoung.heatmap.HeatmapConfig;
import io.ryoung.heatmap.HeatmapItem;
import io.ryoung.heatmap.HeatmapItemOverlay;
import io.ryoung.heatmap.HeatmapTutorialOverlay;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bank Heatmap")
public class HeatmapPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HeatmapPlugin.class);
    private static final List<Integer> TAB_VARBITS = ImmutableList.of((Object)4171, (Object)4172, (Object)4173, (Object)4174, (Object)4175, (Object)4176, (Object)4177, (Object)4178, (Object)4179);
    @Inject
    private Client client;
    @Inject
    private HeatmapCalculation heatmapCalculation;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private HeatmapItemOverlay heatmapItemOverlay;
    @Inject
    private HeatmapTutorialOverlay heatmapTutorialOverlay;
    @Inject
    private HeatmapConfig config;
    private HEATMAP_MODE heatmapMode = HEATMAP_MODE.NULL;

    protected void startUp() {
        this.overlayManager.add((Overlay)this.heatmapItemOverlay);
        this.overlayManager.add((Overlay)this.heatmapTutorialOverlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.heatmapItemOverlay);
        this.overlayManager.remove((Overlay)this.heatmapTutorialOverlay);
        this.heatmapMode = HEATMAP_MODE.NULL;
    }

    @Provides
    HeatmapConfig provideConfig(ConfigManager configManager) {
        return (HeatmapConfig)configManager.getConfig(HeatmapConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!"heatmap".equals(event.getGroup()) || !"tutorial".equals(event.getKey())) {
            return;
        }
        if (this.config.showTutorial()) {
            this.overlayManager.add((Overlay)this.heatmapTutorialOverlay);
        } else {
            this.overlayManager.remove((Overlay)this.heatmapTutorialOverlay);
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 277) {
            Item[] items = this.getBankTabItems();
            this.heatmapItemOverlay.getHeatmapImages().invalidateAll();
            this.heatmapCalculation.calculate(items);
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (event.getType() != MenuAction.CC_OP.getId() || !event.getOption().equals("Show menu") || event.getActionParam1() >> 16 != 12) {
            return;
        }
        this.client.createMenuEntry(-1).setOption("Toggle GE Heatmap").setTarget("").setType(MenuAction.RUNELITE).onClick(this::onClick).setDeprioritized(true);
        this.client.createMenuEntry(-1).setOption("Toggle HA Heatmap").setTarget("").setType(MenuAction.RUNELITE).onClick(this::onClick).setDeprioritized(true);
        if (this.config.showTutorial()) {
            this.client.createMenuEntry(-1).setOption("Disable tutorial").setTarget("").setType(MenuAction.WIDGET_FIFTH_OPTION).setIdentifier(event.getIdentifier()).setParam0(event.getActionParam0()).setParam1(event.getActionParam1()).onClick(e -> this.config.setTutorial(false)).setDeprioritized(true);
        }
    }

    public void onClick(MenuEntry e) {
        HEATMAP_MODE mode;
        HEATMAP_MODE hEATMAP_MODE = mode = e.getOption().equals("Toggle GE Heatmap") ? HEATMAP_MODE.GE : HEATMAP_MODE.HA;
        if (mode == this.heatmapMode) {
            this.heatmapMode = HEATMAP_MODE.NULL;
        } else {
            this.heatmapItemOverlay.getHeatmapImages().invalidateAll();
            this.heatmapMode = mode;
        }
    }

    private Item[] getBankTabItems() {
        ItemContainer container = this.client.getItemContainer(InventoryID.BANK);
        if (container == null) {
            return null;
        }
        Item[] items = container.getItems();
        int currentTab = this.client.getVarbitValue(4150);
        if (currentTab > 0) {
            int startIndex = 0;
            for (int i = currentTab - 1; i > 0; --i) {
                startIndex += this.client.getVarbitValue(TAB_VARBITS.get(i - 1).intValue());
            }
            int itemCount = this.client.getVarbitValue(TAB_VARBITS.get(currentTab - 1).intValue());
            return Arrays.copyOfRange(items, startIndex, startIndex + itemCount);
        }
        return items;
    }

    HeatmapItem getHeatmapItem(int id) {
        return this.heatmapCalculation.getHeatmapItems().get(id);
    }

    boolean isBankVisible() {
        Widget bank = this.client.getWidget(WidgetInfo.BANK_CONTAINER);
        return this.config.showTutorial() && bank != null && !bank.isHidden();
    }

    public HEATMAP_MODE getHeatmapMode() {
        return this.heatmapMode;
    }

    static enum HEATMAP_MODE {
        NULL,
        HA,
        GE;

    }
}

