/*
 * Decompiled with CFR 0.152.
 */
package io.ryoung.heatmap;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import io.ryoung.heatmap.HeatmapItem;
import io.ryoung.heatmap.HeatmapPlugin;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;
import net.runelite.api.ItemComposition;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;

public class HeatmapItemOverlay
extends WidgetItemOverlay {
    private static final int ALPHA = 135;
    private static final int COLOR_BOUNDARY = 240;
    private final HeatmapPlugin plugin;
    private final ItemManager itemManager;
    private final Cache<Integer, BufferedImage> heatmapImages = CacheBuilder.newBuilder().maximumSize(160L).expireAfterWrite(2L, TimeUnit.MINUTES).build();

    @Inject
    HeatmapItemOverlay(HeatmapPlugin plugin, ItemManager itemManager) {
        this.plugin = plugin;
        this.itemManager = itemManager;
        this.showOnBank();
    }

    public void renderItemOverlay(Graphics2D graphics, int itemId, WidgetItem itemWidget) {
        HeatmapItem hItem = this.plugin.getHeatmapItem(itemId);
        HeatmapPlugin.HEATMAP_MODE mode = this.plugin.getHeatmapMode();
        if (hItem == null || itemWidget.getWidget().getParentId() != WidgetInfo.BANK_ITEM_CONTAINER.getId() || mode == HeatmapPlugin.HEATMAP_MODE.NULL || mode == HeatmapPlugin.HEATMAP_MODE.GE && hItem.getGePrice() < 1L || mode == HeatmapPlugin.HEATMAP_MODE.HA && hItem.getAlchPrice() < 1L) {
            return;
        }
        Rectangle bounds = itemWidget.getCanvasBounds();
        BufferedImage image = (BufferedImage)this.heatmapImages.getIfPresent((Object)itemId);
        if (image == null) {
            image = this.getImage(hItem, mode);
            this.heatmapImages.put((Object)itemId, (Object)image);
        }
        graphics.drawImage((Image)image, bounds.x, bounds.y, null);
    }

    private static Color getColor(float value) {
        float h = (1.0f - value) * 240.0f / 360.0f;
        Color c = Color.getHSBColor(h, 1.0f, 1.0f);
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), 135);
    }

    private BufferedImage getImage(HeatmapItem item, HeatmapPlugin.HEATMAP_MODE mode) {
        ItemComposition itemComposition = this.itemManager.getItemComposition(item.getId());
        boolean stackable = item.getQuantity() > 1 || itemComposition.isStackable();
        AsyncBufferedImage image = this.itemManager.getImage(item.getId(), item.getQuantity(), stackable);
        Color color = HeatmapItemOverlay.getColor(mode == HeatmapPlugin.HEATMAP_MODE.GE ? item.getGeFactor() : item.getAlchFactor());
        return ImageUtil.fillImage((BufferedImage)image, (Color)color);
    }

    public Cache<Integer, BufferedImage> getHeatmapImages() {
        return this.heatmapImages;
    }
}

