/*
 * Decompiled with CFR 0.152.
 */
package io.ryoung.heatmap;

import io.ryoung.heatmap.HeatmapItem;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Item;
import net.runelite.client.game.ItemManager;

public class HeatmapCalculation {
    private final ItemManager itemManager;
    private final Map<Integer, HeatmapItem> heatmapItems = new HashMap<Integer, HeatmapItem>();

    @Inject
    private HeatmapCalculation(ItemManager itemManager) {
        this.itemManager = itemManager;
    }

    void calculate(Item[] items) {
        this.heatmapItems.clear();
        block4: for (Item item : items) {
            int qty = item.getQuantity();
            int id = item.getId();
            HeatmapItem hItem = new HeatmapItem();
            hItem.setId(id);
            hItem.setQuantity(qty);
            this.heatmapItems.put(item.getId(), hItem);
            if (id <= 0 || qty == 0) continue;
            switch (id) {
                case 995: {
                    hItem.setAlchPrice(qty);
                    hItem.setGePrice(qty);
                    continue block4;
                }
                case 13204: {
                    hItem.setGePrice((long)qty * 1000L);
                    hItem.setAlchPrice((long)qty * 1000L);
                    continue block4;
                }
                default: {
                    long storePrice = this.itemManager.getItemComposition(id).getPrice();
                    long alchPrice = (long)((float)storePrice * 0.6f);
                    hItem.setGePrice(this.itemManager.getItemPrice(id) * qty);
                    hItem.setAlchPrice(alchPrice * (long)qty);
                }
            }
        }
        this.normalizeItems();
    }

    private void normalizeItems() {
        long minAlch = Long.MAX_VALUE;
        long minGe = Long.MAX_VALUE;
        long maxAlch = Long.MIN_VALUE;
        long maxGe = Long.MIN_VALUE;
        for (HeatmapItem hItem : this.heatmapItems.values()) {
            minGe = Math.min(minGe, hItem.getGePrice());
            minAlch = Math.min(minAlch, hItem.getAlchPrice());
            maxGe = Math.max(maxGe, hItem.getGePrice());
            maxAlch = Math.max(maxAlch, hItem.getAlchPrice());
        }
        for (HeatmapItem hItem : this.heatmapItems.values()) {
            hItem.setAlchFactor(HeatmapCalculation.normalize(0, 1, minAlch, maxAlch, hItem.getAlchPrice()));
            hItem.setGeFactor(HeatmapCalculation.normalize(0, 1, minGe, maxGe, hItem.getGePrice()));
        }
    }

    private static float normalize(int a, int b, long min, long max, long x) {
        return (float)(b - a) * ((float)(x - min) / (float)(max - min)) + (float)a;
    }

    public Map<Integer, HeatmapItem> getHeatmapItems() {
        return this.heatmapItems;
    }
}

