/*
 * Decompiled with CFR 0.152.
 */
package com.ignore.list.ban.tracker;

import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.components.colorpicker.ColorPickerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Ignore List Ban Tracker", description="See how many of your reports have resulted in action", tags={"Reports", "Ban", "Ignore", "Mute"})
public class IgnoreListBanTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(IgnoreListBanTrackerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ColorPickerManager colorPickerManager;
    @Inject
    private Notifier notifier;
    @Inject
    private ChatMessageManager chatMessageManager;
    private static final String CONFIG_GROUP = "ignoreListBanTracker";
    private static final String CONFIG_KEY = "lastIgnoreListSize";
    private int checkIgnoreListCountdown;
    private boolean hasSeenLoginScreenSinceLastCheck;

    protected void startUp() throws Exception {
        this.checkIgnoreListCountdown = -1;
        this.hasSeenLoginScreenSinceLastCheck = this.client.getGameState() == GameState.LOGIN_SCREEN;
        System.out.println(this.client.getGameState());
    }

    private boolean getBannedRemovalSetting() {
        return this.client.getVarbitValue(8059) == 0;
    }

    private boolean getMutedRemovalSetting() {
        return this.client.getVarbitValue(8060) == 1;
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        int ignoreCount = this.client.getIgnoreContainer().getCount();
        Integer lastIgnoreCount = (Integer)this.configManager.getRSProfileConfiguration(CONFIG_GROUP, CONFIG_KEY, Integer.class);
        if (this.checkIgnoreListCountdown == 0 && lastIgnoreCount != null && ignoreCount < lastIgnoreCount) {
            int sizeChange = lastIgnoreCount - ignoreCount;
            boolean ban = this.getBannedRemovalSetting();
            boolean mute = this.getMutedRemovalSetting();
            String actionString = ban && mute ? "banned/muted" : (ban ? "banned" : (mute ? "muted" : "removed"));
            String message = String.format("%d %s from your ignore list %s been %s.", sizeChange, sizeChange == 1 ? "user" : "users", sizeChange == 1 ? "has" : "have", actionString);
            this.sendMessage(message);
        }
        if (this.checkIgnoreListCountdown >= -1) {
            --this.checkIgnoreListCountdown;
        }
        if (this.checkIgnoreListCountdown == -1 && (lastIgnoreCount == null || lastIgnoreCount != ignoreCount)) {
            this.configManager.setRSProfileConfiguration(CONFIG_GROUP, CONFIG_KEY, (Object)ignoreCount);
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState currentGameState = gameStateChanged.getGameState();
        if (this.hasSeenLoginScreenSinceLastCheck && currentGameState == GameState.LOGGED_IN) {
            this.checkIgnoreListCountdown = 3;
            this.hasSeenLoginScreenSinceLastCheck = false;
        } else if (currentGameState == GameState.LOGIN_SCREEN) {
            this.hasSeenLoginScreenSinceLastCheck = true;
        }
    }

    private void sendMessage(String message) {
        String chatMessage = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(message).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
    }
}

