/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.VengTrackerConfig;
import com.example.VengTrackerOverlay;
import com.google.inject.Provides;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuEntry;
import net.runelite.api.Player;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.party.PartyMember;
import net.runelite.client.party.PartyService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.party.PartyPlugin;
import net.runelite.client.plugins.party.PartyPluginService;
import net.runelite.client.plugins.party.data.PartyData;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Vengeance Tracker", description="Shows Veng icon next to players who are venged and more (works with party plugin)", tags={"PVM", "Vengeance", "Player status"})
@PluginDependency(value=PartyPlugin.class)
public class VengTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(VengTrackerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private VengTrackerConfig config;
    @Inject
    private VengTrackerOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private PartyPluginService partyPluginService;
    @Inject
    private PartyService partyService;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    public ArrayList<String> currentlyVenged = new ArrayList();

    @Subscribe
    public void onGraphicChanged(GraphicChanged graphicChanged) {
        if (this.client.getLocalPlayer() != null && graphicChanged.getActor() instanceof Player && !this.isInPvP()) {
            Player player = (Player)graphicChanged.getActor();
            boolean playerVenged = this.currentlyVenged.contains(player.getName());
            if (!(player.getGraphic() != 725 && player.getGraphic() != 726 || playerVenged)) {
                this.currentlyVenged.add(Text.sanitize((String)player.getName()));
            }
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        for (MenuEntry entry : event.getMenuEntries()) {
            if (entry.getPlayer() == null || !this.currentlyVenged.contains(Text.sanitize((String)entry.getPlayer().getName())) || !entry.getTarget().contains("Vengeance Other") || !this.config.indicateVenged()) continue;
            entry.setTarget(entry.getTarget() + " <col=ffffff> (V) <col=ffff00>");
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        MenuEntry entry = event.getMenuEntry();
        if (entry.getPlayer() != null && this.currentlyVenged.contains(Text.sanitize((String)entry.getPlayer().getName())) && entry.getTarget().contains("Vengeance Other") && this.config.dePrioVenged()) {
            entry.setDeprioritized(true);
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.partyService.isInParty() && !this.isInPvP()) {
            for (PartyMember partyMember : this.partyService.getMembers()) {
                PartyData partyData = this.partyPluginService.getPartyData(partyMember.getMemberId());
                String playerName = partyMember.getDisplayName();
                if (partyData.isVengeanceActive() && !this.currentlyVenged.contains(Text.sanitize((String)playerName))) {
                    this.currentlyVenged.add(Text.sanitize((String)playerName));
                }
                if (partyData.isVengeanceActive() || !this.currentlyVenged.contains(Text.sanitize((String)playerName))) continue;
                this.currentlyVenged.remove(Text.sanitize((String)playerName));
            }
        }
        if (this.currentlyVenged.contains(Text.sanitize((String)this.client.getLocalPlayer().getName())) && this.client.getVarbitValue(2450) == 0) {
            this.currentlyVenged.remove(Text.sanitize((String)this.client.getLocalPlayer().getName()));
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (this.configManager.getConfiguration("party", "statusOverlayVeng").equals("true") && this.config.remindToDisable()) {
            if (this.configManager.getConfiguration("runelite", "gameAlwaysOnTop").equals("false") && gameStateChanged.getGameState() == GameState.LOGGING_IN) {
                SwingUtilities.invokeLater(() -> {
                    Object[] options = new String[]{"Yes", "No", "No & Don't show again"};
                    int option = JOptionPane.showOptionDialog(null, "Disable Party Vengeance (Vengeance Tracker handles party also)", "Vengeance Tracker & Party Vengeance are both enabled", 0, 3, null, options, null);
                    if (((String)options[option]).equals("Yes")) {
                        this.configManager.setConfiguration("party", "statusOverlayVeng", "false");
                    }
                    if (((String)options[option]).equals("No & Don't show again")) {
                        this.configManager.setConfiguration("VengTracker", "remindToDisable", "false");
                    }
                });
            } else if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("---------------------------------------------------------").build());
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("<col=ff6600>Please Disable 'Show Vengance' in the Party Plugin Config<col=ffff00>").build());
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage("---------------------------------------------------------").build());
            }
        }
        if (gameStateChanged.getGameState() == GameState.HOPPING || gameStateChanged.getGameState() == GameState.LOGGING_IN) {
            this.currentlyVenged.clear();
        }
    }

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged event) {
        Actor actor = event.getActor();
        if (actor instanceof Player && actor.getName() != null && this.currentlyVenged.contains(actor.getName()) && actor.getOverheadText().equals("Taste vengeance!")) {
            this.currentlyVenged.remove(Text.sanitize((String)actor.getName()));
        }
    }

    private boolean isInPvP() {
        return this.client.getVarbitValue(8121) == 1;
    }

    @Provides
    VengTrackerConfig provideConfig(ConfigManager configManager) {
        return (VengTrackerConfig)configManager.getConfig(VengTrackerConfig.class);
    }

    protected void startUp() throws Exception {
        this.currentlyVenged.clear();
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.currentlyVenged.clear();
        this.overlayManager.remove((Overlay)this.overlay);
    }
}

