/*
 * Decompiled with CFR 0.152.
 */
package com.example;

import com.example.VengTrackerConfig;
import com.example.VengTrackerPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;

public class VengTrackerOverlay
extends Overlay {
    @Inject
    private VengTrackerConfig config;
    @Inject
    private VengTrackerPlugin plugin;
    @Inject
    private ImageUtil imageUtil;
    @Inject
    private Client client;
    @Inject
    private SpriteManager spriteManager;

    @Inject
    private VengTrackerOverlay() {
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
    }

    public Dimension render(Graphics2D graphics) {
        for (Player player : this.client.getPlayers()) {
            BufferedImage vengIcon;
            if (!this.plugin.currentlyVenged.contains(Text.sanitize((String)player.getName())) || (vengIcon = this.spriteManager.getSprite(561, 0)) == null) continue;
            this.renderPlayerOverlay(graphics, player, vengIcon);
        }
        return null;
    }

    private void renderPlayerOverlay(Graphics2D graphics, Player player, BufferedImage vengIcon) {
        Point renderPoint;
        if (this.config.renderMethod() == VengTrackerConfig.RenderMethod.HUG_PLAYER) {
            LocalPoint playerLocation = player.getLocalLocation();
            LocalPoint vengLoc = new LocalPoint(playerLocation.getX() + this.config.XOffset(), playerLocation.getY());
            renderPoint = Perspective.getCanvasImageLocation((Client)this.client, (LocalPoint)vengLoc, (BufferedImage)vengIcon, (int)(this.getAnchorPoint(player) + this.config.YOffset()));
        } else {
            Point point = player.getCanvasImageLocation(vengIcon, this.getAnchorPoint(player));
            renderPoint = new Point(point.getX() + this.config.XOffset(), point.getY() + this.config.YOffset());
        }
        if (this.client.getPlane() == player.getWorldLocation().getPlane() && renderPoint != null && player.getLocalLocation().isInScene()) {
            OverlayUtil.renderImageLocation((Graphics2D)graphics, (Point)renderPoint, (BufferedImage)ImageUtil.resizeImage((BufferedImage)vengIcon, (int)(16 - this.config.ZOffset()), (int)(18 - this.config.ZOffset())));
        }
    }

    public int getAnchorPoint(Player player) {
        int anchorPoint;
        switch (this.config.anchorPoints()) {
            case CHEST: {
                anchorPoint = player.getLogicalHeight() / 2;
                break;
            }
            case HEAD: {
                anchorPoint = player.getLogicalHeight();
                break;
            }
            case FEET: {
                anchorPoint = 0;
                break;
            }
            default: {
                anchorPoint = 0;
            }
        }
        return anchorPoint;
    }
}

