/*
 * Decompiled with CFR 0.152.
 */
package com.discordnotificationsaio;

import com.discordnotificationsaio.ApiTools;
import com.discordnotificationsaio.DiscordNotificationsAIOConfig;
import com.discordnotificationsaio.DiscordNotificationsAIOPanel;
import com.discordnotificationsaio.NonLootWebhookBody;
import com.discordnotificationsaio.rarity.Drop;
import com.discordnotificationsaio.rarity.Monster;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.UsernameChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.input.KeyManager;
import net.runelite.client.party.PartyMember;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.loottracker.LootRecordType;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Discord Notifications/Split Tracker")
public class DiscordNotificationsAIOPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DiscordNotificationsAIOPlugin.class);
    private static final String COLLECTION_LOG_TEXT = "New item added to your collection log: ";
    private static final Pattern KC_PATTERN = Pattern.compile("Your (?<pre>completion count for |subdued |completed )?(?<boss>.+?) (?<post>(?:(?:kill|harvest|lap|completion) )?(?:count )?)is: <col=ff0000>(?<kc>\\d+)</col>");
    private static final Map<String, String> KILLCOUNT_RENAMES = ImmutableMap.of((Object)"Barrows chest", (Object)"Barrows Chests");
    private static final ImmutableList<String> PET_MESSAGES = ImmutableList.of((Object)"You have a funny feeling like you're being followed", (Object)"You feel something weird sneaking into your backpack", (Object)"You have a funny feeling like you would have been followed");
    private static final String COX_DUST_MESSAGE_TEXT = "Dust recipients: ";
    private static final String COX_KIT_MESSAGE_TEXT = "Twisted Kit recipients: ";
    private static final Pattern TOB_UNIQUE_MESSAGE_PATTERN = Pattern.compile("(.+) found something special: (.+)");
    private static final Pattern QUEST_PATTERN_1 = Pattern.compile(".+?ve\\.*? (?<verb>been|rebuilt|.+?ed)? ?(?:the )?'?(?<quest>.+?)'?(?: [Qq]uest)?[!.]?$");
    private static final Pattern QUEST_PATTERN_2 = Pattern.compile("'?(?<quest>.+?)'?(?: [Qq]uest)? (?<verb>[a-z]\\w+?ed)?(?: f.*?)?[!.]?$");
    private static final ImmutableList<String> RFD_TAGS = ImmutableList.of((Object)"Another Cook", (Object)"freed", (Object)"defeated", (Object)"saved");
    private static final ImmutableList<String> WORD_QUEST_IN_NAME_TAGS = ImmutableList.of((Object)"Another Cook", (Object)"Doric", (Object)"Heroes", (Object)"Legends", (Object)"Observatory", (Object)"Olaf", (Object)"Waterfall");
    private final String rarity = "";
    public String playerName;
    public String boss;
    public String itemName;
    public Integer itemKc;
    public String bossName;
    public String itemValue;
    public String notificationType;
    @Inject
    public Client client;
    @Inject
    public DiscordNotificationsAIOConfig config;
    @Inject
    public OkHttpClient okHttpClient;
    @Inject
    public KeyManager keyManager;
    @Inject
    public DrawManager drawManager;
    @Inject
    public ConfigManager configManager;
    public PartyMember partyMember;
    private ClientThread clientThread;
    private String lastBossKill;
    private int lastBossKC = -1;
    private Hashtable<String, Integer> currentLevels;
    private ArrayList<String> leveledSkills;
    private boolean shouldSendLevelMessage = false;
    private boolean shouldSendQuestMessage = false;
    private boolean shouldSendClueMessage = false;
    private int ticksWaited = 0;
    private boolean shouldSendLootMessage;
    private boolean notificationStarted;
    private DiscordNotificationsAIOPanel discordNotificationsAIOPanel;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ClientToolbar clientToolbar;
    private String playerIconUrl = "";
    private ArrayList<Monster> mobs = DiscordNotificationsAIOPlugin.parseJsonToPojo();
    private int colorCode = 0;
    private NavigationButton navButton;

    private static String itemImageUrl(int itemId) {
        return "https://static.runelite.net/cache/item/icon/" + itemId + ".png";
    }

    private static byte[] convertImageToByteArray(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static ArrayList<Monster> parseJsonToPojo() throws IOException {
        ArrayList<Monster> npcs = new ArrayList<Monster>();
        Monster npc = null;
        Drop drop = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(DiscordNotificationsAIOPlugin.class.getResourceAsStream("drop-info.json")));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.contains(": [")) {
                    npc = new Monster(line.replace("\": [", "").replace("\"", "").replace(" ", ""));
                }
                if (line.contains("\"n\":")) {
                    drop = new Drop();
                    drop.setName(line.replace("\"n\": ", "").replace(",", "").replace("\"", "").trim());
                }
                if (line.contains("\"q\":") && drop != null) {
                    drop.setQuantity(line.replace("\"q\": ", "").replace(",", "").replace("\"", "").trim());
                }
                if (line.contains("\"o\":") && drop != null) {
                    drop.setRolls(line.replace("\"o\": ", "").replace(",", "").replace("\"", "").replace(" ", ""));
                }
                if (line.contains("\"r\":")) {
                    if (drop != null) {
                        drop.setRarity(line.replace("\"r\": ", "").replace(",", "").replace("\"", "").replace(" ", ""));
                    }
                    if (npc != null) {
                        npc.addDrops(drop);
                    }
                }
                if (!line.contains("],")) continue;
                npcs.add(npc);
            }
            ArrayList<Monster> arrayList = npcs;
            return arrayList;
        }
    }

    static String parseQuestCompletedWidget(String text) {
        String verb;
        Matcher questMatchFinal;
        Matcher questMatch1 = QUEST_PATTERN_1.matcher(text);
        Matcher questMatch2 = QUEST_PATTERN_2.matcher(text);
        Matcher matcher = questMatchFinal = questMatch1.matches() ? questMatch1 : questMatch2;
        if (!questMatchFinal.matches()) {
            return "Unable to find quest name!";
        }
        Object quest = questMatchFinal.group("quest");
        String string = verb = questMatchFinal.group("verb") != null ? questMatchFinal.group("verb") : "";
        if (verb.contains("kind of")) {
            quest = (String)quest + " partial completion";
        } else if (verb.contains("completely")) {
            quest = (String)quest + " II";
        }
        if (RFD_TAGS.stream().anyMatch(((String)quest + verb)::contains)) {
            quest = "Recipe for Disaster - " + (String)quest;
        }
        if (WORD_QUEST_IN_NAME_TAGS.stream().anyMatch(((String)quest)::contains)) {
            quest = (String)quest + " Quest";
        }
        return quest;
    }

    @Provides
    DiscordNotificationsAIOConfig provideConfig(ConfigManager configManager) {
        return (DiscordNotificationsAIOConfig)configManager.getConfig(DiscordNotificationsAIOConfig.class);
    }

    private void setKc(String boss, int killcount) {
        this.configManager.setRSProfileConfiguration("killcount", boss.toLowerCase(), (Object)killcount);
    }

    private void unsetKc(String boss) {
        this.configManager.unsetRSProfileConfiguration("killcount", boss.toLowerCase());
    }

    public int getKc(String playerName, String boss) {
        this.playerName = playerName;
        this.boss = boss;
        Integer killCount = (Integer)this.configManager.getRSProfileConfiguration("killcount", boss.toLowerCase(), Integer.TYPE);
        return killCount == null ? 0 : killCount;
    }

    protected void startUp() throws Exception {
        this.discordNotificationsAIOPanel = new DiscordNotificationsAIOPanel(this, this.config, this.client, this.mobs);
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"balance.png");
        this.currentLevels = new Hashtable();
        this.leveledSkills = new ArrayList();
        this.navButton = NavigationButton.builder().tooltip("Split Tracker").icon(icon).priority(5).panel((PluginPanel)this.discordNotificationsAIOPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() throws Exception {
        this.notificationStarted = false;
        this.clientToolbar.removeNavigation(this.navButton);
        this.currentLevels = null;
        this.leveledSkills = null;
        this.mobs = null;
    }

    @Subscribe
    public void onUsernameChanged(UsernameChanged usernameChanged) {
        this.resetState();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState().equals((Object)GameState.LOGIN_SCREEN)) {
            this.resetState();
        } else {
            switch (this.client.getAccountType()) {
                case IRONMAN: {
                    this.playerIconUrl = "https://oldschool.runescape.wiki/images/0/09/Ironman_chat_badge.png";
                }
                case HARDCORE_IRONMAN: {
                    this.playerIconUrl = "https://oldschool.runescape.wiki/images/b/b8/Hardcore_ironman_chat_badge.png";
                }
                case ULTIMATE_IRONMAN: {
                    this.playerIconUrl = "https://oldschool.runescape.wiki/images/0/02/Ultimate_ironman_chat_badge.png";
                }
                case GROUP_IRONMAN: {
                    this.playerIconUrl = "https://oldschool.runescape.wiki/images/Group_ironman_chat_badge.png";
                }
                case HARDCORE_GROUP_IRONMAN: {
                    this.playerIconUrl = "https://oldschool.runescape.wiki/images/Hardcore_group_ironman_chat_badge.png";
                }
                case NORMAL: {
                    this.playerIconUrl = "https://oldschool.runescape.wiki/images/thumb/Grand_Exchange_logo.png/225px-Grand_Exchange_logo.png?88cff";
                }
            }
            this.playerIconUrl = "";
            this.shouldSendLootMessage = true;
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        boolean didCompleteClue;
        boolean bl = didCompleteClue = this.client.getWidget(WidgetInfo.CLUE_SCROLL_REWARD_ITEM_CONTAINER) != null;
        if (!this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
            return;
        }
        if (Objects.equals(this.playerIconUrl, "")) {
            this.playerIconUrl = this.getPlayerIconUrl();
            this.colorCode = this.getColorCode();
            CompletableFuture.runAsync(() -> this.discordNotificationsAIOPanel.buildWomPanel());
        }
        if (this.shouldSendClueMessage && didCompleteClue && this.config.includeClue()) {
            this.shouldSendClueMessage = false;
            this.sendClueMessage();
        }
        if (this.shouldSendQuestMessage && this.config.includeQuestComplete() && this.client.getWidget(WidgetInfo.QUEST_COMPLETED_NAME_TEXT) != null) {
            this.shouldSendQuestMessage = false;
            String text = this.client.getWidget(WidgetInfo.QUEST_COMPLETED_NAME_TEXT).getText();
            String questName = DiscordNotificationsAIOPlugin.parseQuestCompletedWidget(text);
            this.sendQuestMessage(questName);
        }
        if (!this.shouldSendLevelMessage) {
            return;
        }
        if (this.ticksWaited < 2) {
            ++this.ticksWaited;
            return;
        }
        this.shouldSendLevelMessage = false;
        this.ticksWaited = 0;
        this.sendLevelMessage();
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        if (!this.config.includeLevelling()) {
            return;
        }
        String skillName = statChanged.getSkill().getName();
        int newLevel = statChanged.getLevel();
        Integer previousLevel = this.currentLevels.get(skillName);
        if (previousLevel == null || previousLevel == 0) {
            this.currentLevels.put(skillName, newLevel);
            return;
        }
        if (previousLevel != newLevel) {
            this.currentLevels.put(skillName, newLevel);
            for (int level = previousLevel + 1; level <= newLevel; ++level) {
                if (!this.shouldSendForThisLevel(level)) continue;
                this.leveledSkills.add(skillName);
                this.shouldSendLevelMessage = true;
                break;
            }
        }
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived event) throws IOException, InterruptedException, InvocationTargetException {
        if (this.isPlayerIgnored()) {
            return;
        }
        if (!this.config.autoLog()) {
            return;
        }
        NPC npc = event.getNpc();
        Collection items = event.getItems();
        if (items.isEmpty() || npc == null) {
            return;
        }
        String npcName = npc.getName();
        for (ItemStack itemStack : items) {
            int itemId = itemStack.getId();
            int value = this.itemManager.getItemPrice(itemId) * itemStack.getQuantity();
            if (value < this.config.valuableDropThreshold()) continue;
            String itemName = this.itemManager.getItemComposition(itemId).getName();
            String[] rarity = new String[]{""};
            rarity[0] = String.valueOf(ApiTools.getItemRarity(this.mobs, npcName, itemName));
            if (this.config.includeRarity() && this.config.rarityThreshold() <= Integer.parseInt(rarity[0])) {
                CompletableFuture.runAsync(() -> {
                    this.dataToPanel(npcName, itemName);
                    AtomicReference<String> thumbnailUrl = new AtomicReference<String>("");
                    thumbnailUrl.set(DiscordNotificationsAIOPlugin.itemImageUrl(itemId));
                    String finalRarity = rarity[0];
                    if (Integer.parseInt(rarity[0]) >= this.config.rarityThreshold()) {
                        this.sendLootMessage(itemName, this.lastBossKC == -1 ? null : Integer.valueOf(this.getKc(this.playerName, this.lastBossKill)), npcName, Integer.toString(value), "Loot Received", thumbnailUrl.get(), "", finalRarity, this.config.autoLog());
                        this.unsetKc(this.lastBossKill);
                    }
                });
                continue;
            }
            if (this.config.includeRarity()) continue;
            String finalRarity = "";
            this.dataToPanel(npcName, itemName);
            AtomicReference<String> thumbnailUrl = new AtomicReference<String>("");
            CompletableFuture.runAsync(() -> {
                thumbnailUrl.set(DiscordNotificationsAIOPlugin.itemImageUrl(itemId));
                this.sendLootMessage(itemName, this.lastBossKC == -1 ? null : Integer.valueOf(this.getKc(this.playerName, this.lastBossKill)), npcName, Integer.toString(value), "Loot Received", (String)thumbnailUrl.get(), "", finalRarity, this.config.autoLog());
                this.unsetKc(this.lastBossKill);
            });
        }
    }

    @Subscribe
    public void onLootReceived(LootReceived lootReceived) {
        if (this.isPlayerIgnored()) {
            return;
        }
        if (lootReceived.getType() == LootRecordType.NPC) {
            return;
        }
        String npcName = lootReceived.getName();
        Collection items = lootReceived.getItems();
        for (ItemStack itemStack : items) {
            int itemId = itemStack.getId();
            int value = this.itemManager.getItemPrice(itemId) * itemStack.getQuantity();
            if (value < this.config.valuableDropThreshold()) continue;
            String itemName = this.itemManager.getItemComposition(itemId).getName();
            this.dataToPanel(npcName, itemName);
            String[] rarity = new String[]{""};
            if (this.config.includeRarity()) {
                CompletableFuture.runAsync(() -> {
                    this.dataToPanel(npcName, itemName);
                    AtomicReference<String> thumbnailUrl = new AtomicReference<String>("");
                    thumbnailUrl.set(DiscordNotificationsAIOPlugin.itemImageUrl(itemId));
                    String finalRarity = rarity[0];
                    this.sendLootMessage(itemName, this.lastBossKC == -1 ? null : Integer.valueOf(this.getKc(this.playerName, this.lastBossKill)), npcName, Integer.toString(value), "Loot Received", thumbnailUrl.get(), "", finalRarity, this.config.autoLog());
                    this.unsetKc(this.lastBossKill);
                });
                continue;
            }
            if (this.config.includeRarity()) continue;
            rarity[0] = "";
            this.dataToPanel(npcName, itemName);
            AtomicReference<String> thumbnailUrl = new AtomicReference<String>("");
            String finalRarity = rarity[0];
            CompletableFuture.runAsync(() -> {
                thumbnailUrl.set(DiscordNotificationsAIOPlugin.itemImageUrl(itemId));
                this.sendLootMessage(itemName, this.lastBossKC == -1 ? null : Integer.valueOf(this.getKc(this.playerName, this.lastBossKill)), npcName, Integer.toString(value), "Loot Received", (String)thumbnailUrl.get(), "", finalRarity, this.config.autoLog());
                this.unsetKc(this.lastBossKill);
            });
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        String chatMessage = event.getMessage();
        if (this.config.setPets()) {
            if (PET_MESSAGES.stream().anyMatch(chatMessage::contains)) {
                this.sendPetMessage();
            }
        }
        if (this.config.setCollectionLogs() && chatMessage.startsWith(COLLECTION_LOG_TEXT) && this.client.getVarbitValue(11959) == 1) {
            String itemName = Text.removeTags((String)chatMessage).substring(COLLECTION_LOG_TEXT.length());
            this.sendCollectionLogMessage(itemName);
        }
        String message = event.getMessage();
        Matcher kcmatcher = KC_PATTERN.matcher(message);
        String playerName = this.client.getLocalPlayer().getName();
        if (this.config.includeValuableDrops() && kcmatcher.find()) {
            String renamedBoss;
            this.lastBossKC = -1;
            String boss = kcmatcher.group("boss");
            int kc = Integer.parseInt(kcmatcher.group("kc"));
            String pre = kcmatcher.group("pre");
            String post = kcmatcher.group("post");
            if (Strings.isNullOrEmpty((String)pre) && Strings.isNullOrEmpty((String)post)) {
                this.unsetKc(boss);
            }
            if (!Objects.equals(boss, renamedBoss = KILLCOUNT_RENAMES.getOrDefault(boss, boss).replace(":", ""))) {
                this.unsetKc(boss);
                this.unsetKc(boss.replace(":", "."));
                this.unsetKc("Theatre of Blood Story Mode");
            }
            this.setKc(renamedBoss, kc);
            this.lastBossKill = renamedBoss;
            this.lastBossKC = kc;
        }
        if (this.config.includeRaidLoot()) {
            Matcher tobUniqueMessage;
            String dustRecipient;
            if (message.startsWith(COX_DUST_MESSAGE_TEXT)) {
                dustRecipient = Text.removeTags((String)message).substring(COX_DUST_MESSAGE_TEXT.length());
                String dropName = "Metamorphic dust";
                if (dustRecipient.equals(Text.sanitize((String)Objects.requireNonNull(this.client.getLocalPlayer().getName())))) {
                    this.itemName = "Metamorphic dust";
                    this.sendLootMessage(this.itemName, this.getKc(playerName, "cox cm"), "Chambers of Xeric: Challenge Mode", "", "Loot Received", "https://oldschool.runescape.wiki/images/thumb/Metamorphic_dust_detail.png/150px-Metamorphic_dust_detail.png", "", "400", true);
                    this.unsetKc("cox cm");
                }
            }
            if (message.startsWith(COX_KIT_MESSAGE_TEXT)) {
                dustRecipient = Text.removeTags((String)message).substring(COX_KIT_MESSAGE_TEXT.length());
                String dropName = "Twisted ancestral colour kit";
                if (dustRecipient.equals(Text.sanitize((String)Objects.requireNonNull(this.client.getLocalPlayer().getName())))) {
                    this.itemName = "Twisted ancestral colour kit";
                    this.sendLootMessage(this.itemName, this.getKc(playerName, "Chambers of Xeric Challenge Mode"), "Chambers of Xeric: Challenge Mode", "", "Loot Received", "https://oldschool.runescape.wiki/images/thumb/Metamorphic_dust_detail.png/150px-Metamorphic_dust_detail.png", "", "75", true);
                    this.unsetKc("cox cm");
                }
            }
            if ((tobUniqueMessage = TOB_UNIQUE_MESSAGE_PATTERN.matcher(message)).matches()) {
                String lootRecipient = Text.sanitize((String)tobUniqueMessage.group(1)).trim();
                String dropName = tobUniqueMessage.group(2).trim();
                if (lootRecipient.equals(Text.sanitize((String)Objects.requireNonNull(this.client.getLocalPlayer().getName())))) {
                    this.itemName = dropName;
                    this.sendLootMessage(this.itemName, this.getKc(playerName, "Theatre of blood"), "Theatre of Blood", "", "Loot Received", "", "", "", true);
                    this.unsetKc("Theatre of blood");
                }
            }
        }
    }

    private boolean isPlayerIgnored() {
        if (this.config.whiteListedRSNs().trim().length() > 0) {
            String playerName = this.getPlayerName().toLowerCase();
            List<String> whiteListedRSNs = Arrays.asList(this.config.whiteListedRSNs().split(","));
            return whiteListedRSNs.stream().noneMatch(rsn -> rsn.length() > 0 && playerName.equals(rsn.toLowerCase()));
        }
        return false;
    }

    private String getPlayerIconUrl() {
        switch (this.client.getAccountType()) {
            case IRONMAN: {
                return "https://oldschool.runescape.wiki/images/0/09/Ironman_chat_badge.png";
            }
            case HARDCORE_IRONMAN: {
                return "https://oldschool.runescape.wiki/images/b/b8/Hardcore_ironman_chat_badge.png";
            }
            case ULTIMATE_IRONMAN: {
                return "https://oldschool.runescape.wiki/images/0/02/Ultimate_ironman_chat_badge.png";
            }
            case GROUP_IRONMAN: {
                return "https://oldschool.runescape.wiki/images/Group_ironman_chat_badge.png";
            }
            case HARDCORE_GROUP_IRONMAN: {
                return "https://oldschool.runescape.wiki/images/Hardcore_group_ironman_chat_badge.png";
            }
            case NORMAL: {
                return "https://oldschool.runescape.wiki/images/thumb/Grand_Exchange_logo.png/225px-Grand_Exchange_logo.png?88cff";
            }
        }
        return "";
    }

    private int getColorCode() {
        switch (this.client.getAccountType()) {
            case IRONMAN: {
                return 0x3B3B3B;
            }
            case HARDCORE_IRONMAN: {
                return 0x590000;
            }
            case ULTIMATE_IRONMAN: {
                return 0x8E8E8E;
            }
            case GROUP_IRONMAN: {
                return 6579;
            }
            case HARDCORE_GROUP_IRONMAN: {
                return 0x810000;
            }
        }
        return 8817417;
    }

    private String getPlayerName() {
        return this.client.getLocalPlayer().getName();
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        switch (scriptPreFired.getScriptId()) {
            case 3346: {
                this.notificationStarted = true;
                break;
            }
            case 3347: {
                if (!this.notificationStarted) {
                    return;
                }
                String notificationTopText = this.client.getVarcStrValue(387);
                String notificationBottomText = this.client.getVarcStrValue(388);
                if (notificationTopText.equalsIgnoreCase("Collection log") && this.config.setCollectionLogs()) {
                    String itemName = "**" + Text.removeTags((String)notificationBottomText).substring("New item:".length()) + "**";
                    this.sendCollectionLogMessage(itemName);
                }
                this.notificationStarted = false;
            }
        }
    }

    @Subscribe
    public void onActorDeath(ActorDeath actorDeath) {
        Player player;
        if (!this.config.includeDeath()) {
            return;
        }
        Actor actor = actorDeath.getActor();
        if (actor instanceof Player && (player = (Player)actor) == this.client.getLocalPlayer()) {
            this.sendDeathMessage();
        }
    }

    private boolean shouldSendForThisLevel(int level) {
        return level >= this.config.minLevel() && this.levelMeetsIntervalRequirement(level);
    }

    private boolean levelMeetsIntervalRequirement(int level) {
        int levelInterval = this.config.levelInterval();
        if (this.config.linearLevelMax() > 0.0) {
            levelInterval = (int)Math.max(Math.ceil(-0.1 * (double)level + this.config.linearLevelMax()), 1.0);
        }
        return levelInterval <= 1 || level == 99 || level % levelInterval == 0;
    }

    private void sendQuestMessage(String questName) {
        String codeBlocks = "";
        String bold = "**";
        if (this.config.codeBlocks()) {
            codeBlocks = "`";
            bold = "";
        } else {
            codeBlocks = "";
        }
        String localName = bold + this.client.getLocalPlayer().getName() + bold;
        String questMessageString = this.config.questMessage().replaceAll("\\$name", codeBlocks + localName + codeBlocks).replaceAll("\\$quest", codeBlocks + questName + codeBlocks);
        NonLootWebhookBody nonLootWebhookBody = new NonLootWebhookBody();
        nonLootWebhookBody.setContent(questMessageString);
        this.sendNonLootWebhook(nonLootWebhookBody, this.config.sendQuestingScreenshot(), "quest");
    }

    private void sendDeathMessage() {
        String codeBlocks = "";
        String bold = "**";
        if (this.config.codeBlocks()) {
            codeBlocks = "`";
            bold = "";
        } else {
            codeBlocks = "";
        }
        String localName = bold + this.client.getLocalPlayer().getName() + bold;
        String deathMessageString = this.config.deathMessage().replaceAll("\\$name", codeBlocks + localName + codeBlocks);
        NonLootWebhookBody nonLootWebhookBody = new NonLootWebhookBody();
        nonLootWebhookBody.setContent(deathMessageString);
        this.sendNonLootWebhook(nonLootWebhookBody, this.config.sendDeathScreenshot(), "death");
    }

    private void sendClueMessage() {
        String codeBlocks = "";
        String bold = "**";
        if (this.config.codeBlocks()) {
            codeBlocks = "`";
            bold = "";
        } else {
            codeBlocks = "";
        }
        String localName = bold + this.client.getLocalPlayer().getName() + bold;
        String clueMessage = this.config.clueMessage().replaceAll("\\$name", codeBlocks + localName + codeBlocks);
        NonLootWebhookBody nonLootWebhookBody = new NonLootWebhookBody();
        nonLootWebhookBody.setContent(clueMessage);
        this.sendNonLootWebhook(nonLootWebhookBody, this.config.sendClueScreenshot(), "clue");
    }

    private void sendLevelMessage() {
        String codeBlocks = "";
        String bold = "**";
        if (this.config.codeBlocks()) {
            codeBlocks = "`";
            bold = "";
        } else {
            codeBlocks = "";
        }
        String localName = bold + this.client.getLocalPlayer().getName() + bold;
        Object levelUpString = this.config.levelMessage().replaceAll("\\$name", codeBlocks + localName + codeBlocks);
        String[] skills = new String[this.leveledSkills.size()];
        skills = this.leveledSkills.toArray(skills);
        this.leveledSkills.clear();
        for (int i = 0; i < skills.length; ++i) {
            if (i != 0) {
                levelUpString = (String)levelUpString + this.config.andLevelMessage();
            }
            String fixed = ((String)levelUpString).replaceAll("\\$skill", codeBlocks + skills[i] + codeBlocks).replaceAll("\\$level", codeBlocks + this.currentLevels.get(skills[i]).toString() + codeBlocks);
            levelUpString = fixed;
        }
        NonLootWebhookBody nonLootWebhookBody = new NonLootWebhookBody();
        nonLootWebhookBody.setContent((String)levelUpString);
        this.sendNonLootWebhook(nonLootWebhookBody, this.config.sendLevellingScreenshot(), "level");
    }

    private void sendPetMessage() {
        String codeBlocks = "";
        String bold = "**";
        if (this.config.codeBlocks()) {
            codeBlocks = "`";
            bold = "";
        } else {
            codeBlocks = "";
        }
        String localName = bold + this.client.getLocalPlayer().getName() + bold;
        String petMessageString = this.config.petMessage().replaceAll("\\$name", codeBlocks + localName + codeBlocks);
        NonLootWebhookBody nonLootWebhookBody = new NonLootWebhookBody();
        nonLootWebhookBody.setContent(petMessageString);
        this.sendNonLootWebhook(nonLootWebhookBody, this.config.sendPetScreenshot(), "pet");
    }

    private void sendCollectionLogMessage(String itemName) {
        String codeBlocks = "";
        String bold = "**";
        if (this.config.codeBlocks()) {
            codeBlocks = "`";
            bold = "";
        } else {
            codeBlocks = "";
        }
        String localName = bold + this.client.getLocalPlayer().getName() + bold;
        String collectionLogMessageString = this.config.collectionLogMessage().replaceAll("\\$name", codeBlocks + localName + codeBlocks).replaceAll("\\$itemName", codeBlocks + itemName + codeBlocks);
        NonLootWebhookBody nonLootWebhookBody = new NonLootWebhookBody();
        nonLootWebhookBody.setContent(collectionLogMessageString);
        this.sendNonLootWebhook(nonLootWebhookBody, this.config.sendCollectionLogScreenshot(), "log");
    }

    public void sendLootMessage(String itemName, Integer bossKC, String npcName, String itemValue, String notificationType, String itemImageURL, String splitMembers, String rarity, boolean send) {
        this.itemName = itemName;
        this.itemKc = bossKC;
        this.bossName = npcName;
        this.itemValue = itemValue;
        this.notificationType = notificationType;
        String codeBlocksGreenStart = "";
        String codeBlocksYellowStart = "";
        String codeBlocksEnd = "";
        String bold = "**";
        if (this.config.codeBlocks()) {
            codeBlocksGreenStart = "```glsl\n";
            codeBlocksYellowStart = "```fix\n";
            codeBlocksEnd = "\n```";
            bold = "";
        } else {
            codeBlocksGreenStart = "";
            codeBlocksYellowStart = "";
            codeBlocksEnd = "";
        }
        if (!this.shouldSendLootMessage) {
            return;
        }
        switch (notificationType) {
            case "Split Loot": {
                break;
            }
            case "Loot Received": {
                itemName = "a rare drop from " + npcName + ": " + (String)itemName;
                break;
            }
            default: {
                notificationType = "Manual Upload";
                itemName = "a screenshot";
            }
        }
        Object screenshotString = this.client.getLocalPlayer().getName();
        String valueMessage = null;
        if (!itemValue.isEmpty()) {
            screenshotString = (String)screenshotString + " just received " + (String)itemName + "!";
            valueMessage = itemValue + " gp";
        } else {
            screenshotString = !((String)itemName).isEmpty() ? (String)screenshotString + " just posted " + (String)itemName + "!" : (String)screenshotString + " just received " + (String)itemName + "!";
        }
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
        String playerName = this.client.getLocalPlayer().getName();
        JSONObject webhookObject = new JSONObject();
        JSONArray embedsArray = new JSONArray();
        JSONObject embedsObject = new JSONObject();
        JSONObject authorObject = new JSONObject();
        authorObject.put("icon_url", this.playerIconUrl);
        embedsObject.put("author", authorObject);
        authorObject.put("name", notificationType + " - " + playerName);
        embedsObject.put("title", screenshotString);
        embedsObject.put("url", "https://wiseoldman.net/players/" + playerName);
        JSONObject thumbnailObject = new JSONObject();
        if (!Objects.equals(itemImageURL, "")) {
            thumbnailObject.put("url", itemImageURL);
            embedsObject.put("thumbnail", thumbnailObject);
        }
        embedsArray.put(embedsObject);
        webhookObject.put("embeds", embedsArray);
        JSONArray fieldsArray = new JSONArray();
        embedsObject.putOnce("fields", fieldsArray);
        embedsObject.putOnce("color", this.colorCode);
        JSONObject footerObject = new JSONObject();
        JSONObject rarityField = new JSONObject();
        JSONObject valueField = new JSONObject();
        StringBuilder footerString = new StringBuilder(String.format("Date: %s", sdfDate.format(new Date())));
        if (!itemValue.isEmpty()) {
            if (!notificationType.equals("Split Loot")) {
                valueField.put("name", "Value").put("value", codeBlocksGreenStart + valueMessage + codeBlocksEnd).put("inline", true);
                fieldsArray.put(valueField);
                if (!Objects.equals(rarity, "")) {
                    rarityField.put("name", "Rarity").put("value", codeBlocksGreenStart + "1/" + rarity + codeBlocksEnd).put("inline", true);
                    fieldsArray.put(rarityField);
                }
            } else {
                valueField.put("name", "Split Value").put("value", codeBlocksGreenStart + valueMessage + codeBlocksEnd).put("inline", true);
                fieldsArray.put(valueField);
                if (!Objects.equals(rarity, "")) {
                    rarityField.put("name", "Rarity").put("value", codeBlocksGreenStart + "1/" + rarity + codeBlocksEnd).put("inline", true);
                    fieldsArray.put(rarityField);
                }
            }
        }
        JSONObject customField = new JSONObject();
        JSONObject bingoField = new JSONObject();
        JSONObject splitField = new JSONObject();
        if (this.config.includeBingo() && !Objects.equals(this.config.bingoString(), "")) {
            String bingoString = this.config.bingoString();
            bingoField.put("name", "Event String").put("value", codeBlocksGreenStart + "#" + bingoString + codeBlocksEnd).put("inline", true);
            fieldsArray.put(bingoField);
        }
        if (!this.config.customValue().equals("")) {
            customField.put("name", this.config.customField()).put("value", codeBlocksYellowStart + this.config.customValue() + codeBlocksEnd).put("inline", true);
            fieldsArray.put(customField);
        }
        if (!Objects.equals(splitMembers, "")) {
            splitField.put("name", "Split With").put("value", codeBlocksYellowStart + splitMembers + codeBlocksEnd).put("inline", true);
            fieldsArray.put(splitField);
        }
        if (!Objects.equals(npcName, "")) {
            footerString.append((String)(bossKC == null ? "" : " - Kill Count: " + bossKC));
        }
        footerObject.put("text", footerString);
        embedsObject.put("footer", footerObject);
        if (this.config.rawJson()) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(webhookObject.toString()), null);
        }
        CompletableFuture.runAsync(() -> this.sendLootWebhook(webhookObject.toString(), send));
    }

    public void sendLootWebhook(String embedsObject, boolean send) {
        String configUrl;
        if (send && this.config.autoLog() && this.config.autoWebHookToggle()) {
            configUrl = this.config.valuableWebHookToggle() ? this.config.valuableWebHook() : this.config.autoWebHook();
        } else if (!send && this.config.autoWebHookToggle()) {
            configUrl = this.config.valuableWebHookToggle() ? this.config.valuableWebHook() : this.config.webhook();
        } else if (Objects.equals(this.config.autoWebHook(), "")) {
            configUrl = this.config.valuableWebHookToggle() ? this.config.valuableWebHook() : this.config.webhook();
        } else {
            String string = configUrl = this.config.valuableWebHookToggle() ? this.config.valuableWebHook() : this.config.webhook();
        }
        if (!Strings.isNullOrEmpty((String)configUrl)) {
            HttpUrl url = HttpUrl.parse((String)configUrl);
            MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", embedsObject);
            if (this.config.sendScreenshot()) {
                if (!send && this.discordNotificationsAIOPanel.before != null) {
                    CompletableFuture.runAsync(() -> this.sendLootWebhookWithBuffer(url, requestBodyBuilder, this.discordNotificationsAIOPanel.before));
                } else {
                    CompletableFuture.runAsync(() -> this.sendLootWebhookWithScreenshot(url, requestBodyBuilder));
                }
            } else {
                CompletableFuture.runAsync(() -> this.buildRequestAndSend(url, requestBodyBuilder));
            }
        }
    }

    public void sendLootWebhookWithScreenshot(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        this.drawManager.requestNextFrameListener(image -> {
            byte[] imageBytes;
            BufferedImage bufferedImage = (BufferedImage)image;
            try {
                imageBytes = DiscordNotificationsAIOPlugin.convertImageToByteArray(bufferedImage);
            }
            catch (IOException e) {
                log.warn("Error converting image to byte array", (Throwable)e);
                return;
            }
            requestBodyBuilder.addFormDataPart("file", "image.png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])imageBytes));
            CompletableFuture.runAsync(() -> this.buildRequestAndSend(url, requestBodyBuilder));
        });
    }

    public void sendLootWebhookWithBuffer(HttpUrl url, MultipartBody.Builder requestBodyBuilder, BufferedImage screenshot) {
        byte[] imageBytes;
        try {
            imageBytes = DiscordNotificationsAIOPlugin.convertImageToByteArray(screenshot);
        }
        catch (IOException e) {
            log.warn("Error converting image to byte array", (Throwable)e);
            return;
        }
        requestBodyBuilder.addFormDataPart("file", "image.png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])imageBytes));
        this.buildRequestAndSend(url, requestBodyBuilder);
    }

    private void sendNonLootWebhook(NonLootWebhookBody discordWebhookBody, boolean sendScreenshot, String hookType) {
        String configUrl;
        if (this.config.autoLog() && this.config.autoWebHookToggle()) {
            switch (hookType) {
                case "level": {
                    configUrl = this.config.levelWebHookToggle() ? this.config.levelWebHook() : this.config.autoWebHook();
                    break;
                }
                case "quest": {
                    configUrl = this.config.questWebHookToggle() ? this.config.questWebHook() : this.config.autoWebHook();
                    break;
                }
                case "death": {
                    configUrl = this.config.deathWebHookToggle() ? this.config.deathWebHook() : this.config.autoWebHook();
                    break;
                }
                case "clue": {
                    configUrl = this.config.clueWebHookToggle() ? this.config.clueWebHook() : this.config.autoWebHook();
                    break;
                }
                case "pet": {
                    configUrl = this.config.petWebHookToggle() ? this.config.petWebHook() : this.config.autoWebHook();
                    break;
                }
                case "log": {
                    configUrl = this.config.logWebHookToggle() ? this.config.logWebHook() : this.config.autoWebHook();
                    break;
                }
                default: {
                    configUrl = this.config.autoWebHook();
                    break;
                }
            }
        } else {
            configUrl = this.config.autoWebHookToggle() ? this.getString(hookType) : (Objects.equals(this.config.autoWebHook(), "") ? this.getString(hookType) : this.config.webhook());
        }
        if (!Strings.isNullOrEmpty((String)configUrl)) {
            HttpUrl url = HttpUrl.parse((String)configUrl);
            MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)discordWebhookBody));
            if (sendScreenshot) {
                this.sendNonLootWebhookWithScreenshot(url, requestBodyBuilder);
            } else {
                this.buildRequestAndSend(url, requestBodyBuilder);
            }
        }
    }

    private String getString(String hookType) {
        String configUrl;
        switch (hookType) {
            case "level": {
                configUrl = this.config.levelWebHookToggle() ? this.config.levelWebHook() : this.config.webhook();
                break;
            }
            case "quest": {
                configUrl = this.config.questWebHookToggle() ? this.config.questWebHook() : this.config.webhook();
                break;
            }
            case "death": {
                configUrl = this.config.deathWebHookToggle() ? this.config.deathWebHook() : this.config.webhook();
                break;
            }
            case "clue": {
                configUrl = this.config.clueWebHookToggle() ? this.config.clueWebHook() : this.config.webhook();
                break;
            }
            case "pet": {
                configUrl = this.config.petWebHookToggle() ? this.config.petWebHook() : this.config.webhook();
                break;
            }
            case "log": {
                configUrl = this.config.logWebHookToggle() ? this.config.logWebHook() : this.config.webhook();
                break;
            }
            default: {
                configUrl = this.config.webhook();
            }
        }
        return configUrl;
    }

    private void sendNonLootWebhookWithScreenshot(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        this.drawManager.requestNextFrameListener(image -> {
            byte[] imageBytes;
            BufferedImage bufferedImage = (BufferedImage)image;
            try {
                imageBytes = DiscordNotificationsAIOPlugin.convertImageToByteArray(bufferedImage);
            }
            catch (IOException e) {
                log.warn("Error converting image to byte array", (Throwable)e);
                return;
            }
            requestBodyBuilder.addFormDataPart("file", "image.png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])imageBytes));
            this.buildRequestAndSend(url, requestBodyBuilder);
        });
    }

    private void buildRequestAndSend(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        this.sendRequest(request);
    }

    private void sendRequest(Request request) {
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                log.debug("Error submitting webhook", (Throwable)e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                response.close();
            }
        });
    }

    public void dataToPanel(String bossName, String itemName) {
        this.drawManager.requestNextFrameListener(image -> this.discordNotificationsAIOPanel.panelOverride(bossName, itemName, (BufferedImage)image));
    }

    private void resetState() {
        this.currentLevels.clear();
        this.leveledSkills.clear();
        this.shouldSendLevelMessage = false;
        this.shouldSendQuestMessage = false;
        this.shouldSendClueMessage = false;
        this.shouldSendLootMessage = false;
        this.ticksWaited = 0;
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        int groupId = event.getGroupId();
        if (groupId == 153) {
            this.shouldSendQuestMessage = true;
        }
        if (groupId == 73) {
            this.shouldSendClueMessage = true;
        }
    }

    DiscordNotificationsAIOPanel getDiscordNotificationsAIOPanel() {
        return this.discordNotificationsAIOPanel;
    }

    void setDiscordNotificationsAIOPanel(DiscordNotificationsAIOPanel discordNotificationsAIOPanel) {
        this.discordNotificationsAIOPanel = discordNotificationsAIOPanel;
    }
}

