/*
 * Decompiled with CFR 0.152.
 */
package com.discordnotificationsaio;

import com.discordnotificationsaio.ApiTools;
import com.discordnotificationsaio.DiscordNotificationsAIOConfig;
import com.discordnotificationsaio.DiscordNotificationsAIOPlugin;
import com.discordnotificationsaio.rarity.Monster;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscordNotificationsAIOPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(DiscordNotificationsAIOPanel.class);
    final JTextField npcName = new JTextField();
    final JTextField itemName = new JTextField();
    final JLabel thumbnail = new JLabel();
    final JTextPane submitInfo = new JTextPane();
    final JTextField splitMembers = new JTextField();
    private final Client client;
    public BufferedImage before;
    JPanel womPanel = new JPanel();
    JLabel lblGetGroupId = new JLabel();
    JComboBox<Object> groupComboBox = new JComboBox();
    JComboBox<Object> memberList = new JComboBox();
    JButton btnRefresh = new JButton();
    ImageIcon icon = new ImageIcon();

    DiscordNotificationsAIOPanel(DiscordNotificationsAIOPlugin plugin, DiscordNotificationsAIOConfig config, Client client, ArrayList<Monster> mobs) {
        this.client = client;
        this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.setBorder(null);
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{158, 0};
        gridBagLayout.rowHeights = new int[]{176, 27, 0, 185, 1, 161, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel lootPanel = new JPanel();
        lootPanel.setAlignmentY(0.0f);
        lootPanel.setFont(new Font("RuneScape", 0, 13));
        lootPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        lootPanel.setBorder(null);
        GridBagConstraints gbc_lootPanel = new GridBagConstraints();
        gbc_lootPanel.ipadx = 1;
        gbc_lootPanel.fill = 1;
        gbc_lootPanel.insets = new Insets(8, 8, 8, 8);
        gbc_lootPanel.gridx = 0;
        gbc_lootPanel.gridy = 0;
        this.add(lootPanel, gbc_lootPanel);
        GridBagLayout gbl_lootPanel = new GridBagLayout();
        gbl_lootPanel.columnWidths = new int[]{158, 0};
        gbl_lootPanel.rowHeights = new int[]{45, 35, 35, 35};
        gbl_lootPanel.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gbl_lootPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
        lootPanel.setLayout(gbl_lootPanel);
        JLabel lblLootInfo = new JLabel();
        lblLootInfo.setText("Loot Information");
        lblLootInfo.setHorizontalTextPosition(0);
        lblLootInfo.setHorizontalAlignment(0);
        lblLootInfo.setForeground(Color.WHITE);
        lblLootInfo.setFont(new Font("RuneScape", 1, 18));
        lblLootInfo.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        lblLootInfo.setBorder(new EmptyBorder(4, 0, 4, 0));
        GridBagConstraints gbc_lblLootInfo = new GridBagConstraints();
        gbc_lblLootInfo.fill = 2;
        gbc_lblLootInfo.anchor = 15;
        gbc_lblLootInfo.insets = new Insets(8, 0, 5, 0);
        gbc_lblLootInfo.gridx = 0;
        gbc_lblLootInfo.gridy = 0;
        lootPanel.add((Component)lblLootInfo, gbc_lblLootInfo);
        GridBagConstraints gbc_itemName = new GridBagConstraints();
        gbc_itemName.fill = 1;
        gbc_itemName.insets = new Insets(4, 4, 5, 4);
        gbc_itemName.gridx = 0;
        gbc_itemName.gridy = 1;
        lootPanel.add((Component)this.itemName, gbc_itemName);
        this.itemName.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.itemName.setHorizontalAlignment(0);
        this.itemName.setBorder(UIManager.getBorder("FormattedTextField.border"));
        this.itemName.setForeground(Color.WHITE);
        this.itemName.setEditable(true);
        this.itemName.setToolTipText("Item Name");
        this.itemName.setBackground(Color.DARK_GRAY);
        this.itemName.setText("Item Name");
        GridBagConstraints gbc_npcName = new GridBagConstraints();
        gbc_npcName.fill = 1;
        gbc_npcName.insets = new Insets(4, 4, 5, 4);
        gbc_npcName.gridx = 0;
        gbc_npcName.gridy = 2;
        lootPanel.add((Component)this.npcName, gbc_npcName);
        this.npcName.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.npcName.setHorizontalAlignment(0);
        this.npcName.setBorder(UIManager.getBorder("FormattedTextField.border"));
        this.npcName.setForeground(Color.WHITE);
        this.npcName.setEditable(true);
        this.npcName.setToolTipText("Boss/NPC Name");
        this.npcName.setBackground(Color.DARK_GRAY);
        this.npcName.setText("Boss/NPC Name");
        JButton clearNames = new JButton("Reset Loot Information");
        GridBagConstraints gbc_clearNames = new GridBagConstraints();
        gbc_clearNames.gridx = 0;
        gbc_clearNames.gridy = 3;
        lootPanel.add((Component)clearNames, gbc_clearNames);
        clearNames.addActionListener(e -> {});
        clearNames.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        clearNames.setForeground(Color.WHITE);
        clearNames.addActionListener(e -> {
            this.itemName.setText("Item Name");
            this.npcName.setText("Boss/NPC Name");
        });
        this.npcName.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (DiscordNotificationsAIOPanel.this.npcName.getText().equals("Boss/NPC Name")) {
                    DiscordNotificationsAIOPanel.this.npcName.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (DiscordNotificationsAIOPanel.this.npcName.getText().isEmpty()) {
                    DiscordNotificationsAIOPanel.this.npcName.setText("Boss/NPC Name");
                }
            }
        });
        this.itemName.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (DiscordNotificationsAIOPanel.this.itemName.getText().equals("Item Name")) {
                    DiscordNotificationsAIOPanel.this.itemName.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (DiscordNotificationsAIOPanel.this.itemName.getText().isEmpty()) {
                    DiscordNotificationsAIOPanel.this.itemName.setText("Item Name");
                }
            }
        });
        JPanel splitPanel = new JPanel();
        splitPanel.setBorder(null);
        splitPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        GridBagConstraints gbc_splitPanel = new GridBagConstraints();
        gbc_splitPanel.fill = 1;
        gbc_splitPanel.insets = new Insets(8, 8, 8, 8);
        gbc_splitPanel.gridx = 0;
        gbc_splitPanel.gridy = 1;
        this.add(splitPanel, gbc_splitPanel);
        GridBagLayout gbl_splitPanel = new GridBagLayout();
        gbl_splitPanel.columnWidths = new int[]{75, 140, 0};
        gbl_splitPanel.rowHeights = new int[]{45, 35, 35, 0, 0};
        gbl_splitPanel.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gbl_splitPanel.rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        splitPanel.setLayout(gbl_splitPanel);
        JLabel lblSplitInfo = new JLabel();
        lblSplitInfo.setHorizontalTextPosition(0);
        GridBagConstraints gbc_lblSplitInfo = new GridBagConstraints();
        gbc_lblSplitInfo.gridwidth = 2;
        gbc_lblSplitInfo.anchor = 15;
        gbc_lblSplitInfo.fill = 2;
        gbc_lblSplitInfo.insets = new Insets(8, 0, 5, 0);
        gbc_lblSplitInfo.gridx = 0;
        gbc_lblSplitInfo.gridy = 0;
        splitPanel.add((Component)lblSplitInfo, gbc_lblSplitInfo);
        lblSplitInfo.setText("Split Information");
        lblSplitInfo.setHorizontalAlignment(0);
        lblSplitInfo.setForeground(Color.WHITE);
        lblSplitInfo.setFont(new Font("RuneScape", 1, 18));
        lblSplitInfo.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        lblSplitInfo.setBorder(new EmptyBorder(4, 0, 4, 0));
        final JTextField splitValue = new JTextField();
        GridBagConstraints gbc_splitValue = new GridBagConstraints();
        gbc_splitValue.gridwidth = 2;
        gbc_splitValue.fill = 1;
        gbc_splitValue.insets = new Insets(4, 4, 5, 4);
        gbc_splitValue.gridx = 0;
        gbc_splitValue.gridy = 1;
        splitPanel.add((Component)splitValue, gbc_splitValue);
        splitValue.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        splitValue.setHorizontalAlignment(0);
        splitValue.setBorder(UIManager.getBorder("FormattedTextField.border"));
        splitValue.setForeground(Color.WHITE);
        splitValue.setEditable(true);
        splitValue.setToolTipText("Split Value");
        splitValue.setBackground(Color.DARK_GRAY);
        splitValue.setText("Split Value (Per-Player)");
        GridBagConstraints gbc_splitMembers = new GridBagConstraints();
        gbc_splitMembers.gridwidth = 2;
        gbc_splitMembers.insets = new Insets(4, 4, 5, 4);
        gbc_splitMembers.fill = 1;
        gbc_splitMembers.gridx = 0;
        gbc_splitMembers.gridy = 2;
        splitPanel.add((Component)this.splitMembers, gbc_splitMembers);
        this.splitMembers.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.splitMembers.setHorizontalAlignment(0);
        this.splitMembers.setBorder(UIManager.getBorder("FormattedTextField.border"));
        this.splitMembers.setForeground(Color.WHITE);
        this.splitMembers.setEditable(true);
        this.splitMembers.setToolTipText("Split with");
        this.splitMembers.setBackground(Color.DARK_GRAY);
        this.splitMembers.setText("Split with (Player Names)");
        JButton submitLoot = new JButton("Submit");
        GridBagConstraints gbc_submitLoot = new GridBagConstraints();
        gbc_submitLoot.fill = 2;
        gbc_submitLoot.insets = new Insets(0, 6, 6, 4);
        gbc_submitLoot.gridx = 0;
        gbc_submitLoot.gridy = 3;
        splitPanel.add((Component)submitLoot, gbc_submitLoot);
        submitLoot.setSize(new Dimension(70, 30));
        submitLoot.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        submitLoot.setForeground(Color.WHITE);
        JButton reTakeScreenshot = new JButton("Take Screenshot");
        GridBagConstraints gbc_reTakeScreenshot = new GridBagConstraints();
        gbc_reTakeScreenshot.anchor = 13;
        gbc_reTakeScreenshot.gridwidth = 1;
        gbc_reTakeScreenshot.insets = new Insets(0, 0, 6, 6);
        gbc_reTakeScreenshot.gridx = 1;
        gbc_reTakeScreenshot.gridy = 3;
        splitPanel.add((Component)reTakeScreenshot, gbc_reTakeScreenshot);
        reTakeScreenshot.setSize(new Dimension(1, 30));
        reTakeScreenshot.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        reTakeScreenshot.setForeground(Color.WHITE);
        reTakeScreenshot.addActionListener(e -> plugin.dataToPanel(this.npcName.getText(), this.itemName.getText()));
        submitLoot.addActionListener(e -> this.submitLoot(splitValue, this.splitMembers, this.itemName, this.npcName, this.submitInfo, config, mobs, plugin));
        this.splitMembers.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (DiscordNotificationsAIOPanel.this.splitMembers.getText().equals("Split with (Player Names)")) {
                    DiscordNotificationsAIOPanel.this.splitMembers.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (DiscordNotificationsAIOPanel.this.splitMembers.getText().isEmpty()) {
                    DiscordNotificationsAIOPanel.this.splitMembers.setText("Split with (Player Names)");
                }
            }
        });
        splitValue.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (splitValue.getText().equals("Split Value (Per-Player)")) {
                    splitValue.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (splitValue.getText().isEmpty()) {
                    splitValue.setText("Split Value (Per-Player)");
                }
            }
        });
        this.submitInfo.setFont(new Font("RuneScape", 0, 15));
        this.submitInfo.setPreferredSize(new Dimension(0, 0));
        this.submitInfo.setVisible(false);
        this.submitInfo.setFocusable(false);
        this.submitInfo.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.submitInfo.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.submitInfo.setForeground(Color.WHITE);
        this.submitInfo.setEditable(false);
        GridBagConstraints gbc_submitInfo = new GridBagConstraints();
        gbc_submitInfo.anchor = 15;
        gbc_submitInfo.fill = 2;
        gbc_submitInfo.gridx = 0;
        gbc_submitInfo.gridy = 2;
        gbc_submitInfo.insets = new Insets(4, 10, 5, 10);
        this.add(this.submitInfo, gbc_submitInfo);
        this.thumbnail.setAutoscrolls(true);
        this.thumbnail.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.thumbnail.setForeground(Color.WHITE);
        this.thumbnail.setIcon(this.icon);
        GridBagConstraints gbc_thumbnail = new GridBagConstraints();
        gbc_thumbnail.anchor = 15;
        gbc_thumbnail.insets = new Insets(6, 6, 6, 6);
        gbc_thumbnail.gridx = 0;
        gbc_thumbnail.gridy = 5;
        this.add(this.thumbnail, gbc_thumbnail);
    }

    public void panelOverride(String bossName, String itemDropped, BufferedImage screenshot) {
        if (!Objects.equals(this.npcName.getText(), "") && !Objects.equals(this.itemName.getText(), "")) {
            this.npcName.setText(bossName);
            this.itemName.setText(itemDropped);
            this.submitInfo.setFocusable(true);
            this.submitInfo.setVisible(true);
            if (this.itemName.getText().contains("Item Name")) {
                this.submitInfo.setText("Could not get Item Information. Please try again after receiving loot.");
                return;
            }
            this.submitInfo.setText("Found drop: " + itemDropped + " from " + bossName + ".\nFill out split info above and click submit to send to Discord.");
        }
        this.thumbnail.setIcon(new ImageIcon(this.scaleImage(screenshot, 213, 120)));
        this.thumbnail.setHorizontalAlignment(2);
        this.before = screenshot;
    }

    public BufferedImage scaleImage(BufferedImage screenshot, int width, int height) {
        BufferedImage result = new BufferedImage(width, height, 1);
        Graphics2D resultGraphics = (Graphics2D)result.getGraphics();
        resultGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        resultGraphics.drawImage(screenshot, 0, 0, width, height, null);
        resultGraphics.dispose();
        return result;
    }

    public void buildWomPanel() {
        SwingUtilities.invokeLater(this::runBuilder);
    }

    private void runBuilder() {
        JPanel womPanel = new JPanel();
        womPanel.setFont(new Font("RuneScape", 0, 13));
        womPanel.setBorder(null);
        womPanel.setBackground(new Color(30, 30, 30));
        womPanel.setAlignmentY(0.0f);
        GridBagConstraints gbc_womPanel = new GridBagConstraints();
        gbc_womPanel.anchor = 11;
        gbc_womPanel.insets = new Insets(8, 8, 8, 8);
        gbc_womPanel.fill = 2;
        gbc_womPanel.gridx = 0;
        gbc_womPanel.gridy = 3;
        this.add(womPanel, gbc_womPanel);
        GridBagLayout gbl_womPanel = new GridBagLayout();
        gbl_womPanel.columnWidths = new int[]{158, 0, 0};
        gbl_womPanel.rowHeights = new int[]{45, 0, 35, 0};
        gbl_womPanel.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gbl_womPanel.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        womPanel.setLayout(gbl_womPanel);
        JLabel lblWiseOldMan = new JLabel();
        lblWiseOldMan.setText("WiseOldMan");
        lblWiseOldMan.setHorizontalTextPosition(0);
        lblWiseOldMan.setHorizontalAlignment(0);
        lblWiseOldMan.setForeground(Color.WHITE);
        lblWiseOldMan.setFont(new Font("RuneScape", 1, 18));
        lblWiseOldMan.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        lblWiseOldMan.setBorder(new EmptyBorder(4, 0, 4, 0));
        GridBagConstraints gbc_lblWiseOldMan = new GridBagConstraints();
        gbc_lblWiseOldMan.gridwidth = 2;
        gbc_lblWiseOldMan.fill = 2;
        gbc_lblWiseOldMan.anchor = 15;
        gbc_lblWiseOldMan.insets = new Insets(8, 0, 5, 5);
        gbc_lblWiseOldMan.gridx = 0;
        gbc_lblWiseOldMan.gridy = 0;
        womPanel.add((Component)lblWiseOldMan, gbc_lblWiseOldMan);
        JLabel lblGetGroupId = new JLabel("Get List of Members by Group ID:");
        lblGetGroupId.setForeground(Color.WHITE);
        GridBagConstraints gbc_lblGetGroupId = new GridBagConstraints();
        gbc_lblGetGroupId.gridwidth = 2;
        gbc_lblGetGroupId.insets = new Insets(0, 0, 5, 5);
        gbc_lblGetGroupId.gridx = 0;
        gbc_lblGetGroupId.gridy = 1;
        womPanel.add((Component)lblGetGroupId, gbc_lblGetGroupId);
        JComboBox<Object> groupComboBox = new JComboBox<Object>();
        GridBagConstraints gbc_groupComboBox = new GridBagConstraints();
        gbc_groupComboBox.fill = 2;
        gbc_groupComboBox.insets = new Insets(4, 4, 5, 4);
        gbc_groupComboBox.gridx = 0;
        gbc_groupComboBox.gridy = 2;
        womPanel.add(groupComboBox, gbc_groupComboBox);
        JButton btnRefresh = new JButton("Refresh");
        btnRefresh.setForeground(Color.WHITE);
        btnRefresh.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        GridBagConstraints gbc_btnRefresh = new GridBagConstraints();
        gbc_btnRefresh.insets = new Insets(4, 4, 5, 4);
        gbc_btnRefresh.gridx = 1;
        gbc_btnRefresh.gridy = 2;
        womPanel.add((Component)btnRefresh, gbc_btnRefresh);
        JComboBox<Object> memberList = new JComboBox<Object>();
        GridBagConstraints gbc_memberList = new GridBagConstraints();
        gbc_memberList.insets = new Insets(4, 4, 5, 4);
        gbc_memberList.fill = 1;
        gbc_memberList.gridx = 0;
        gbc_memberList.gridy = 3;
        memberList.setForeground(Color.WHITE);
        womPanel.add(memberList, gbc_memberList);
        JButton btnAddMember = new JButton("Add to Split");
        GridBagConstraints gbc_btnAddMember = new GridBagConstraints();
        gbc_btnAddMember.gridx = 1;
        gbc_btnAddMember.gridy = 3;
        btnAddMember.setForeground(Color.WHITE);
        womPanel.add((Component)btnAddMember, gbc_btnAddMember);
        this.refreshPanel(womPanel, groupComboBox, memberList, lblGetGroupId, btnRefresh);
        btnRefresh.addActionListener(e -> SwingUtilities.invokeLater(() -> {
            int groupIndex = 0;
            if (Objects.equals(btnRefresh.getText(), "Refresh")) {
                this.refreshPanel(womPanel, groupComboBox, memberList, lblGetGroupId, btnRefresh);
            }
            if (Objects.equals(btnRefresh.getText(), "Search")) {
                groupIndex = groupComboBox.getSelectedIndex();
            }
            int groupId = Integer.parseInt(String.valueOf(groupComboBox.getSelectedItem()));
            groupComboBox.removeAllItems();
            try {
                groupComboBox.setModel(new DefaultComboBoxModel<Object>(Objects.requireNonNull(ApiTools.getWomGroupIds(Objects.requireNonNull(this.client.getLocalPlayer().getName())))));
            }
            catch (IOException | InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            memberList.removeAllItems();
            int finalGroupIndex = groupIndex;
            CompletableFuture.runAsync(() -> {
                try {
                    memberList.setModel(new DefaultComboBoxModel<Object>(Objects.requireNonNull(ApiTools.getGroupMembers(groupId))));
                }
                catch (IOException | InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                try {
                    String clanName = ApiTools.getClanName(groupId);
                    lblGetGroupId.setText(clanName);
                }
                catch (IOException | InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                groupComboBox.setSelectedIndex(finalGroupIndex);
                btnRefresh.setText("Search");
            });
        }));
        btnAddMember.addActionListener(e -> {
            if (this.splitMembers.getText().contains("Split with")) {
                this.splitMembers.setText(Objects.requireNonNull(memberList.getSelectedItem()).toString());
            } else {
                if (this.splitMembers.getText().contains((CharSequence)Objects.requireNonNull(memberList.getSelectedItem()))) {
                    return;
                }
                this.splitMembers.setText(this.splitMembers.getText() + ", " + Objects.requireNonNull(memberList.getSelectedItem()));
            }
        });
    }

    public void submitLoot(JTextField splitValue, JTextField splitMembers, JTextField itemName, JTextField npcName, JTextPane submitInfo, DiscordNotificationsAIOConfig config, ArrayList<Monster> mobs, DiscordNotificationsAIOPlugin plugin) {
        CompletableFuture.runAsync(() -> {
            String notificationType;
            String itemText = "Item Name";
            String npcText = "Boss/NPC Name";
            String valueText = "Split Value (Per-Player)";
            String membersText = "Split with (Player Names)";
            Object splitSubmitText = "";
            submitInfo.setFocusable(true);
            submitInfo.setVisible(true);
            splitSubmitText = !splitMembers.getText().contains(membersText) || !splitValue.getText().contains(valueText) || !itemName.getText().contains(itemText) || !npcName.getText().contains(npcText) ? "Sent screenshot with:\n" : (String)splitSubmitText + "Some fields were missing text.\n";
            splitSubmitText = itemName.getText().contains(itemText) ? (String)splitSubmitText + "Could not get Item Name." : (String)splitSubmitText + "Item Name: " + itemName.getText();
            if (npcName.getText().contains(npcText)) {
                splitSubmitText = (String)splitSubmitText + "\nCould not get Boss/NPC Name.";
                notificationType = "Manual Upload";
            } else {
                splitSubmitText = (String)splitSubmitText + "\nBoss/NPC Name: " + npcName.getText();
                notificationType = "Loot Received";
            }
            splitSubmitText = splitValue.getText().contains(valueText) ? (String)splitSubmitText + "\nCould not get Split Value." : (String)splitSubmitText + "\nSplit Value: " + splitValue.getText();
            if (splitMembers.getText().contains(membersText)) {
                splitSubmitText = (String)splitSubmitText + "\nCould not get Split Members.";
            } else {
                notificationType = "Split Loot";
            }
            if (!(itemName.getText().contains(itemText) || npcName.getText().contains(npcText) || splitMembers.getText().contains(membersText) || splitValue.getText().contains(valueText))) {
                try {
                    String rarity = config.includeRarity() ? Objects.requireNonNull(ApiTools.getItemRarity(mobs, npcName.getText(), itemName.getText())) : "";
                    plugin.sendLootMessage(itemName.getText(), null, npcName.getText(), splitValue.getText(), notificationType, "", splitMembers.getText(), rarity, false);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            } else if (!itemName.getText().contains(itemText) && !npcName.getText().contains(npcText)) {
                try {
                    String rarity = config.includeRarity() ? Objects.requireNonNull(ApiTools.getItemRarity(mobs, npcName.getText(), itemName.getText())) : "";
                    plugin.sendLootMessage(itemName.getText(), null, npcName.getText(), "", notificationType, itemName.getText(), "", rarity, false);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            } else if (!splitMembers.getText().contains(membersText) && !splitValue.getText().contains(valueText)) {
                plugin.sendLootMessage("a split", null, "", splitValue.getText(), notificationType, "", splitMembers.getText(), "", false);
            } else if (itemName.getText().contains(itemText) || npcName.getText().contains(npcText)) {
                splitSubmitText = splitValue.getText().contains(valueText) || splitMembers.getText().contains(membersText) ? "Could not get Split or Item Information. Please try again after receiving loot." : "Could not get Item Information. Please try again after receiving loot.";
            }
            submitInfo.setEditable(true);
            submitInfo.setText((String)splitSubmitText);
            itemName.setText(itemText);
            npcName.setText(npcText);
            splitValue.setText(valueText);
            splitMembers.setText(membersText);
        });
    }

    public void refreshPanel(JPanel womPanel, JComboBox<Object> groupComboBox, JComboBox<Object> memberList, JLabel lblGetGroupId, JButton btnRefresh) {
        SwingUtilities.invokeLater(() -> {
            this.womPanel = womPanel;
            this.groupComboBox = groupComboBox;
            this.memberList = memberList;
            this.lblGetGroupId = lblGetGroupId;
            this.btnRefresh = btnRefresh;
            CompletableFuture.runAsync(() -> {
                int groupId;
                try {
                    groupComboBox.setModel(new DefaultComboBoxModel<Object>(Objects.requireNonNull(ApiTools.getWomGroupIds(Objects.requireNonNull(this.client.getLocalPlayer().getName())))));
                    groupId = Integer.parseInt(String.valueOf(groupComboBox.getSelectedItem()));
                    String clanName = ApiTools.getClanName(groupId);
                    lblGetGroupId.setText(clanName);
                }
                catch (IOException | InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                try {
                    groupId = Integer.parseInt(String.valueOf(groupComboBox.getSelectedItem()));
                    memberList.setModel(new DefaultComboBoxModel<Object>(Objects.requireNonNull(ApiTools.getGroupMembers(groupId))));
                }
                catch (IOException | InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                btnRefresh.setText("Search");
            });
        });
    }
}

