/*
 * Decompiled with CFR 0.152.
 */
package com.discordnotificationsaio;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="discordnotificationsaio")
public interface DiscordNotificationsAIOConfig
extends Config {
    @ConfigSection(name="Valuable Loot", description="Options for Valuable Loot Notifications", position=5)
    public static final String valuableLootSection = "valuable loot options";
    @ConfigSection(name="Levelling", description="The config for levelling notifications", position=11, closedByDefault=true)
    public static final String levellingConfig = "levellingConfig";
    @ConfigSection(name="Questing", description="The config for questing notifications", position=19, closedByDefault=true)
    public static final String questingConfig = "questingConfig";
    @ConfigSection(name="Deaths", description="The config for death notifications", position=22, closedByDefault=true)
    public static final String deathConfig = "deathConfig";
    @ConfigSection(name="Clue Scrolls", description="The config for clue scroll notifications", position=26, closedByDefault=true)
    public static final String clueConfig = "clueConfig";
    @ConfigSection(name="Pets", description="The config for pet notifications", position=30, closedByDefault=true)
    public static final String petConfig = "petConfig";
    @ConfigSection(name="Collection Log", description="The config for collection log notifications", position=34, closedByDefault=true)
    public static final String collectionLogConfig = "collectionLogConfig";
    @ConfigSection(name="Advanced", description="Advanced/Experimental Options", position=150)
    public static final String advancedSection = "advanced";

    @ConfigItem(keyName="webhook", name="Default WebHook", description="The main webhook used to send messages to Discord.", position=1)
    public String webhook();

    @ConfigItem(keyName="autoLog", name="Automatic Notifications", description="Send Notifications to Discord on Level-up, Loot, Deaths, Quests, or Collection Log Completion", position=2)
    default public boolean autoLog() {
        return true;
    }

    @ConfigItem(keyName="autoWebHookToggle", name="Use Separate WebHook?", description="Use a secondary WebHook for Automatic Notifications, separate from your Split Tracking one.", position=3)
    default public boolean autoWebHookToggle() {
        return false;
    }

    @ConfigItem(keyName="autoWebHook", name="Automatic WebHook", description="Secondary WebHook for Automatic Loot Logging.", position=4)
    public String autoWebHook();

    @ConfigItem(keyName="sendScreenshot", name="Send Screenshot?", description="Include a screenshot in the discord message?", position=6, section="valuable loot options")
    default public boolean sendScreenshot() {
        return true;
    }

    @ConfigItem(keyName="bingo", name="Include Bingo/Event String", description="Add an event string to your screenshot's message", position=7, section="valuable loot options")
    default public boolean includeBingo() {
        return false;
    }

    @ConfigItem(keyName="bingoString", name="Custom Bingo/Event String", description="Insert your custom event here.", position=8, section="valuable loot options")
    default public String bingoString() {
        return "ABC123";
    }

    @ConfigItem(keyName="valuableDrop", name="Include Valuable drops", description="Configures whether valuable drops will be automatically sent to discord.", position=9, section="valuable loot options")
    default public boolean includeValuableDrops() {
        return true;
    }

    @ConfigItem(keyName="valuableDropThreshold", name="Minimum Value", description="The minimum value of a drop for it to send a discord message.", position=10, section="valuable loot options")
    default public int valuableDropThreshold() {
        return 100000;
    }

    @ConfigItem(keyName="includeRarity", name="Include Rarity", description="Include item rarity in the Discord message?", position=11, section="valuable loot options")
    default public boolean includeRarity() {
        return true;
    }

    @ConfigItem(keyName="rarityThreshold", name="Minimum Rarity", description="The minimum rarity of a drop for it to send a discord message. (1/x)", position=11, section="valuable loot options")
    default public int rarityThreshold() {
        return 1;
    }

    @ConfigItem(keyName="valuableWebHookToggle", name="Separate Loot WebHook?", description="Use a custom WebHook for Valuable Loot Notifications, separate from any other WebHooks.", section="valuable loot options", position=11)
    default public boolean valuableWebHookToggle() {
        return false;
    }

    @ConfigItem(keyName="valuableWebHook", name="Valuable Loot WebHook", description="Secondary WebHook for Valuable Loot specifically.", section="valuable loot options", position=11)
    public String valuableWebHook();

    @ConfigItem(keyName="includeLevelling", name="Send Levelling Notifications", description="Send messages when you level up a skill.", section="levellingConfig", position=12)
    default public boolean includeLevelling() {
        return true;
    }

    @ConfigItem(keyName="minimumLevel", name="Minimum level", description="Levels greater than or equal to this value will send a message.", section="levellingConfig", position=13)
    default public int minLevel() {
        return 0;
    }

    @ConfigItem(keyName="levelInterval", name="Send every X levels", description="Only levels that are a multiple of this value are sent. Level 99 will always be sent regardless of this value.", section="levellingConfig", position=14)
    default public int levelInterval() {
        return 1;
    }

    @ConfigItem(keyName="linearLevelModifier", name="Linear Level Modifier", description="Send every `max(-.1x + linearLevelMax, 1)` levels. Will override `Send every X levels` if set to above zero.", section="levellingConfig", position=15)
    default public double linearLevelMax() {
        return 0.0;
    }

    @ConfigItem(keyName="levelMessage", name="Level Message", description="Message to send to Discord on Level", section="levellingConfig", position=16)
    default public String levelMessage() {
        return "$name leveled $skill to $level";
    }

    @ConfigItem(keyName="andLevelMessage", name="Multi Skill Level Message", description="Message to send to Discord when Multi Skill Level", section="levellingConfig", position=17)
    default public String andLevelMessage() {
        return ", and $skill to $level";
    }

    @ConfigItem(keyName="sendLevellingScreenshot", name="Send level-up screenshots?", description="Include a screenshot when leveling up.", section="levellingConfig", position=18)
    default public boolean sendLevellingScreenshot() {
        return true;
    }

    @ConfigItem(keyName="levelWebHookToggle", name="Separate Level-Up WebHook?", description="Use a custom WebHook for Levelling Notifications, separate from any other WebHooks.", section="levellingConfig", position=19)
    default public boolean levelWebHookToggle() {
        return false;
    }

    @ConfigItem(keyName="levelWebHook", name="Level-Up WebHook", description="Secondary WebHook for levelling up specifically.", section="levellingConfig", position=20)
    public String levelWebHook();

    @ConfigItem(keyName="includeQuests", name="Send Quest Notifications", description="Send messages when you complete a quest.", section="questingConfig")
    default public boolean includeQuestComplete() {
        return true;
    }

    @ConfigItem(keyName="questMessage", name="Quest Message", description="Message to send to Discord on Quest", section="questingConfig", position=20)
    default public String questMessage() {
        return "$name has just completed: $quest";
    }

    @ConfigItem(keyName="sendQuestingScreenshot", name="Include quest screenshots", description="Include a screenshot with the discord notification when leveling up.", section="questingConfig", position=21)
    default public boolean sendQuestingScreenshot() {
        return true;
    }

    @ConfigItem(keyName="questWebHookToggle", name="Separate Quest WebHook?", description="Use a custom WebHook for Quest Notifications, separate from any other WebHooks.", section="questingConfig", position=22)
    default public boolean questWebHookToggle() {
        return false;
    }

    @ConfigItem(keyName="questWebHook", name="Quest WebHook", description="Secondary WebHook for Quests specifically.", section="questingConfig", position=23)
    public String questWebHook();

    @ConfigItem(keyName="includeDeaths", name="Send Death Notifications", description="Send messages when you die to discord.", section="deathConfig", position=23)
    default public boolean includeDeath() {
        return true;
    }

    @ConfigItem(keyName="deathMessage", name="Death Message", description="Message to send to Discord on Death", section="deathConfig", position=24)
    default public String deathMessage() {
        return "$name has just died!";
    }

    @ConfigItem(keyName="sendDeathScreenshot", name="Include death screenshots", description="Include a screenshot with the discord notification when you die.", section="deathConfig", position=25)
    default public boolean sendDeathScreenshot() {
        return true;
    }

    @ConfigItem(keyName="deathWebHookToggle", name="Separate Death WebHook?", description="Use a custom WebHook for Death Notifications, separate from any other WebHooks.", section="deathConfig", position=26)
    default public boolean deathWebHookToggle() {
        return false;
    }

    @ConfigItem(keyName="deathWebHook", name="Death WebHook", description="Secondary WebHook for Deaths specifically.", section="deathConfig", position=27)
    public String deathWebHook();

    @ConfigItem(keyName="includeClues", name="Send Clue Notifications", description="Send messages when you complete a clue scroll.", section="clueConfig", position=27)
    default public boolean includeClue() {
        return true;
    }

    @ConfigItem(keyName="clueMessage", name="Clue Message", description="Message to send to Discord on Clue", section="clueConfig", position=28)
    default public String clueMessage() {
        return "$name has just completed a clue scroll!";
    }

    @ConfigItem(keyName="sendClueScreenshot", name="Include Clue screenshots", description="Include a screenshot with the discord notification when you complete a clue.", section="clueConfig", position=29)
    default public boolean sendClueScreenshot() {
        return true;
    }

    @ConfigItem(keyName="clueWebHookToggle", name="Separate Clue WebHook?", description="Use a custom WebHook for Clue Notifications, separate from any other WebHooks.", section="clueConfig", position=30)
    default public boolean clueWebHookToggle() {
        return false;
    }

    @ConfigItem(keyName="clueWebHook", name="Clue WebHook", description="Secondary WebHook for Clues specifically.", section="clueConfig", position=31)
    public String clueWebHook();

    @ConfigItem(keyName="includePets", name="Send Pet Notifications", description="Send messages when you receive a pet.", section="petConfig", position=31)
    default public boolean setPets() {
        return true;
    }

    @ConfigItem(keyName="petMessage", name="Pet Message", description="Message to send to Discord on Pet", section="petConfig", position=32)
    default public String petMessage() {
        return "$name has just received a pet!";
    }

    @ConfigItem(keyName="sendPetScreenshot", name="Include Pet screenshots", description="Include a screenshot with the discord notification when you receive a pet.", section="petConfig", position=33)
    default public boolean sendPetScreenshot() {
        return true;
    }

    @ConfigItem(keyName="petWebHookToggle", name="Separate Pet WebHook?", description="Use a custom WebHook for Pet Notifications, separate from any other WebHooks.", section="petConfig", position=34)
    default public boolean petWebHookToggle() {
        return false;
    }

    @ConfigItem(keyName="petWebHook", name="Pet WebHook", description="Secondary WebHook for Pets specifically.", section="petConfig", position=35)
    public String petWebHook();

    @ConfigItem(keyName="includeCollectionLogs", name="Send Collection Log Notifications", description="Send messages when you receive a collection log entry.", section="collectionLogConfig", position=35)
    default public boolean setCollectionLogs() {
        return true;
    }

    @ConfigItem(keyName="collectionLogMessage", name="Collection Log Message", description="Message to send to Discord on Collection Log", section="collectionLogConfig", position=36)
    default public String collectionLogMessage() {
        return "$name just received a new collection log item: $itemName!";
    }

    @ConfigItem(keyName="sendCollectionLogScreenshot", name="Include Collection Log screenshots", description="Include a screenshot with the discord notification when you receive a collection log item.", section="collectionLogConfig", position=37)
    default public boolean sendCollectionLogScreenshot() {
        return true;
    }

    @ConfigItem(keyName="logWebHookToggle", name="Separate Collection Log WebHook?", description="Use a custom WebHook for Collection Log Notifications, separate from any other WebHooks.", section="collectionLogConfig", position=38)
    default public boolean logWebHookToggle() {
        return false;
    }

    @ConfigItem(keyName="logWebHook", name="Collection Log WebHook", description="Secondary WebHook for Collection Log specifically.", section="collectionLogConfig", position=39)
    public String logWebHook();

    @ConfigItem(keyName="customField", name="Custom Field Title", description="", position=38, section="valuable loot options")
    default public String customField() {
        return "";
    }

    @ConfigItem(keyName="customValue", name="Custom Field Value", description="", position=39, section="valuable loot options")
    default public String customValue() {
        return "";
    }

    @ConfigItem(keyName="whiteListedRSNs", name="Whitelisted RSNs", description="(optional) Comma-separated list of RSNs which are allowed to post to the webhook, can prevent drops being posted from all your accounts", section="advanced", position=40)
    default public String whiteListedRSNs() {
        return "";
    }

    @ConfigItem(keyName="raidLoot", name="Include raid loot (Experimental)", description="Configures whether a message will be automatically sent to discord when you obtain a raid unique.", position=100, section="valuable loot options")
    default public boolean includeRaidLoot() {
        return true;
    }

    @ConfigItem(keyName="codeBlocks", name="Show Code Blocks?", description="Configures whether a message will have code blocks in the embeds.", position=100, section="advanced")
    default public boolean codeBlocks() {
        return true;
    }

    @ConfigItem(keyName="rawJson", name="Copy Json to Clipboard", description="Configures or not to copy the webhook's Json output to your clipboard.", position=101, section="advanced")
    default public boolean rawJson() {
        return false;
    }
}

