/*
 * Decompiled with CFR 0.152.
 */
package com.discordnotificationsaio;

import com.discordnotificationsaio.rarity.Drop;
import com.discordnotificationsaio.rarity.Monster;
import com.discordnotificationsaio.wiseoldman.Groups;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.inject.Inject;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.json.JSONArray;
import org.json.JSONObject;

public class ApiTools {
    @Inject
    private static OkHttpClient okHttpClient;

    public static Object[] getWomGroupIds(String playerName) throws IOException, InterruptedException {
        String compUrl = "https://api.wiseoldman.net/players/username/" + playerName.replace(" ", "_").replace("%20", "_") + "/competitions";
        Request request = new Request.Builder().url(compUrl).build();
        String responseBody = Objects.requireNonNull(RuneLiteAPI.CLIENT.newCall(request).execute().body()).string();
        if (!responseBody.contains("groupId")) {
            return null;
        }
        JSONArray jsonArray = new JSONArray(responseBody);
        return IntStream.range(0, jsonArray.length()).mapToObj(index -> ((JSONObject)jsonArray.get(index)).optString("groupId")).distinct().sorted().toArray();
    }

    public static Object[] getGroupMembers(int groupId) throws IOException, InterruptedException {
        String groupUrl = "https://api.wiseoldman.net/groups/" + groupId + "/members";
        Request request = new Request.Builder().url(groupUrl).build();
        String responseBody = Objects.requireNonNull(RuneLiteAPI.CLIENT.newCall(request).execute().body()).string();
        if (!responseBody.contains("username")) {
            return null;
        }
        JSONArray jsonArray = new JSONArray(responseBody);
        return IntStream.range(0, jsonArray.length()).mapToObj(index -> ((JSONObject)jsonArray.get(index)).optString("displayName")).sorted(String.CASE_INSENSITIVE_ORDER).toArray(String[]::new);
    }

    public static String getClanName(int groupId) throws IOException, InterruptedException {
        String groupUrl = String.format("https://api.wiseoldman.net/groups/%d", groupId);
        Request request = new Request.Builder().url(groupUrl).build();
        String responseBody = Objects.requireNonNull(RuneLiteAPI.CLIENT.newCall(request).execute().body()).string();
        if (!responseBody.contains("name")) {
            return null;
        }
        Groups resJson = (Groups)RuneLiteAPI.GSON.fromJson(responseBody, Groups.class);
        return resJson.getName();
    }

    public static String getItemRarity(ArrayList<Monster> mobs, String npcName, String itemName) throws IOException {
        String[] rarity = new String[1];
        Optional<Monster> killed = mobs.stream().filter(monster -> monster.getId().equals(npcName)).findFirst();
        killed.ifPresent(k -> {
            Optional<Drop> dropped = k.getDrops().stream().filter(drop -> drop.getName().equals(itemName)).findFirst();
            dropped.ifPresent(drop -> {
                rarity[0] = drop.getRarity();
            });
            if (!Objects.equals(rarity[0], "Always")) {
                rarity[0] = rarity[0].split("/")[1];
            }
        });
        if (rarity[0] == null) {
            return "";
        }
        return rarity[0];
    }
}

