/*
 * Decompiled with CFR 0.152.
 */
package com.hzy.cmbcalc;

import com.hzy.cmbcalc.CombatLevelCalculatorPanel;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Combat Level Calculator", description="Enable the Combat Level Calculator panel", tags={"combat, level, calc, panel"})
public class CombatLevelCalculatorPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CombatLevelCalculatorPlugin.class);
    @Inject
    private SkillIconManager iconManager;
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    private NavigationButton uiNavigationButton;

    protected void startUp() throws Exception {
        this.iconManager = new SkillIconManager();
        CombatLevelCalculatorPanel combatLevelCalculatorPanel = new CombatLevelCalculatorPanel(this.iconManager);
        BufferedImage icon = ImageUtil.loadImageResource(CombatLevelCalculatorPlugin.class, (String)"/cmb.png");
        this.uiNavigationButton = NavigationButton.builder().tooltip("Combat Lvl Calculator").icon(icon).priority(12).panel((PluginPanel)combatLevelCalculatorPanel).build();
        this.clientToolbar.addNavigation(this.uiNavigationButton);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.uiNavigationButton);
    }
}

