/*
 * Decompiled with CFR 0.152.
 */
package com.hzy.cmbcalc;

import com.hzy.cmbcalc.CombatLevelCalculatorPlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Skill;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.FlatTextField;
import net.runelite.client.util.ImageUtil;

public class CombatLevelCalculatorPanel
extends PluginPanel {
    private final SkillIconManager iconManager;
    private final GridBagConstraints c;
    private JLabel cmbLevel;
    private final Skill[] skills;
    private final ArrayList<FlatTextField> skillFields;
    private final EmptyBorder emptyBorder;
    private final Dimension inputDimension;
    private final double xratio = 0.325;
    private int[] levels = new int[]{1, 1, 1, 10, 1, 1, 1};

    CombatLevelCalculatorPanel(SkillIconManager iconManager) {
        this.iconManager = iconManager;
        this.skillFields = new ArrayList();
        this.inputDimension = new Dimension(56, 44);
        this.c = new GridBagConstraints();
        this.c.fill = 0;
        this.setBorder(new EmptyBorder(20, 10, 10, 10));
        this.emptyBorder = new EmptyBorder(8, 2, 8, 2);
        this.skills = new Skill[]{Skill.ATTACK, Skill.STRENGTH, Skill.DEFENCE, Skill.HITPOINTS, Skill.RANGED, Skill.MAGIC, Skill.PRAYER};
        this.drawPanel();
    }

    void drawPanel() {
        this.setLayout(new GridBagLayout());
        this.c.gridx = 1;
        this.c.gridy = 0;
        this.addSkillInputs();
        this.cmbLevel = new JLabel();
        this.cmbLevel.setText("3.4");
        this.cmbLevel.setFont(FontManager.getRunescapeBoldFont());
        this.cmbLevel.setForeground(Color.WHITE);
        this.cmbLevel.setBorder(this.emptyBorder);
        this.c.gridx = 1;
        this.c.gridy = 9;
        this.add(this.cmbLevel, this.c);
        JButton button = new JButton("Calculate");
        button.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        button.setFont(FontManager.getRunescapeFont());
        button.setForeground(Color.WHITE);
        button.setBorder(this.emptyBorder);
        button.setFocusPainted(false);
        this.c.gridx = 1;
        this.c.gridy = 11;
        ActionListener listener = e -> {
            this.calc();
            button.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        };
        button.addActionListener(listener);
        this.add(button, this.c);
        ImageIcon icon = new ImageIcon(ImageUtil.loadImageResource(CombatLevelCalculatorPlugin.class, (String)"/cmb.png"));
        this.c.gridx = 0;
        this.c.gridy = 9;
        JLabel cmbLabel = new JLabel(icon);
        cmbLabel.setBorder(this.emptyBorder);
        this.add(cmbLabel, this.c);
    }

    void addSkillInputs() {
        KeyAdapter listener = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char ch = e.getKeyChar();
                if ((ch < '0' || ch > '9') && ch != '\b') {
                    e.consume();
                }
            }
        };
        for (int i = 0; i < 7; ++i) {
            this.c.gridx = 1;
            this.c.ipady = 4;
            this.c.ipadx = 4;
            ++this.c.gridy;
            FlatTextField field = new FlatTextField();
            field.setText(this.skills[i] != Skill.HITPOINTS ? "1" : "10");
            field.setPreferredSize(this.inputDimension);
            field.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            field.setHoverBackgroundColor(ColorScheme.DARKER_GRAY_HOVER_COLOR);
            field.setForeground(Color.WHITE);
            field.setFont(FontManager.getRunescapeSmallFont());
            field.addKeyListener((KeyListener)listener);
            this.add((Component)field, this.c);
            this.skillFields.add(field);
            this.c.ipady = 0;
            this.c.ipadx = 0;
            ImageIcon skillIcon = new ImageIcon(this.iconManager.getSkillImage(this.skills[i]));
            this.c.gridx = 0;
            JLabel skillLabel = new JLabel(skillIcon);
            skillLabel.setBorder(this.emptyBorder);
            this.add(skillLabel, this.c);
        }
    }

    void calc() {
        for (int j = 0; j < 7; ++j) {
            this.levels[j] = Integer.parseInt(this.skillFields.get(j).getText());
        }
        double lvl = 0.25 * (double)(this.levels[2] + this.levels[3] + this.levels[6] / 2) + Math.max(Math.max(0.325 * (double)(this.levels[0] + this.levels[1]), 0.325 * (double)(this.levels[4] / 2 + this.levels[4])), 0.325 * (double)(this.levels[5] / 2 + this.levels[5]));
        this.cmbLevel.setText("" + (lvl < 3.0 ? 3.0 : Math.min(lvl, 126.0)));
    }
}

