/*
 * Decompiled with CFR 0.152.
 */
package com.TeleportLogger;

import com.TeleportLogger.TeleportLoggerPanel;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Teleport Logger", description="Utility for tracking a list of all ingame teleportation methods.")
public class TeleportLoggerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TeleportLoggerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    private TeleportLoggerPanel panel;
    private NavigationButton navButton;
    private WorldPoint lastWorldPoint = null;
    private int ticksStill = 1;

    public void startUp() {
        this.panel = (TeleportLoggerPanel)((Object)this.injector.getInstance(TeleportLoggerPanel.class));
        this.panel.init();
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"Transportation_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Teleport Logger").icon(icon).priority(100).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return;
        }
        WorldPoint newWorldPoint = player.getWorldLocation();
        if (this.lastWorldPoint == null) {
            this.lastWorldPoint = newWorldPoint;
            return;
        }
        int distance = newWorldPoint.distanceTo(this.lastWorldPoint);
        if (distance == 0) {
            ++this.ticksStill;
            return;
        }
        if (distance > 2) {
            this.panel.appendText(this.lastWorldPoint + "\t" + newWorldPoint + "\t" + this.ticksStill);
        }
        this.ticksStill = 1;
        this.lastWorldPoint = newWorldPoint;
    }
}

