/*
 * Decompiled with CFR 0.152.
 */
package com.zom.molemanmode;

import com.google.inject.Provides;
import com.zom.molemanmode.MolemanModeConfig;
import com.zom.molemanmode.MolemanModeOverlay;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Moleman Mode")
public class MolemanModePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MolemanModePlugin.class);
    @Inject
    private Client client;
    @Inject
    private MolemanModeConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MolemanModeOverlay overlay;
    private final HashSet<Integer> tutorialIslandRegionIds = new HashSet();
    private final HashSet<Integer> whiteListRegionIds = new HashSet();
    private final HashSet<Integer> blackListRegionIds = new HashSet();
    private long timeAvailable;
    private String ticksSpentAboveGroundStr;
    private long ticksSpentAboveGround;
    private int warningCount;
    private boolean aboveGround;
    private boolean formatTicksAsTime;
    private boolean showRegion;
    private boolean showAboveGroundState;
    private long xpUntilNextThreshold;
    private boolean showOverlay;
    private boolean prevState;
    private boolean enabled;
    private WorldPoint lastPlayerLocation;
    boolean loggingIn;

    protected void startUp() throws Exception {
        this.whiteListRegionIds.add(12079);
        this.whiteListRegionIds.add(12080);
        this.whiteListRegionIds.add(12335);
        this.whiteListRegionIds.add(12336);
        this.whiteListRegionIds.add(12592);
        this.enabled = this.config.manualToggle();
        this.showOverlay = this.config.showOverlay();
        this.warningCount = this.config.timeWarningThreshold();
        this.formatTicksAsTime = this.config.formatTimer();
        this.showRegion = this.config.showRegion();
        this.showAboveGroundState = this.config.showAboveGround();
        this.aboveGround = false;
        this.prevState = false;
        this.updateWhitelist();
        this.updateBlackList();
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.enabled = false;
        this.showOverlay = false;
        this.aboveGround = false;
        this.prevState = false;
        this.warningCount = -1;
        this.formatTicksAsTime = false;
        this.showRegion = false;
        this.showAboveGroundState = false;
        this.whiteListRegionIds.clear();
        this.blackListRegionIds.clear();
        this.overlayManager.remove((Overlay)this.overlay);
        this.lastPlayerLocation = null;
    }

    @Provides
    MolemanModeConfig provideConfig(ConfigManager configManager) {
        return (MolemanModeConfig)configManager.getConfig(MolemanModeConfig.class);
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.client.getLocalPlayer() == null) {
            return;
        }
        this.evaluateIfMoleMan();
        if (this.aboveGround) {
            ++this.ticksSpentAboveGround;
        }
        this.updateTime();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOGIN_SCREEN: {
                this.aboveGround = false;
                if (this.lastPlayerLocation != null) {
                    this.saveConfig();
                }
                this.ticksSpentAboveGround = 0L;
                this.lastPlayerLocation = null;
                break;
            }
            case LOGGING_IN: {
                this.loggingIn = true;
                break;
            }
            case LOGGED_IN: {
                if (!this.loggingIn) break;
                this.loggingIn = false;
                this.onLogin();
            }
        }
    }

    private void onLogin() {
        this.loadConfig();
        WorldPoint newLocation = this.client.getLocalPlayer().getWorldLocation();
        assert (newLocation != null);
        if (this.lastPlayerLocation == null) {
            this.lastPlayerLocation = newLocation;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if ("molemanmode".equals(event.getGroup())) {
            String key;
            switch (key = event.getKey()) {
                case "showOverlay": {
                    this.showOverlay = this.config.showOverlay();
                    break;
                }
                case "manualToggle": {
                    this.enabled = this.config.manualToggle();
                    break;
                }
                case "whiteList": {
                    this.updateWhitelist();
                    break;
                }
                case "blackList": {
                    this.updateBlackList();
                    break;
                }
                case "showRegion": {
                    this.showRegion = this.config.showRegion();
                    break;
                }
                case "formatTime": {
                    this.formatTicksAsTime = this.config.formatTimer();
                    break;
                }
                case "showAboveGround": {
                    this.showAboveGroundState = this.config.showAboveGround();
                    break;
                }
                case "timeWarning": {
                    this.warningCount = this.config.timeWarningThreshold();
                }
            }
        }
    }

    private void saveConfig() {
        this.ticksSpentAboveGroundStr = String.valueOf(this.ticksSpentAboveGround);
        this.configManager.setConfiguration("molemanmode", "spentTicks", this.ticksSpentAboveGroundStr);
    }

    private void loadConfig() {
        this.ticksSpentAboveGroundStr = this.configManager.getConfiguration("molemanmode", "spentTicks");
        if (this.ticksSpentAboveGroundStr == null) {
            this.ticksSpentAboveGround = 0L;
            log.info("Failed to load ticks above. Setting it to 0.");
        } else {
            this.ticksSpentAboveGround = Long.parseLong(this.ticksSpentAboveGroundStr);
            log.info("Loaded ticks spent above. Setting it to {}", (Object)this.ticksSpentAboveGroundStr);
        }
    }

    public void updateTime() {
        int earnedSeconds = this.config.bonusTime();
        earnedSeconds = (int)((long)earnedSeconds + (long)this.config.timeEarnedPerThreshold() * (this.client.getOverallExperience() / (long)this.config.xpThreshold()));
        this.timeAvailable = (long)earnedSeconds - this.ticksSpentAboveGround;
        this.xpUntilNextThreshold = (long)this.config.xpThreshold() - this.client.getOverallExperience() % (long)this.config.xpThreshold();
    }

    public void evaluateIfMoleMan() {
        boolean isEqual;
        boolean aboveCutoff;
        WorldPoint playerPos = this.client.getLocalPlayer().getWorldLocation();
        if (playerPos == null) {
            return;
        }
        LocalPoint playerPosLocal = LocalPoint.fromWorld((Client)this.client, (WorldPoint)playerPos);
        if (playerPosLocal == null) {
            return;
        }
        if (this.enabled) {
            this.aboveGround = false;
            return;
        }
        if (this.blackListRegionIds.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID())) {
            this.aboveGround = true;
            log.debug("We are manually" + (this.aboveGround ? " above ground." : " below ground."));
            return;
        }
        if (this.whiteListRegionIds.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID())) {
            this.aboveGround = false;
            log.debug("We are manually" + (this.aboveGround ? " above ground." : " below ground."));
            return;
        }
        if (this.tutorialIslandRegionIds.contains(this.client.getLocalPlayer().getWorldLocation().getRegionID())) {
            this.aboveGround = false;
            log.debug("We are manually" + (this.aboveGround ? " above ground." : " below ground."));
            return;
        }
        int cutOff = 4000;
        int currentY = playerPos.getY();
        this.aboveGround = aboveCutoff = cutOff > currentY;
        boolean bl = isEqual = this.aboveGround == this.prevState;
        if (!isEqual) {
            log.debug("We are" + (this.aboveGround ? " above ground." : " below ground."));
        }
        this.prevState = this.aboveGround;
    }

    private void updateWhitelist() {
        this.whiteListRegionIds.clear();
        List text = Text.fromCSV((String)this.config.manualSafeAreas());
        for (String id : text) {
            this.whiteListRegionIds.add(Integer.valueOf(id));
        }
    }

    private void updateBlackList() {
        this.blackListRegionIds.clear();
        List text = Text.fromCSV((String)this.config.manualCountDownAreas());
        for (String id : text) {
            this.blackListRegionIds.add(Integer.valueOf(id));
        }
    }

    private boolean tryParseInt(String intToTry) {
        try {
            Integer.parseInt(intToTry);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public long getTimeAvailable() {
        return this.timeAvailable;
    }

    public long getTicksSpentAboveGround() {
        return this.ticksSpentAboveGround;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public boolean isAboveGround() {
        return this.aboveGround;
    }

    public boolean isFormatTicksAsTime() {
        return this.formatTicksAsTime;
    }

    public boolean isShowRegion() {
        return this.showRegion;
    }

    public boolean isShowAboveGroundState() {
        return this.showAboveGroundState;
    }

    public long getXpUntilNextThreshold() {
        return this.xpUntilNextThreshold;
    }

    public boolean isShowOverlay() {
        return this.showOverlay;
    }
}

