/*
 * Decompiled with CFR 0.152.
 */
package com.zom.molemanmode;

import com.zom.molemanmode.MolemanModeConfig;
import com.zom.molemanmode.MolemanModePlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.time.Duration;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.LineComponent;

class MolemanModeOverlay
extends OverlayPanel {
    private final Client client;
    private final MolemanModePlugin plugin;
    @Inject
    private MolemanModeConfig config;

    @Inject
    private MolemanModeOverlay(Client client, MolemanModePlugin plugin, MolemanModeConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.MED);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isShowOverlay()) {
            return null;
        }
        boolean aboveGround = this.plugin.isAboveGround();
        long timeSpentAbove = this.plugin.getTicksSpentAboveGround();
        long timeAvailable = this.plugin.getTimeAvailable();
        long xpUntilMoreTime = this.plugin.getXpUntilNextThreshold();
        String formattedTimeAbove = this.plugin.isFormatTicksAsTime() ? this.formatTicksAsTime(timeSpentAbove) : this.addCommasToNumber(timeSpentAbove);
        String formattedTimeAvailable = this.plugin.isFormatTicksAsTime() ? this.formatTicksAsTime(timeAvailable) : this.addCommasToNumber(timeAvailable);
        String xpUntilMoreTimeStr = String.valueOf(xpUntilMoreTime);
        this.panelComponent.getChildren().add(LineComponent.builder().left("XP Needed for more time: ").right(xpUntilMoreTimeStr).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left((this.plugin.isFormatTicksAsTime() ? "Time" : "Ticks") + " spent above ground: ").right(formattedTimeAbove).build());
        this.panelComponent.getChildren().add(LineComponent.builder().left((this.plugin.isFormatTicksAsTime() ? "Time" : "Ticks") + " available above ground: ").right(formattedTimeAvailable).rightColor((long)this.plugin.getWarningCount() > timeAvailable ? Color.RED : Color.WHITE).build());
        if (this.plugin.isShowAboveGroundState()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Above ground: ").right(aboveGround ? "Yes" : "No").build());
        }
        if (this.plugin.isShowRegion()) {
            this.panelComponent.getChildren().add(LineComponent.builder().left("Region: ").right(String.valueOf(this.client.getLocalPlayer().getWorldLocation().getRegionID())).build());
        }
        return super.render(graphics);
    }

    private String addCommasToNumber(long number) {
        String input = Long.toString(number);
        StringBuilder output = new StringBuilder();
        for (int x = input.length() - 1; x >= 0; --x) {
            int lastPosition = input.length() - x - 1;
            if (lastPosition != 0 && lastPosition % 3 == 0) {
                output.append(",");
            }
            output.append(input.charAt(x));
        }
        return output.reverse().toString();
    }

    private String formatTicksAsTime(long number) {
        long ticksToTime = (long)((double)number * 0.6);
        Duration duration = Duration.ofSeconds(ticksToTime);
        long seconds = duration.getSeconds();
        long absSeconds = Math.abs(seconds);
        String positive = String.format("%d:%02d:%02d", absSeconds / 3600L, absSeconds % 3600L / 60L, absSeconds % 60L);
        return seconds < 0L ? "-" + positive : positive;
    }
}

