/*
 * Decompiled with CFR 0.152.
 */
package com.coxlightcolors;

import com.coxlightcolors.CoxLightColorsConfig;
import com.coxlightcolors.ItemGroup;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.Point;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.Model;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="CoX Light Colors", description="Set the colors of the light above the loot chest in Chambers of Xeric", tags={"bosses", "combat", "pve", "raid"})
public class CoxLightColorsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CoxLightColorsPlugin.class);
    private static final Set<String> uniques = ImmutableSet.of((Object)"Dexterous prayer scroll", (Object)"Arcane prayer scroll", (Object)"Twisted buckler", (Object)"Dragon hunter crossbow", (Object)"Dinh's bulwark", (Object)"Ancestral hat", (Object[])new String[]{"Ancestral robe top", "Ancestral robe bottom", "Dragon claws", "Elder maul", "Kodai insignia", "Twisted bow"});
    @Inject
    private Client client;
    @Inject
    private CoxLightColorsConfig config;
    private GameObject lightObject;
    private GameObject entranceObject;
    private String uniqueItemReceived;
    private int[] defaultLightFaceColors1;
    private int[] defaultLightFaceColors2;
    private int[] defaultLightFaceColors3;
    private int[] defaultEntranceFaceColors1;
    private int[] defaultEntranceFaceColors2;
    private int[] defaultEntranceFaceColors3;
    private static final Pattern SPECIAL_DROP_MESSAGE = Pattern.compile("(.+) - (.+)");
    private static final int LIGHT_OBJECT_ID = 28848;
    private static final int OLM_ENTRANCE_ID = 29879;
    private static final int VARBIT_LIGHT_TYPE = 5456;
    private static final Point OLM_ENTRANCE_LOCATION = new Point(3233, 5729);
    private static final int OLM_ENTRANCE_REGION_ID = 12889;
    private static Integer currentLightType;

    @Provides
    CoxLightColorsConfig getConfig(ConfigManager configManager) {
        return (CoxLightColorsConfig)configManager.getConfig(CoxLightColorsConfig.class);
    }

    protected void startUp() throws Exception {
        this.updateLightColor();
    }

    protected void shutDown() throws Exception {
        this.resetFaceColors();
        this.uniqueItemReceived = null;
        this.lightObject = null;
        this.entranceObject = null;
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        this.updateLightColor();
        if (!this.isInRaid()) {
            this.resetFaceColors();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getName() == null) {
            return;
        }
        if (chatMessage.getType() == ChatMessageType.FRIENDSCHATNOTIFICATION) {
            String message = Text.removeTags((String)chatMessage.getMessage());
            if (message.contains("your raid is complete!")) {
                this.uniqueItemReceived = null;
                return;
            }
            Matcher matcher = SPECIAL_DROP_MESSAGE.matcher(message);
            if (matcher.find()) {
                String dropReceiver = Text.sanitize((String)matcher.group(1)).trim();
                String dropName = matcher.group(2).trim();
                if (uniques.contains(dropName)) {
                    if (dropReceiver.equals(Text.sanitize((String)this.client.getLocalPlayer().getName()))) {
                        log.debug("Special loot: {} received by {}", (Object)dropName, (Object)dropReceiver);
                        this.uniqueItemReceived = dropName;
                        if (this.lightObject != null) {
                            Color newLightColor = this.getUniqueGroupColor(dropName);
                            log.info("Light object not null when special loot received by local player. Recoloring light based on unique group: {}", (Object)String.format("#%06x", newLightColor.getRGB() & 0xFFFFFF));
                            this.recolorAllFaces(this.lightObject.getRenderable().getModel(), newLightColor, true);
                        } else {
                            log.debug("Light object null after local player received drop");
                        }
                    } else {
                        log.debug("Drop received by non-local player: {}, player: {}", (Object)dropName, (Object)dropReceiver);
                    }
                }
            }
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject obj = event.getGameObject();
        if (28848 == obj.getId()) {
            log.info("Light gameObject spawned");
            this.lightObject = obj;
            this.updateLightColor();
        } else if (29879 == obj.getId() && this.isAtOlmEntranceLocation(obj)) {
            this.entranceObject = obj;
            if (this.config.enableEntrance()) {
                this.recolorAllFaces(obj.getRenderable().getModel(), this.config.olmEntrance(), false);
            }
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        if (28848 == event.getGameObject().getId()) {
            log.info("Light gameObject despawned");
            this.lightObject = null;
        } else if (29879 == event.getGameObject().getId()) {
            this.entranceObject = null;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("coxlightcolors")) {
            return;
        }
        this.resetFaceColors();
        if (this.lightObject != null) {
            this.recolorAllFaces(this.lightObject.getRenderable().getModel(), this.uniqueItemReceived != null ? this.getUniqueGroupColor(this.uniqueItemReceived) : this.getNewLightColor(), true);
        }
        if (this.entranceObject != null && this.isAtOlmEntranceLocation(this.entranceObject) && this.config.enableEntrance()) {
            this.recolorAllFaces(this.entranceObject.getRenderable().getModel(), this.config.olmEntrance(), false);
        }
    }

    private void updateLightColor() {
        if (this.lightObject != null) {
            currentLightType = this.client.getVarbitValue(5456);
            this.recolorAllFaces(this.lightObject.getRenderable().getModel(), this.uniqueItemReceived != null ? this.getUniqueGroupColor(this.uniqueItemReceived) : this.getNewLightColor(), true);
        }
    }

    private Color getUniqueGroupColor(String uniqueName) {
        if (StringUtils.isBlank((CharSequence)uniqueName)) {
            if (!StringUtils.isBlank((CharSequence)this.uniqueItemReceived)) {
                uniqueName = this.uniqueItemReceived;
            } else {
                log.info("getUniqueGroupColor() called with {} unique string", (Object)(null == uniqueName ? "null" : "empty"));
                return this.getNewLightColor();
            }
        }
        switch (uniqueName.toLowerCase().trim()) {
            case "twisted bow": {
                return this.getGroupColor(this.config.groupTwistedBow());
            }
            case "kodai insignia": {
                return this.getGroupColor(this.config.groupKodai());
            }
            case "elder maul": {
                return this.getGroupColor(this.config.groupElderMaul());
            }
            case "dragon claws": {
                return this.getGroupColor(this.config.groupClaws());
            }
            case "ancestral hat": {
                return this.getGroupColor(this.config.groupAncestralHat());
            }
            case "ancestral robe top": {
                return this.getGroupColor(this.config.groupAncestralTop());
            }
            case "ancestral robe bottom": {
                return this.getGroupColor(this.config.groupAncestralBottom());
            }
            case "dinh's bulwark": {
                return this.getGroupColor(this.config.groupDinhs());
            }
            case "dragon hunter crossbow": {
                return this.getGroupColor(this.config.groupDHCB());
            }
            case "twisted buckler": {
                return this.getGroupColor(this.config.groupBuckler());
            }
            case "arcane prayer scroll": {
                return this.getGroupColor(this.config.groupArcane());
            }
            case "dexterous prayer scroll": {
                return this.getGroupColor(this.config.groupDex());
            }
        }
        log.info("Unique received did not match a known item from CoX: {}", (Object)uniqueName);
        return this.getNewLightColor();
    }

    private Color getGroupColor(ItemGroup group) {
        switch (group) {
            case ONE: {
                return this.config.enableGroupOne() ? this.config.groupOneColor() : this.getNewLightColor();
            }
            case TWO: {
                return this.config.enableGroupTwo() ? this.config.groupTwoColor() : this.getNewLightColor();
            }
            case THREE: {
                return this.config.enableGroupThree() ? this.config.groupThreeColor() : this.getNewLightColor();
            }
        }
        return this.getNewLightColor();
    }

    private Color getNewLightColor() {
        if (currentLightType == null) {
            return null;
        }
        switch (currentLightType) {
            case 1: {
                return this.config.enableStandardLoot() ? this.config.standardLoot() : null;
            }
            case 2: {
                return this.config.enableUnique() ? this.config.unique() : null;
            }
            case 3: {
                return this.config.enableDust() ? this.config.dust() : null;
            }
            case 4: {
                return this.config.enableKit() ? this.config.twistedKit() : null;
            }
        }
        return null;
    }

    private void recolorAllFaces(Model model, Color color, boolean isLight) {
        if (model == null || color == null) {
            return;
        }
        int rs2hsb = this.colorToRs2hsb(color);
        int[] faceColors1 = model.getFaceColors1();
        int[] faceColors2 = model.getFaceColors2();
        int[] faceColors3 = model.getFaceColors3();
        if (isLight && (this.defaultLightFaceColors1 == null || this.defaultLightFaceColors1.length == 0)) {
            this.defaultLightFaceColors1 = (int[])faceColors1.clone();
            this.defaultLightFaceColors2 = (int[])faceColors2.clone();
            this.defaultLightFaceColors3 = (int[])faceColors3.clone();
        } else if (this.defaultEntranceFaceColors1 == null || this.defaultEntranceFaceColors1.length == 0) {
            this.defaultEntranceFaceColors1 = (int[])faceColors1.clone();
            this.defaultEntranceFaceColors2 = (int[])faceColors2.clone();
            this.defaultEntranceFaceColors3 = (int[])faceColors3.clone();
        }
        if (isLight && !StringUtils.isBlank((CharSequence)this.uniqueItemReceived) && color != this.getUniqueGroupColor(this.uniqueItemReceived)) {
            color = this.getUniqueGroupColor(this.uniqueItemReceived);
            rs2hsb = this.colorToRs2hsb(color);
        }
        log.debug("Calling replaceFaceColorValues with color: {}, on {}", (Object)String.format("#%06x", color.getRGB() & 0xFFFFFF), (Object)(isLight ? "light" : "entrance"));
        this.replaceFaceColorValues(faceColors1, faceColors2, faceColors3, rs2hsb);
    }

    private boolean isInRaid() {
        return this.client.getGameState() == GameState.LOGGED_IN && this.client.getVar(5432) == 1;
    }

    private int colorToRs2hsb(Color color) {
        float[] hsbVals = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        hsbVals[2] = hsbVals[2] - Math.min(hsbVals[1], hsbVals[2] / 2.0f);
        int encode_hue = (int)(hsbVals[0] * 63.0f);
        int encode_saturation = (int)(hsbVals[1] * 7.0f);
        int encode_brightness = (int)(hsbVals[2] * 127.0f);
        return (encode_hue << 10) + (encode_saturation << 7) + encode_brightness;
    }

    private void resetFaceColors() {
        Model model;
        if (this.lightObject != null && this.lightObject.getRenderable().getModel() != null && this.defaultLightFaceColors1 != null && this.defaultLightFaceColors2 != null && this.defaultLightFaceColors3 != null) {
            model = this.lightObject.getRenderable().getModel();
            this.replaceFaceColorValues(model.getFaceColors1(), model.getFaceColors2(), model.getFaceColors3(), this.defaultLightFaceColors1, this.defaultLightFaceColors2, this.defaultLightFaceColors3);
            this.defaultLightFaceColors1 = null;
            this.defaultLightFaceColors2 = null;
            this.defaultLightFaceColors3 = null;
        }
        if (this.entranceObject != null && this.entranceObject.getRenderable().getModel() != null && this.defaultEntranceFaceColors1 != null && this.defaultEntranceFaceColors2 != null && this.defaultEntranceFaceColors3 != null) {
            model = this.entranceObject.getRenderable().getModel();
            this.replaceFaceColorValues(model.getFaceColors1(), model.getFaceColors2(), model.getFaceColors3(), this.defaultEntranceFaceColors1, this.defaultEntranceFaceColors2, this.defaultEntranceFaceColors3);
            this.defaultEntranceFaceColors1 = null;
            this.defaultEntranceFaceColors2 = null;
            this.defaultEntranceFaceColors3 = null;
        }
    }

    private void replaceFaceColorValues(int[] faceColors1, int[] faceColors2, int[] faceColors3, int[] newFaceColors1, int[] newFaceColors2, int[] newFaceColors3) {
        if (faceColors1.length == newFaceColors1.length && faceColors2.length == newFaceColors2.length && faceColors3.length == newFaceColors3.length) {
            System.arraycopy(newFaceColors1, 0, faceColors1, 0, faceColors1.length);
            System.arraycopy(newFaceColors2, 0, faceColors2, 0, faceColors1.length);
            System.arraycopy(newFaceColors3, 0, faceColors3, 0, faceColors1.length);
        }
    }

    private void replaceFaceColorValues(int[] faceColors1, int[] faceColors2, int[] faceColors3, int globalReplacement) {
        int i;
        if (faceColors1.length > 0) {
            for (i = 0; i < faceColors1.length; ++i) {
                faceColors1[i] = globalReplacement;
            }
        }
        if (faceColors2.length > 0) {
            for (i = 0; i < faceColors2.length; ++i) {
                faceColors2[i] = globalReplacement;
            }
        }
        if (faceColors3.length > 0) {
            for (i = 0; i < faceColors3.length; ++i) {
                faceColors3[i] = globalReplacement;
            }
        }
    }

    private boolean isAtOlmEntranceLocation(GameObject obj) {
        WorldPoint p = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)obj.getLocalLocation());
        return 12889 == p.getRegionID() && OLM_ENTRANCE_LOCATION.getX() == (double)p.getX() && OLM_ENTRANCE_LOCATION.getY() == (double)p.getY();
    }
}

