/*
 * Decompiled with CFR 0.152.
 */
package com.coxlightcolors;

import com.coxlightcolors.ItemGroup;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="coxlightcolors")
public interface CoxLightColorsConfig
extends Config {
    @ConfigSection(name="Light colors", description="Colors of the lights above the loot chest for different scenarios", position=0)
    public static final String colorsSection = "colors";
    @ConfigSection(name="Groups", description="Uniques that, when obtained, will use the 'Specific Unique' color for the light", position=1)
    public static final String uniquesSection = "uniques";
    @ConfigSection(name="Toggles", description="Toggle different recolors on or off", position=2, closedByDefault=true)
    public static final String togglesSection = "toggles";

    @ConfigItem(keyName="standardLoot", name="Standard loot", description="Color of light when no unique item is obtained", position=0, section="colors")
    default public Color standardLoot() {
        return Color.WHITE;
    }

    @ConfigItem(keyName="enableStandardLoot", name="Recolor standard loot", description="Enable recoloring the light of the chest when no unique is obtained", position=1, section="toggles")
    default public boolean enableStandardLoot() {
        return true;
    }

    @ConfigItem(keyName="unique", name="Unique", description="Color of light when a unique item is obtained (besides twisted kit or dust)", position=2, section="colors")
    default public Color unique() {
        return Color.decode("#F155F5");
    }

    @ConfigItem(keyName="enableUnique", name="Recolor uniques", description="Enable recoloring the light of the chest when a unique is obtained", position=3, section="toggles")
    default public boolean enableUnique() {
        return true;
    }

    @ConfigItem(keyName="dust", name="Metamorphic Dust", description="Color of light when metamorphic dust is obtained", position=4, section="colors")
    default public Color dust() {
        return Color.CYAN;
    }

    @ConfigItem(keyName="enableDust", name="Recolor dust", description="Enable recoloring the light of the chest when metamorphic dust is obtained", position=5, section="toggles")
    default public boolean enableDust() {
        return true;
    }

    @ConfigItem(keyName="twistedKit", name="Twisted Kit", description="Color of light when a twisted kit is obtained", position=6, section="colors")
    default public Color twistedKit() {
        return Color.GREEN;
    }

    @ConfigItem(keyName="enableKit", name="Recolor Twisted kit", description="Enable recoloring the light of the chest when a twisted kit is obtained", position=7, section="toggles")
    default public boolean enableKit() {
        return true;
    }

    @ConfigItem(keyName="olmEntrance", name="Olm Entrance", description="Color of the barrier used to enter the Olm room", position=8, section="colors")
    default public Color olmEntrance() {
        return Color.decode("#8CFF0B");
    }

    @ConfigItem(keyName="enableEntrance", name="Recolor entance", description="Enable recoloring the entrance barrier to Olm", position=9, section="toggles")
    default public boolean enableEntrance() {
        return true;
    }

    @ConfigItem(keyName="groupOneColor", name="Group 1", description="Color of the light when an item from group 1 is obtained", position=0, section="uniques")
    default public Color groupOneColor() {
        return Color.RED;
    }

    @ConfigItem(keyName="groupTwoColor", name="Group 2", description="Color of the light when an item from group 2 is obtained", position=1, section="uniques")
    default public Color groupTwoColor() {
        return Color.BLUE;
    }

    @ConfigItem(keyName="groupThreeColor", name="Group 3", description="Color of the light when an item from group 3 is obtained", position=2, section="uniques")
    default public Color groupThreeColor() {
        return Color.YELLOW;
    }

    @ConfigItem(keyName="groupTwistedBow", name="Twisted bow", description="Group color to use when this item is obtained. If no group is specified, the 'unique' color will be used", position=3, section="uniques")
    default public ItemGroup groupTwistedBow() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupKodai", name="Kodai insignia", description="Group color to use when this item is obtained. If no group is specified, the 'unique' color will be used", position=4, section="uniques")
    default public ItemGroup groupKodai() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupElderMaul", name="Elder maul", description="Group color to use when this item is obtained. If no group is specified, the 'unique' color will be used", position=5, section="uniques")
    default public ItemGroup groupElderMaul() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupClaws", name="Dragon claws", description="Group color to use when this item is obtained. If no group is specified, the 'unique' color will be used", position=6, section="uniques")
    default public ItemGroup groupClaws() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupAncestralHat", name="Ancestral hat", description="Group color to use when this item is obtained. If no group is specified, the 'unique' color will be used", position=7, section="uniques")
    default public ItemGroup groupAncestralHat() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupAncestralTop", name="Ancestral robe top", description="Group color to use when this item is obtained. If no group is specified, the 'unique' color will be used", position=8, section="uniques")
    default public ItemGroup groupAncestralTop() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupAncestralBottom", name="Ancestral robe bottom", description="Group color to use when this item is obtained. If no group is specified, the 'unique' color will be used", position=9, section="uniques")
    default public ItemGroup groupAncestralBottom() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupDinhs", name="Dinh's bulwark", description="Group color to use when this item is obtained. If no group is specified, the 'unique' color will be used", position=10, section="uniques")
    default public ItemGroup groupDinhs() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupDHCB", name="Dragon hunter crossbow", description="Group color to use when this item is obtained. If no group is specified, the 'unique' color will be used", position=11, section="uniques")
    default public ItemGroup groupDHCB() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupBuckler", name="Twisted buckler", description="Group color to use when this item is obtained. If no group is specified, the 'unique' color will be used", position=12, section="uniques")
    default public ItemGroup groupBuckler() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupArcane", name="Arcane prayer scroll", description="Group color to use when this item is obtained. If no group is specified, the 'unique' color will be used", position=13, section="uniques")
    default public ItemGroup groupArcane() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="groupDex", name="Dexterous prayer scroll", description="Group color to use when this item is obtained. If no group is specified, the 'unique' color will be used", position=14, section="uniques")
    default public ItemGroup groupDex() {
        return ItemGroup.NONE;
    }

    @ConfigItem(keyName="enableGroupOne", name="Recolor group 1", description="Enable recoloring the light of the chest when a unique from group 1 is obtained", position=15, section="uniques")
    default public boolean enableGroupOne() {
        return true;
    }

    @ConfigItem(keyName="enableGroupTwo", name="Recolor group 2", description="Enable recoloring the light of the chest when a unique from group 2 is obtained", position=16, section="uniques")
    default public boolean enableGroupTwo() {
        return true;
    }

    @ConfigItem(keyName="enableGroupThree", name="Recolor group 3", description="Enable recoloring the light of the chest when a unique from group 3 is obtained", position=17, section="uniques")
    default public boolean enableGroupThree() {
        return true;
    }
}

