/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats;

import com.google.inject.Provides;
import com.infernostats.GodbookAnimationID;
import com.infernostats.GodbookConfig;
import com.infernostats.GodbookOverlay;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Godbook")
public class GodbookPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GodbookPlugin.class);
    private LinkedHashMap<String, Integer> players;
    @Inject
    private Client client;
    @Inject
    private GodbookOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private GodbookConfig config;

    @Provides
    GodbookConfig provideConfig(ConfigManager configManager) {
        return (GodbookConfig)configManager.getConfig(GodbookConfig.class);
    }

    protected void startUp() throws Exception {
        this.players = new LinkedHashMap();
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.players.clear();
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (this.config.theatreOnly() && !this.isInTheatreOfBlood()) {
            return;
        }
        if (GodbookAnimationID.isGodbookAnimation(event.getActor().getAnimation())) {
            this.players.put(event.getActor().getName(), 0);
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.players.isEmpty()) {
            return;
        }
        this.players.entrySet().forEach(i -> i.setValue((Integer)i.getValue() + 1));
        this.players.entrySet().removeIf(i -> (Integer)i.getValue() >= this.config.maxTicks());
    }

    private boolean isInTheatreOfBlood() {
        return this.client.getVar(6440) != 0;
    }

    LinkedHashMap<String, Integer> getPlayers() {
        return this.players;
    }
}

