/*
 * Decompiled with CFR 0.152.
 */
package com.infernostats;

import com.infernostats.GodbookPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

class GodbookOverlay
extends Overlay {
    private final GodbookPlugin plugin;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    private GodbookOverlay(GodbookPlugin plugin) {
        this.plugin = plugin;
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
    }

    public Dimension render(Graphics2D graphics) {
        String title = "Tick:";
        LinkedHashMap<String, Integer> players = this.plugin.getPlayers();
        this.panelComponent.getChildren().clear();
        if (!players.isEmpty()) {
            this.panelComponent.setPreferredSize(new Dimension(this.getMaxWidth(graphics, players, title) + 10, 0));
            this.panelComponent.getChildren().add(TitleComponent.builder().text(title).color(Color.green).build());
            ((HashMap)players).forEach(this::addPlayerToOverlay);
        }
        return this.panelComponent.render(graphics);
    }

    private int getMaxWidth(Graphics2D graphics, HashMap<String, Integer> players, String title) {
        String longestKey = Collections.max(players.keySet(), Comparator.comparingInt(String::length));
        return graphics.getFontMetrics().stringWidth(longestKey) + graphics.getFontMetrics().stringWidth(title);
    }

    private void addPlayerToOverlay(String playerName, Integer ticks) {
        this.panelComponent.getChildren().add(LineComponent.builder().left(playerName).right(Integer.toString(ticks)).build());
    }
}

