/*
 * Decompiled with CFR 0.152.
 */
package com.damagetakenlogger;

import com.damagetakenlogger.DamageTakenLoggerConfig;
import com.google.inject.Provides;
import java.awt.Color;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.events.ActorDeath;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.InteractingChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Damage Taken Logger", description="Displays damage taken in chat, as well as total XP gained per kill.")
public class DamageTakenLoggerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DamageTakenLoggerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private DamageTakenLoggerConfig config;
    @Nullable
    private static Actor combatActor;
    private static int combatBeginXp;
    private static Instant combatTimer;

    @Provides
    DamageTakenLoggerConfig provideConfig(ConfigManager configManager) {
        return (DamageTakenLoggerConfig)configManager.getConfig(DamageTakenLoggerConfig.class);
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied damage) {
        if (damage.getActor() != this.client.getLocalPlayer()) {
            return;
        }
        int amount = damage.getHitsplat().getAmount();
        if (amount <= 0) {
            return;
        }
        if (this.config.showDamageTaken()) {
            String message = ColorUtil.wrapWithColorTag((String)String.format("You were hit for %d!", amount), (Color)this.config.damageTakenColor());
            this.addGameMessage(message);
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged interact) {
        if (interact.getSource() != this.client.getLocalPlayer()) {
            return;
        }
        Actor target = interact.getTarget();
        if (target == null) {
            return;
        }
        if (combatActor != null && Objects.equals(combatActor.getName(), target.getName())) {
            log.debug("Attacking similar target, no new combat started.");
            return;
        }
        log.debug(String.format("Combat begins with '%s'", target.getName()));
        combatTimer = Instant.now();
        combatBeginXp = this.calculateTotalCombatXp();
        combatActor = target;
    }

    @Subscribe
    public void onActorDeath(ActorDeath ev) {
        if (ev.getActor() != combatActor) {
            return;
        }
        int combatXpGained = this.calculateGainedCombatXp();
        log.debug(String.format("Combat finished with '%s' for %d XP", ev.getActor().getName(), combatXpGained));
        if (this.config.showExperienceGained()) {
            String xpStyle = this.getXpOutputStyle(combatXpGained);
            String message = ColorUtil.wrapWithColorTag((String)String.format("You gained %s!", xpStyle), (Color)this.config.experienceGainedColor());
            this.addGameMessage(message);
        }
        combatActor = null;
    }

    private void addGameMessage(String message) {
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, null);
    }

    private int calculateTotalCombatXp() {
        int[] combatSkills = new int[]{this.client.getSkillExperience(Skill.ATTACK), this.client.getSkillExperience(Skill.DEFENCE), this.client.getSkillExperience(Skill.HITPOINTS), this.client.getSkillExperience(Skill.MAGIC), this.client.getSkillExperience(Skill.PRAYER), this.client.getSkillExperience(Skill.RANGED), this.client.getSkillExperience(Skill.STRENGTH)};
        return Arrays.stream(combatSkills).sum();
    }

    private int calculateGainedCombatXp() {
        float combatXpGained = this.calculateTotalCombatXp() - combatBeginXp;
        Duration combatDuration = Duration.between(combatTimer, Instant.now());
        switch (this.config.ExperienceGainedAmountStyle()) {
            case PER_SECOND: {
                return (int)(combatXpGained / (float)combatDuration.getSeconds());
            }
        }
        return (int)combatXpGained;
    }

    private String getXpOutputStyle(int combatXpGained) {
        switch (this.config.ExperienceGainedAmountStyle()) {
            case PER_SECOND: {
                return String.format("%d XP/s", combatXpGained);
            }
        }
        return String.format("%d XP", combatXpGained);
    }
}

