/*
 * Decompiled with CFR 0.152.
 */
package cropcircletracker;

import cropcircletracker.CropCircleTrackerPlugin;
import java.util.EnumSet;
import net.runelite.api.GameState;
import net.runelite.api.World;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.util.WorldUtil;

public class WorldHopper {
    private CropCircleTrackerPlugin plugin;
    private World targetWorld;
    private static final int DISPLAY_SWITCHER_MAX_ATTEMPTS = 3;
    private int displaySwitcherAttempts = 0;

    WorldHopper(CropCircleTrackerPlugin plugin) {
        this.plugin = plugin;
    }

    public void scheduleHop(int worldID) {
        this.plugin.clientThread.invoke(() -> {
            net.runelite.http.api.worlds.World world = this.plugin.worldMapping.get(worldID);
            if (world == null) {
                return;
            }
            World rsWorld = this.plugin.client.createWorld();
            rsWorld.setActivity(world.getActivity());
            rsWorld.setAddress(world.getAddress());
            rsWorld.setId(world.getId());
            rsWorld.setPlayerCount(world.getPlayers());
            rsWorld.setLocation(world.getLocation());
            rsWorld.setTypes(WorldUtil.toWorldTypes((EnumSet)world.getTypes()));
            if (this.plugin.client.getGameState() == GameState.LOGIN_SCREEN) {
                this.plugin.client.changeWorld(rsWorld);
                return;
            }
            this.targetWorld = rsWorld;
        });
    }

    public void handleHop() {
        if (this.targetWorld == null) {
            return;
        }
        if (this.plugin.client.getWidget(WidgetInfo.WORLD_SWITCHER_LIST) == null) {
            this.plugin.client.openWorldHopper();
            if (++this.displaySwitcherAttempts >= 3) {
                this.reset();
            }
        } else {
            this.plugin.client.hopToWorld(this.targetWorld);
            this.reset();
        }
    }

    private void reset() {
        this.targetWorld = null;
        this.displaySwitcherAttempts = 0;
    }
}

