/*
 * Decompiled with CFR 0.152.
 */
package cropcircletracker;

import cropcircletracker.CropCircleTrackerPlugin;
import cropcircletracker.EntryRow;
import cropcircletracker.HeadingRow;
import cropcircletracker.MessageRow;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JPanel;
import net.runelite.client.ui.ColorScheme;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldType;

public class Table
extends JPanel {
    private static final Color HEADING_COLOR = ColorScheme.SCROLL_TRACK_COLOR;
    private static final Color ROW_COLOR_1 = ColorScheme.DARK_GRAY_COLOR;
    private static final Color ROW_COLOR_2 = new Color(44, 44, 44);
    private static final List<WorldType> worldTypesToDisplay = Arrays.asList(WorldType.BOUNTY, WorldType.HIGH_RISK, WorldType.LAST_MAN_STANDING, WorldType.MEMBERS, WorldType.PVP, WorldType.SKILL_TOTAL);
    private final CropCircleTrackerPlugin plugin;

    public Table(CropCircleTrackerPlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new GridLayout(0, 1));
    }

    private void addHeadingRow() {
        this.add(new HeadingRow("World", "Likelihood", "World Type", HEADING_COLOR));
    }

    private void addMessageRow(String message) {
        this.add(new MessageRow(message, ROW_COLOR_1));
    }

    private void addEntryRow(int world, double likelihood, Color rowColor) {
        this.add(new EntryRow(world, likelihood, rowColor, this.plugin));
    }

    public void update(List<List<Object>> worldLikelihoodPairs) {
        this.removeAll();
        this.addHeadingRow();
        Collections.sort(worldLikelihoodPairs, (a, b) -> {
            double likelihoodB;
            double likelihoodA = (Double)a.get(1);
            return likelihoodA < (likelihoodB = ((Double)b.get(1)).doubleValue()) ? 1 : -1;
        });
        AtomicInteger rowIndex = new AtomicInteger();
        if (worldLikelihoodPairs.size() > 0) {
            for (List<Object> pair : worldLikelihoodPairs) {
                double likelihood;
                int world = Integer.parseInt((String)pair.get(0));
                if (!this.shouldDisplay(world, likelihood = ((Double)pair.get(1)).doubleValue())) continue;
                Color rowColor = rowIndex.get() % 2 == 0 ? ROW_COLOR_1 : ROW_COLOR_2;
                rowIndex.getAndIncrement();
                this.addEntryRow(world, likelihood, rowColor);
            }
        } else {
            this.addMessageRow("No known crop circles");
        }
        this.revalidate();
        this.repaint();
    }

    public void clear() {
        this.removeAll();
        this.addMessageRow("Loading...");
        this.revalidate();
        this.repaint();
    }

    public void displayError(String errorMessage) {
        this.removeAll();
        this.addMessageRow(errorMessage);
        this.revalidate();
        this.repaint();
    }

    public void displayErrors(List<String> errorMessages) {
        this.removeAll();
        for (String errorMessage : errorMessages) {
            this.addMessageRow(errorMessage);
        }
        this.revalidate();
        this.repaint();
    }

    private boolean shouldDisplay(int worldID, double likelihood) {
        if (likelihood < (double)this.plugin.config.minimumLikelihood() / 100.0) {
            return false;
        }
        World world = this.plugin.worldMapping.get(worldID);
        if (world == null) {
            return false;
        }
        EnumSet worldTypes = world.getTypes();
        for (WorldType worldType : worldTypes) {
            if (worldTypesToDisplay.contains(worldType)) continue;
            return false;
        }
        if (worldTypes.contains(WorldType.PVP) && !this.plugin.config.showPVPWorlds()) {
            return false;
        }
        if (worldTypes.contains(WorldType.HIGH_RISK) && !this.plugin.config.showHighRiskWorlds()) {
            return false;
        }
        if (worldTypes.contains(WorldType.SKILL_TOTAL)) {
            switch (world.getActivity()) {
                case "1250 skill total": {
                    if (this.plugin.config.show1250TotalWorlds()) break;
                    return false;
                }
                case "1500 skill total": {
                    if (this.plugin.config.show1500TotalWorlds()) break;
                    return false;
                }
                case "1750 skill total": {
                    if (this.plugin.config.show1750TotalWorlds()) break;
                    return false;
                }
                case "2000 skill total": {
                    if (this.plugin.config.show2000TotalWorlds()) break;
                    return false;
                }
                case "2200 skill total": {
                    if (this.plugin.config.show2200TotalWorlds()) break;
                    return false;
                }
            }
        }
        return true;
    }
}

