/*
 * Decompiled with CFR 0.152.
 */
package cropcircletracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.FontManager;

class HeadingRow
extends JPanel {
    private static final int COLUMN_1_WIDTH = 50;
    private static final int COLUMN_2_WIDTH = 50;
    private static final int COLUMN_3_WIDTH = 100;
    private static final int COLUMN_HEIGHT = 24;

    HeadingRow(String column1, String column2, String column3, Color backgroundColor) {
        this.setLayout(new GridBagLayout());
        this.addLabel(column1, 50);
        this.addLabel(column2, 50);
        this.addLabel(column3, 100);
        if (backgroundColor != null) {
            this.setBackground(backgroundColor);
        }
    }

    private void addLabel(String text, int width) {
        JLabel label = new JLabel(text);
        label.setFont(FontManager.getRunescapeFont());
        label.setPreferredSize(new Dimension(width, 24));
        label.setMaximumSize(new Dimension(width, 24));
        label.setMinimumSize(new Dimension(width, 24));
        label.setHorizontalAlignment(0);
        this.add((Component)label, this.constraints(1, 1));
    }

    private GridBagConstraints constraints(int weightX, int fill) {
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = weightX;
        c.fill = fill;
        return c;
    }
}

