/*
 * Decompiled with CFR 0.152.
 */
package cropcircletracker;

import cropcircletracker.CropCircleTrackerPlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.runelite.client.ui.FontManager;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldType;

class EntryRow
extends JPanel {
    private static final int COLUMN_1_WIDTH = 50;
    private static final int COLUMN_2_WIDTH = 50;
    private static final int COLUMN_3_WIDTH = 100;
    private static final int COLUMN_HEIGHT = 24;
    private static final Color CURRENT_WORLD_COLOR = new Color(0, 255, 0);
    private static final Color LIKELIHOOD_COLOR_1 = new Color(0, 255, 0);
    private static final Color LIKELIHOOD_COLOR_2 = new Color(128, 255, 0);
    private static final Color LIKELIHOOD_COLOR_3 = new Color(255, 255, 0);
    private static final Color LIKELIHOOD_COLOR_4 = new Color(255, 128, 0);
    private static final Color LIKELIHOOD_COLOR_5 = new Color(255, 0, 0);
    private static final Color DANGEROUS_WORLD_TYPE_COLOR = new Color(255, 0, 0);
    private static final List<WorldType> dangerousWorldTypes = Arrays.asList(WorldType.BOUNTY, WorldType.HIGH_RISK, WorldType.PVP);
    private final CropCircleTrackerPlugin plugin;
    private Color lastBackground;

    EntryRow(final int world, double likelihood, Color backgroundColor, final CropCircleTrackerPlugin plugin) {
        this.plugin = plugin;
        this.setLayout(new GridBagLayout());
        this.addLabel(String.valueOf(world), this.getWorldColor(world), 50);
        this.addLabel(this.getLikelihoodString(likelihood), this.getLikelihoodColor(likelihood), 50);
        this.addLabel(this.getWorldTypeString(world), this.getWorldTypeColor(world), 100);
        if (backgroundColor != null) {
            this.setBackground(backgroundColor);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    plugin.worldHopper.scheduleHop(world);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                EntryRow.this.lastBackground = EntryRow.this.getBackground();
                EntryRow.this.setBackground(EntryRow.this.getBackground().brighter());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                EntryRow.this.setBackground(EntryRow.this.lastBackground);
            }
        });
    }

    private String getLikelihoodString(double likelihood) {
        if (likelihood >= 0.945) {
            return "95%+";
        }
        if (likelihood <= 0.01) {
            return "1%";
        }
        return Math.round(likelihood * 100.0) + "%";
    }

    private String getWorldTypeString(int worldID) {
        World world = this.plugin.worldMapping.get(worldID);
        EnumSet worldTypes = world.getTypes();
        if (worldTypes.contains(WorldType.PVP) && worldTypes.contains(WorldType.HIGH_RISK)) {
            return "PvP - High Risk";
        }
        if (worldTypes.contains(WorldType.PVP)) {
            return "PvP";
        }
        if (worldTypes.contains(WorldType.HIGH_RISK)) {
            return "High Risk";
        }
        if (worldTypes.contains(WorldType.BOUNTY)) {
            return "Target World";
        }
        if (worldTypes.contains(WorldType.SKILL_TOTAL)) {
            return world.getActivity();
        }
        return "-";
    }

    private Color getWorldColor(int worldID) {
        if (worldID == this.plugin.client.getWorld()) {
            return CURRENT_WORLD_COLOR;
        }
        return null;
    }

    private Color getLikelihoodColor(double likelihood) {
        if (likelihood >= 0.8) {
            return LIKELIHOOD_COLOR_1;
        }
        if (likelihood >= 0.6) {
            return LIKELIHOOD_COLOR_2;
        }
        if (likelihood >= 0.4) {
            return LIKELIHOOD_COLOR_3;
        }
        if (likelihood >= 0.2) {
            return LIKELIHOOD_COLOR_4;
        }
        return LIKELIHOOD_COLOR_5;
    }

    private Color getWorldTypeColor(int worldID) {
        World world = this.plugin.worldMapping.get(worldID);
        EnumSet worldTypes = world.getTypes();
        for (WorldType dangerousWorldType : dangerousWorldTypes) {
            if (!worldTypes.contains(dangerousWorldType)) continue;
            return DANGEROUS_WORLD_TYPE_COLOR;
        }
        return null;
    }

    private void addLabel(String text, Color textColor, int width) {
        JLabel label = new JLabel(text);
        label.setFont(FontManager.getRunescapeFont());
        if (textColor != null) {
            label.setForeground(textColor);
        }
        label.setPreferredSize(new Dimension(width, 24));
        label.setMinimumSize(new Dimension(width, 24));
        label.setMaximumSize(new Dimension(width, 24));
        label.setHorizontalAlignment(0);
        this.add((Component)label, this.constraints(1, 1));
    }

    private GridBagConstraints constraints(int weightX, int fill) {
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = weightX;
        c.fill = fill;
        return c;
    }
}

