/*
 * Decompiled with CFR 0.152.
 */
package cropcircletracker;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.inject.Provides;
import cropcircletracker.CropCircle;
import cropcircletracker.CropCircleTrackerConfig;
import cropcircletracker.CropCircleTrackerPanel;
import cropcircletracker.WorldHopper;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.WorldChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldResult;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Crop Circle Tracker")
public class CropCircleTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CropCircleTrackerPlugin.class);
    private static final int CROP_CIRCLE_OBJECT = 24988;
    private static final int GET_LIKELIHOODS_PERIOD_SECONDS = 10;
    private static final int CROP_CIRCLE_RECHECK_PERIOD_SECONDS = 10;
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final Map<WorldPoint, CropCircle> MAPPING = CropCircle.mapping();
    @Inject
    public CropCircleTrackerConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    public Client client;
    @Inject
    public ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private WorldService worldService;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private Gson gson;
    public Map<Integer, World> worldMapping = new HashMap<Integer, World>();
    public WorldHopper worldHopper = new WorldHopper(this);
    private NavigationButton navButton = null;
    private CropCircleTrackerPanel panel;
    private CropCircle lastCropCircle = null;
    private int currentWorld = -1;

    @Provides
    CropCircleTrackerConfig getConfig(ConfigManager configManager) {
        return (CropCircleTrackerConfig)configManager.getConfig(CropCircleTrackerConfig.class);
    }

    protected void startUp() throws Exception {
        this.panel = (CropCircleTrackerPanel)((Object)this.injector.getInstance(CropCircleTrackerPanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/icon.png");
        this.navButton = NavigationButton.builder().tooltip("Crop Circle Tracker").icon(icon).priority(7).panel((PluginPanel)this.panel).build();
        if (!this.config.hideToolbarButton()) {
            this.clientToolbar.addNavigation(this.navButton);
        }
        this.setWorldMapping();
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("cropcircletracker") && event.getKey().equals("hideToolbarButton")) {
            if (this.config.hideToolbarButton()) {
                this.clientToolbar.removeNavigation(this.navButton);
            } else {
                this.clientToolbar.addNavigation(this.navButton);
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN) {
            this.lastCropCircle = null;
            this.currentWorld = this.client.getWorld();
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        this.worldHopper.handleHop();
    }

    @Schedule(period=10L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void getLikelihoods() {
        if (this.panel.open) {
            this.makeRequest("GET", this.config.getEndpoint(), null, (call, response) -> {
                try {
                    JsonObject likelihoods = (JsonObject)this.gson.fromJson(response.body().string(), JsonObject.class);
                    SwingUtilities.invokeLater(() -> {
                        this.panel.likelihoods = likelihoods;
                        this.panel.updateTable();
                    });
                }
                catch (JsonSyntaxException | IOException e) {
                    log.error("GET failed: {}", (Object)e.getMessage());
                }
            }, (call, response) -> {
                if (response.code() == 401) {
                    SwingUtilities.invokeLater(() -> this.panel.displayError("Server authentication error"));
                } else if (response.code() == 503) {
                    SwingUtilities.invokeLater(() -> this.panel.displayErrors(Arrays.asList("Server temporarily unavailable.", "The server goes offline every Wednesday", "between 11:00 and 12:00 UK time to match", "the weekly game update. If you're seeing", "this message outside that time, something", "has gone wrong.")));
                } else {
                    SwingUtilities.invokeLater(() -> this.panel.displayError("Server error"));
                }
            }, (call, e) -> SwingUtilities.invokeLater(() -> this.panel.displayError("Server unavailable")));
        }
    }

    private void setWorldMapping() {
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult != null) {
            for (World world : worldResult.getWorlds()) {
                this.worldMapping.put(world.getId(), world);
            }
        }
    }

    private void postSighting(CropCircle cropCircle) {
        int world = this.currentWorld;
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            this.lastCropCircle = null;
            return;
        }
        if (world == -1) {
            this.lastCropCircle = null;
            return;
        }
        if (!this.cropCircleVisible(cropCircle.getWorldPoint())) {
            this.lastCropCircle = null;
            return;
        }
        if (world != this.currentWorld) {
            this.lastCropCircle = null;
            return;
        }
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("world", world);
        data.put("location", cropCircle.getIndex());
        this.makeRequest("POST", this.config.postEndpoint(), RequestBody.create((MediaType)JSON, (String)this.gson.toJson(data)), (call, response) -> {}, (call, response) -> {}, (call, e) -> {});
        this.lastCropCircle = cropCircle;
    }

    private void makeRequest(final String method, String url, RequestBody body, final BiConsumer<Call, Response> onSuccessfulResponse, final BiConsumer<Call, Response> onUnsuccessfulResponse, final BiConsumer<Call, Exception> onFailure) {
        log.debug("Making {} request to {} with body {}", new Object[]{method, url, body});
        Request request = null;
        try {
            request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + this.config.sharedKey()).method(method, body).build();
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid URL: {}", (Object)e.getMessage());
            SwingUtilities.invokeLater(() -> this.panel.displayError("Invalid " + method + " endpoint"));
        }
        if (request != null) {
            this.okHttpClient.newCall(request).enqueue(new Callback(){

                public void onResponse(Call call, Response response) {
                    if (response.isSuccessful()) {
                        onSuccessfulResponse.accept(call, response);
                    } else {
                        log.error("{} unsuccessful: {}", (Object)method, (Object)response.message());
                        onUnsuccessfulResponse.accept(call, response);
                    }
                    response.close();
                }

                public void onFailure(Call call, IOException e) {
                    log.error("{} failed: {}", (Object)method, (Object)e.getMessage());
                    onFailure.accept(call, e);
                }
            });
        }
    }

    private boolean cropCircleVisible(WorldPoint worldPoint) {
        LocalPoint localPoint = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPoint);
        if (localPoint != null) {
            Tile[][][] tiles = this.client.getScene().getTiles();
            Tile tile = tiles[worldPoint.getPlane()][localPoint.getSceneX()][localPoint.getSceneY()];
            for (GameObject object : tile.getGameObjects()) {
                if (object == null || object.getId() != 24988) continue;
                return true;
            }
        }
        return false;
    }

    @Schedule(period=10L, unit=ChronoUnit.SECONDS, asynchronous=true)
    public void poll() {
        if (this.lastCropCircle != null) {
            this.postSighting(this.lastCropCircle);
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        CropCircle cropCircle;
        if (event.getGameObject().getId() == 24988 && (cropCircle = MAPPING.get(event.getTile().getWorldLocation())) != null) {
            this.postSighting(cropCircle);
        }
    }

    @Subscribe
    public void onWorldChanged(WorldChanged event) {
        SwingUtilities.invokeLater(() -> this.panel.updateTable());
    }

    public CropCircleTrackerConfig getConfig() {
        return this.config;
    }
}

