/*
 * Decompiled with CFR 0.152.
 */
package cropcircletracker;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cropcircletracker.CropCircle;
import cropcircletracker.CropCircleTrackerPlugin;
import cropcircletracker.Table;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.ListCellRenderer;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.ComboBoxListRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CropCircleTrackerPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(CropCircleTrackerPanel.class);
    private static final Color BACKGROUND_COLOR = ColorScheme.DARK_GRAY_COLOR;
    private final CropCircleTrackerPlugin plugin;
    public boolean open = false;
    public JsonObject likelihoods = null;
    private JComboBox<String> locationDropdownMenu;
    private Table table;

    @Inject
    public CropCircleTrackerPanel(CropCircleTrackerPlugin plugin) {
        this.plugin = plugin;
        this.setBackground(BACKGROUND_COLOR);
        this.setLayout(new GridBagLayout());
        this.addLocationLabel();
        this.addLocationDropdownMenu();
        this.addTable();
    }

    private void addLocationLabel() {
        JLabel label = new JLabel();
        label.setText("Location:");
        this.add(label, this.constraints(0, 0, 1));
    }

    private void addLocationDropdownMenu() {
        this.locationDropdownMenu = new JComboBox();
        this.locationDropdownMenu.setRenderer((ListCellRenderer<String>)new ComboBoxListRenderer());
        this.locationDropdownMenu.setFocusable(false);
        this.locationDropdownMenu.setForeground(Color.WHITE);
        this.locationDropdownMenu.setMaximumRowCount(CropCircle.values().length);
        ArrayList<String> names = new ArrayList<String>();
        for (CropCircle cropCircle : CropCircle.values()) {
            names.add(cropCircle.getName());
        }
        Collections.sort(names);
        for (String name : names) {
            this.locationDropdownMenu.addItem(name);
        }
        this.locationDropdownMenu.setSelectedItem(this.plugin.config.defaultLocation().getName());
        this.locationDropdownMenu.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.updateTable();
            }
        });
        this.add(this.locationDropdownMenu, this.constraints(1, 0, 1));
    }

    private void addTable() {
        this.table = new Table(this.plugin);
        GridBagConstraints constraints = this.constraints(0, 2, 2);
        constraints.insets = new Insets(10, 0, 0, 0);
        this.add(this.table, constraints);
    }

    public void updateTable() {
        if (this.likelihoods != null) {
            String selectedLocationName = String.valueOf(this.locationDropdownMenu.getSelectedItem());
            CropCircle cropCircle = CropCircle.fromName(selectedLocationName);
            if (cropCircle == null) {
                log.error("Invalid location selected");
                return;
            }
            int selectedLocation = cropCircle.getIndex();
            ArrayList<List<Object>> worldLikelihoodPairs = new ArrayList<List<Object>>();
            this.likelihoods.keySet().forEach(world -> {
                JsonObject likelihoodsForWorld = this.likelihoods.get(world).getAsJsonObject();
                JsonElement likelihoodJsonElement = likelihoodsForWorld.get(String.valueOf(selectedLocation));
                if (likelihoodJsonElement != null) {
                    double likelihood = likelihoodJsonElement.getAsDouble();
                    ArrayList<Object> pair = new ArrayList<Object>();
                    pair.add(world);
                    pair.add(likelihood);
                    worldLikelihoodPairs.add(pair);
                }
            });
            this.table.update(worldLikelihoodPairs);
        }
    }

    public void clearTable() {
        this.likelihoods = null;
        this.table.clear();
    }

    public void displayError(String errorMessage) {
        this.likelihoods = null;
        this.table.displayError(errorMessage);
    }

    public void displayErrors(List<String> errorMessages) {
        this.likelihoods = null;
        this.table.displayErrors(errorMessages);
    }

    public void onActivate() {
        this.clearTable();
        this.open = true;
        this.plugin.getLikelihoods();
    }

    public void onDeactivate() {
        this.open = false;
    }

    private GridBagConstraints constraints(int gridx, int gridy, int gridwidth) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = gridx;
        c.gridy = gridy;
        c.gridwidth = gridwidth;
        c.weightx = 1.0;
        c.fill = 2;
        return c;
    }
}

