/*
 * Decompiled with CFR 0.152.
 */
package cropcircletracker;

import java.util.HashMap;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;

public enum CropCircle {
    BRIMHAVEN(11, "Brimhaven", new WorldPoint(2808, 3200, 0)),
    CATHERBY(9, "Catherby", new WorldPoint(2819, 3470, 0)),
    DORICS_HOUSE(0, "Doric's House", new WorldPoint(2953, 3444, 0)),
    DRAYNOR(2, "Draynor", new WorldPoint(3115, 3273, 0)),
    EAST_ARDOUGNE(15, "East Ardougne", new WorldPoint(2647, 3348, 0)),
    FARMING_GUILD(5, "Farming Guild", new WorldPoint(1302, 3711, 0)),
    GRAND_EXCHANGE(4, "Grand Exchange", new WorldPoint(3141, 3461, 0)),
    GWENITH(8, "Gwenith", new WorldPoint(2195, 3402, 0)),
    HARMONY_ISLAND(7, "Harmony Island", new WorldPoint(3810, 2852, 0)),
    HOSIDIUS(6, "Hosidius", new WorldPoint(1738, 3533, 0)),
    LUMBRIDGE_MILL(14, "Lumbridge Mill", new WorldPoint(3160, 3299, 0)),
    MISCELLANIA(17, "Miscellania", new WorldPoint(2538, 3845, 0)),
    MOS_LE_HARMLESS(12, "Mos Le'Harmless", new WorldPoint(3703, 2975, 0)),
    RIMMINGTON(3, "Rimmington", new WorldPoint(2978, 3216, 0)),
    SOUTH_OF_VARROCK(16, "South of Varrock", new WorldPoint(3212, 3345, 0)),
    TAVERLEY(13, "Taverley", new WorldPoint(2896, 3406, 0)),
    TREE_GNOME_STRONGHOLD(10, "Tree Gnome Stronghold", new WorldPoint(2435, 3472, 0)),
    YANILLE(1, "Yanille", new WorldPoint(2582, 3104, 0));

    private final int index;
    private final String name;
    private final WorldPoint worldPoint;

    public static Map<WorldPoint, CropCircle> mapping() {
        HashMap<WorldPoint, CropCircle> mapping = new HashMap<WorldPoint, CropCircle>();
        for (CropCircle cropCircle : CropCircle.values()) {
            mapping.put(cropCircle.getWorldPoint(), cropCircle);
        }
        return mapping;
    }

    public static CropCircle fromName(String name) {
        for (CropCircle cropCircle : CropCircle.values()) {
            if (!cropCircle.getName().equals(name)) continue;
            return cropCircle;
        }
        return null;
    }

    private CropCircle(int index, String name, WorldPoint worldPoint) {
        this.index = index;
        this.name = name;
        this.worldPoint = worldPoint;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public WorldPoint getWorldPoint() {
        return this.worldPoint;
    }
}

