/*
 * Decompiled with CFR 0.152.
 */
package com.rewordmanager;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.rewordmanager.RewordManagerConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.MessageNode;
import net.runelite.api.NPC;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Reword Manager", description="Reword Chat messages, Items, NPCs, Objects, Options", tags={"reword", "word", "text", "rename", "replace", "acronym", "abbreviate", "chat", "message", "npc", "item", "object", "option"})
public class RewordManagerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RewordManagerPlugin.class);
    private final HashMap<String, String> chatListHashMap = new HashMap();
    private final HashMap<String, String> npcListHashMap = new HashMap();
    private final HashMap<String, String> itemListHashMap = new HashMap();
    private final HashMap<String, String> objectListHashMap = new HashMap();
    private final HashMap<String, String> optionListHashMap = new HashMap();
    private static final Set<MenuAction> NPC_MENU_ACTIONS = ImmutableSet.of((Object)MenuAction.NPC_FIRST_OPTION, (Object)MenuAction.NPC_SECOND_OPTION, (Object)MenuAction.NPC_THIRD_OPTION, (Object)MenuAction.NPC_FOURTH_OPTION, (Object)MenuAction.NPC_FIFTH_OPTION, (Object)MenuAction.WIDGET_TARGET_ON_NPC, (Object[])new MenuAction[]{MenuAction.EXAMINE_NPC});
    private static final Set<MenuAction> ITEM_MENU_ACTIONS = ImmutableSet.of((Object)MenuAction.GROUND_ITEM_FIRST_OPTION, (Object)MenuAction.GROUND_ITEM_SECOND_OPTION, (Object)MenuAction.GROUND_ITEM_THIRD_OPTION, (Object)MenuAction.GROUND_ITEM_FOURTH_OPTION, (Object)MenuAction.GROUND_ITEM_FIFTH_OPTION, (Object)MenuAction.EXAMINE_ITEM_GROUND, (Object[])new MenuAction[]{MenuAction.WIDGET_TARGET_ON_GROUND_ITEM, MenuAction.CC_OP, MenuAction.CC_OP_LOW_PRIORITY, MenuAction.WIDGET_TARGET});
    private static final Set<MenuAction> OBJECT_MENU_ACTIONS = ImmutableSet.of((Object)MenuAction.GAME_OBJECT_FIRST_OPTION, (Object)MenuAction.GAME_OBJECT_SECOND_OPTION, (Object)MenuAction.GAME_OBJECT_THIRD_OPTION, (Object)MenuAction.GAME_OBJECT_FOURTH_OPTION, (Object)MenuAction.GAME_OBJECT_FIFTH_OPTION, (Object)MenuAction.WIDGET_TARGET_ON_GAME_OBJECT, (Object[])new MenuAction[]{MenuAction.EXAMINE_OBJECT});
    @Inject
    private Client client;
    @Inject
    private RewordManagerConfig config;

    protected void startUp() throws Exception {
        this.parseConfig();
    }

    protected void shutDown() throws Exception {
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
    }

    @Provides
    RewordManagerConfig provideConfig(ConfigManager configManager) {
        return (RewordManagerConfig)configManager.getConfig(RewordManagerConfig.class);
    }

    private void parseConfig() {
        this.chatListHashMap.clear();
        this.npcListHashMap.clear();
        this.itemListHashMap.clear();
        this.objectListHashMap.clear();
        this.optionListHashMap.clear();
        try {
            this.parseHashMap(this.config.chatList(), this.chatListHashMap);
            this.parseHashMap(this.config.npcList(), this.npcListHashMap);
            this.parseHashMap(this.config.itemList(), this.itemListHashMap);
            this.parseHashMap(this.config.objectList(), this.objectListHashMap);
            this.parseHashMap(this.config.optionList(), this.optionListHashMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseHashMap(String csv, HashMap<String, String> hashMap) {
        String[] pairs;
        if (csv.isEmpty()) {
            return;
        }
        for (String pair : pairs = csv.split("\n")) {
            String[] kv = pair.split(",");
            if (kv.length != 2) continue;
            hashMap.put(kv[0], kv[1]);
        }
    }

    @Subscribe
    protected void onConfigChanged(ConfigChanged event) {
        this.parseConfig();
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        String[] words;
        String message = chatMessage.getMessage();
        if (!this.checkMessage(message)) {
            return;
        }
        ChatMessageBuilder builder = new ChatMessageBuilder();
        builder.append(ChatColorType.HIGHLIGHT).append("[Modified] ");
        for (String word : words = message.split(" ")) {
            String modifiedWord = this.chatListHashMap.getOrDefault(word, word);
            builder.append(ChatColorType.NORMAL).append(modifiedWord).append(" ");
        }
        String response = builder.build();
        MessageNode messageNode = chatMessage.getMessageNode();
        messageNode.setRuneLiteFormatMessage(response);
        this.client.refreshChat();
    }

    @Subscribe
    public void onOverheadTextChanged(OverheadTextChanged overheadText) {
        Object modified_message;
        if (this.config.overheadText()) {
            String message = overheadText.getOverheadText();
            if (!this.checkMessage(message)) {
                return;
            }
            String[] words = message.split(" ");
            modified_message = "[Modified] ";
            for (String word : words) {
                String modifiedWord = this.chatListHashMap.getOrDefault(word, word);
                modified_message = (String)modified_message + modifiedWord + " ";
            }
        } else {
            return;
        }
        overheadText.getActor().setOverheadText((String)modified_message);
    }

    private boolean checkMessage(String message) {
        if (message.contains("</col>") || message.contains("<br>")) {
            return false;
        }
        for (String keyword : this.chatListHashMap.keySet()) {
            Pattern pattern = Pattern.compile("(?<!\\p{Punct})\\b" + keyword + "\\b(?!\\p{Punct})");
            if (!pattern.matcher(message).find()) continue;
            return true;
        }
        return false;
    }

    private void remapMenuEntryText(MenuEntry menuEntry, HashMap<String, String> map) {
        String target = menuEntry.getTarget();
        NPC npc = menuEntry.getNpc();
        String cleanTarget = null;
        cleanTarget = npc != null ? Text.removeTags((String)npc.getName()) : Text.removeTags((String)target);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!cleanTarget.equals(entry.getKey())) continue;
            menuEntry.setTarget(target.replace(entry.getKey(), entry.getValue()));
        }
    }

    private void remapOptionText(MenuEntry event) {
        String option = event.getOption();
        if (this.optionListHashMap.containsKey(option)) {
            event.setOption(this.optionListHashMap.get(option));
        }
    }

    @Subscribe
    protected void onMenuEntryAdded(MenuEntryAdded event) {
        MenuEntry entry = event.getMenuEntry();
        if (NPC_MENU_ACTIONS.contains(entry.getType())) {
            this.remapMenuEntryText(entry, this.npcListHashMap);
        } else if (ITEM_MENU_ACTIONS.contains(entry.getType())) {
            this.remapMenuEntryText(entry, this.itemListHashMap);
        } else if (OBJECT_MENU_ACTIONS.contains(entry.getType())) {
            this.remapMenuEntryText(entry, this.objectListHashMap);
        }
        this.remapOptionText(entry);
    }
}

