/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.inventorysummary;

import com.google.inject.Provides;
import io.hydrox.inventorysummary.InventorySummaryConfig;
import io.hydrox.inventorysummary.InventorySummaryOverlay;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;

@PluginDescriptor(name="Inventory Summary", description="A compact summary of your inventory", tags={"alternate", "items", "overlay", "second", "summary"})
public class InventorySummaryPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private InventorySummaryOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private InventorySummaryConfig config;
    @Inject
    private ItemManager itemManager;
    private List<String> whitelist = new CopyOnWriteArrayList<String>();
    private List<String> blacklist = new CopyOnWriteArrayList<String>();

    @Provides
    InventorySummaryConfig provideConfig(ConfigManager configManager) {
        return (InventorySummaryConfig)configManager.getConfig(InventorySummaryConfig.class);
    }

    public void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.whitelist = Text.fromCSV((String)this.config.whitelist());
        this.blacklist = Text.fromCSV((String)this.config.blacklist());
        this.clientThread.invoke(this::groupItems);
    }

    public void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("inventorysummary")) {
            this.whitelist = Text.fromCSV((String)this.config.whitelist());
            this.blacklist = Text.fromCSV((String)this.config.blacklist());
            this.clientThread.invoke(this::groupItems);
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() == InventoryID.INVENTORY.getId()) {
            this.groupItems(event.getItemContainer().getItems());
        }
    }

    private void groupItems() {
        ItemContainer container = this.client.getItemContainer(InventoryID.INVENTORY);
        this.groupItems(container == null ? new Item[]{} : container.getItems());
    }

    private boolean listContains(List<String> list, String search) {
        for (String item : list) {
            if (!WildcardMatcher.matches((String)item, (String)search)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldItemBeShown(Item item) {
        ItemComposition itemComp = this.itemManager.getItemComposition(item.getId());
        return !(this.config.whitelistEnabled() && !this.listContains(this.whitelist, itemComp.getName()) || this.config.blacklistEnabled() && this.listContains(this.blacklist, itemComp.getName()));
    }

    private void groupItems(Item[] items) {
        Map groupedItems = Arrays.stream(items).filter(p -> p.getId() != -1).filter(this::shouldItemBeShown).collect(Collectors.groupingBy(Item::getId, LinkedHashMap::new, Collectors.summingInt(Item::getQuantity)));
        int spacesUsed = (int)Arrays.stream(items).filter(p -> p.getId() != -1).count();
        this.overlay.rebuild(groupedItems, spacesUsed);
    }
}

