/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.inventorysummary;

import io.hydrox.inventorysummary.InventorySummaryConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;

class InventorySummaryOverlay
extends OverlayPanel {
    private static final int INVENTORY_SIZE = 28;
    private static final Point SPRITE_PADDING = new Point(6, 4);
    private static final int WRAPPER_MINIMUM_WIDTH = 36 + InventorySummaryOverlay.SPRITE_PADDING.x * 2;
    private static final int FREE_SLOTS_HEIGHT = 14;
    private final ItemManager itemManager;
    private final InventorySummaryConfig config;
    private final PanelComponent inventoryComponent = new PanelComponent();
    private final List<ImageComponent> images = new ArrayList<ImageComponent>();
    private ImageComponent inventoryIconSprite;
    private ImageComponent freeSlotsDisplay = new ImageComponent(new BufferedImage(36, 14, 6));
    private int lastWidth = 0;
    private String freeText = "Test";

    @Inject
    private InventorySummaryOverlay(ItemManager itemManager, InventorySummaryConfig config) {
        this.setPosition(OverlayPosition.BOTTOM_RIGHT);
        this.inventoryComponent.setGap(SPRITE_PADDING);
        this.inventoryComponent.setOrientation(ComponentOrientation.HORIZONTAL);
        this.inventoryComponent.setBackgroundColor(null);
        this.inventoryComponent.setBorder(new Rectangle(4, 0, 0, 4));
        this.inventoryComponent.setPreferredSize(new Dimension(WRAPPER_MINIMUM_WIDTH, 0));
        this.inventoryComponent.setWrap(true);
        this.panelComponent.setOrientation(ComponentOrientation.VERTICAL);
        this.panelComponent.setBorder(new Rectangle(4, 4, 4, 4));
        this.panelComponent.setPreferredSize(new Dimension(WRAPPER_MINIMUM_WIDTH, 0));
        this.itemManager = itemManager;
        this.config = config;
        this.inventoryIconSprite = new ImageComponent(ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"empty.png"));
    }

    public Dimension render(Graphics2D graphics) {
        this.inventoryComponent.getChildren().clear();
        if (this.images.size() == 0) {
            this.inventoryComponent.getChildren().add(this.inventoryIconSprite);
        } else {
            for (ImageComponent ic : this.images) {
                this.inventoryComponent.getChildren().add(ic);
            }
        }
        this.panelComponent.getChildren().add(this.inventoryComponent);
        if (this.config.showFreeSlots()) {
            int invWidth = Math.max(36, this.inventoryComponent.getBounds().width);
            if (invWidth != this.lastWidth) {
                BufferedImage bf = new BufferedImage(invWidth, 14, 6);
                Graphics g = bf.getGraphics();
                FontMetrics fm = g.getFontMetrics();
                g.setFont(FontManager.getRunescapeFont());
                g.setColor(Color.BLACK);
                g.drawString(this.freeText, (bf.getWidth() - fm.stringWidth(this.freeText)) / 2 + 1, fm.getAscent() + 1);
                g.setColor(Color.WHITE);
                g.drawString(this.freeText, (bf.getWidth() - fm.stringWidth(this.freeText)) / 2, fm.getAscent());
                this.freeSlotsDisplay = new ImageComponent(bf);
                this.lastWidth = invWidth;
            }
            this.panelComponent.getChildren().add(this.freeSlotsDisplay);
        }
        return super.render(graphics);
    }

    void rebuild(Map<Integer, Integer> groupedItems, int spacesUsed) {
        this.inventoryComponent.getChildren().clear();
        this.images.clear();
        for (Map.Entry<Integer, Integer> cursor : groupedItems.entrySet()) {
            AsyncBufferedImage image = this.itemManager.getImage(cursor.getKey().intValue(), cursor.getValue().intValue(), true);
            if (image == null) continue;
            this.images.add(new ImageComponent((BufferedImage)image));
        }
        this.freeText = 28 - spacesUsed + " free";
        this.lastWidth = 0;
    }
}

