/*
 * Decompiled with CFR 0.152.
 */
package com.banlist;

import com.banlist.BanListConfig;
import com.banlist.ListType;
import com.google.inject.Provides;
import java.io.IOException;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.events.FriendsChatMemberJoined;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.task.Schedule;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Ban List", description="Displays warning in chat when you join aclan chat/new member join your clan chat and he is in a Url list/Manual List", tags={"banlist"}, enabledByDefault=false)
public class BanListPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BanListPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private BanListConfig config;
    @Inject
    private ChatMessageManager chatMessageManager;
    private ArrayList<String> UrlArrayList = new ArrayList();
    private ArrayList<String> manualBans = new ArrayList();

    @Provides
    BanListConfig getConfig(ConfigManager configManager) {
        return (BanListConfig)configManager.getConfig(BanListConfig.class);
    }

    protected void startUp() throws Exception {
        this.manualBans.addAll(Text.fromCSV((String)Text.standardize((String)this.config.getBannedPlayers())));
        this.fetchFromWebsites();
    }

    protected void shutDown() throws Exception {
        this.UrlArrayList.clear();
        this.manualBans.clear();
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("banlist") && event.getKey().equals("bannedPlayers")) {
            this.manualBans.clear();
            this.UrlArrayList.clear();
            String newValue = event.getNewValue();
            this.manualBans.addAll(Text.fromCSV((String)Text.standardize((String)newValue)));
            this.fetchFromWebsites();
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 1658) {
            this.clientThread.invokeLater(() -> {
                if (!this.client.getWidget(WidgetInfo.FRIENDS_CHAT).isHidden()) {
                    this.highlightRedInCC();
                }
            });
        }
    }

    @Subscribe
    private void onFriendsChatMemberJoined(FriendsChatMemberJoined event) {
        FriendsChatMember member = event.getMember();
        String memberUsername = Text.standardize((String)member.getName().toLowerCase());
        ListType scamList = this.checkBanList(memberUsername);
        if (scamList != null) {
            this.sendWarning(memberUsername, scamList);
            if (this.config.highlightInClan()) {
                this.highlightRedInCC();
            }
        }
    }

    @Schedule(period=5L, unit=ChronoUnit.MINUTES)
    public void refreshList() {
        this.UrlArrayList.clear();
        this.fetchFromWebsites();
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (this.config.highlightInTrade() && widgetLoaded.getGroupId() == 335) {
            this.clientThread.invokeLater(() -> {
                Widget tradingWith = this.client.getWidget(335, 31);
                String name = tradingWith.getText().replaceAll("Trading With: ", "");
                ListType tradeList = this.checkBanList(name);
                if (this.checkBanList(name) != null) {
                    this.sendWarning(name, tradeList);
                    tradingWith.setText(tradingWith.getText().replaceAll(name, "<col=ff0000>" + name + " (on banlist)</col>"));
                }
            });
        }
    }

    private ListType checkBanList(String nameToBeChecked) {
        if (this.UrlArrayList.size() > 0 && this.config.enableUrl()) {
            if (this.UrlArrayList.stream().anyMatch(nameToBeChecked::equalsIgnoreCase)) {
                return ListType.Url_LIST;
            }
        }
        if (this.manualBans.size() > 0) {
            if (this.manualBans.stream().anyMatch(nameToBeChecked::equalsIgnoreCase)) {
                return ListType.MANUAL_LIST;
            }
        }
        return null;
    }

    private void sendWarning(String playerName, ListType listType) {
        switch (listType) {
            case Url_LIST: {
                String url_message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Warning! " + playerName + " is on the Url's  list!").build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(url_message).build());
                break;
            }
            case MANUAL_LIST: {
                String manual_message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("Warning! " + playerName + " is on your manual scammer list!").build();
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(manual_message).build());
            }
        }
    }

    private void fetchFromWebsites() {
        Request Request2 = new Request.Builder().url(this.config.getBannedUrl()).build();
        RuneLiteAPI.CLIENT.newCall(Request2).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("error retrieving names from Url");
            }

            public void onResponse(Call call, Response response) throws IOException {
                String text = response.body().string();
                text = text.replace("\n", ",");
                ArrayList<String> urlList = new ArrayList<String>(Arrays.asList(text.split(",")));
                ArrayList urlList2 = new ArrayList();
                urlList.forEach(name -> urlList2.add(Text.standardize((String)name)));
                BanListPlugin.this.UrlArrayList.addAll(urlList2);
            }
        });
    }

    private void highlightRedInCC() {
        this.clientThread.invokeLater(() -> {
            Widget widget = this.client.getWidget(WidgetInfo.FRIENDS_CHAT_LIST);
            for (Widget widgetChild : widget.getDynamicChildren()) {
                ListType listType = this.checkBanList(widgetChild.getText());
                if (listType == null) continue;
                widgetChild.setText("<col=ff0000>" + widgetChild.getText() + "</col>");
            }
        });
    }
}

