/*
 * Decompiled with CFR 0.152.
 */
package com.noadviser;

import com.google.inject.Provides;
import com.noadviser.NoAdviserConfig;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="No Adviser")
public class NoAdviserPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NoAdviserPlugin.class);
    private static final int COMBAT_TIMER_SECONDS = 10;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private NoAdviserConfig config;
    private Instant lastCombatTime;

    @Provides
    NoAdviserConfig provideConfig(ConfigManager configManager) {
        return (NoAdviserConfig)configManager.getConfig(NoAdviserConfig.class);
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (event.getActor() == this.client.getLocalPlayer() && this.isPlayerAttackAnimation(event.getActor().getAnimation())) {
            this.lastCombatTime = Instant.now();
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        if (event.getActor() == this.client.getLocalPlayer()) {
            this.lastCombatTime = Instant.now();
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (event.getType() == MenuAction.CC_OP.getId() && event.getOption().equalsIgnoreCase("Open Activity Adviser") && (this.isInCombat() || this.config.alwaysDisabled())) {
            MenuEntry[] menuEntries = this.client.getMenuEntries();
            int lastIndex = menuEntries.length - 1;
            MenuEntry[] newMenuEntries = new MenuEntry[lastIndex];
            System.arraycopy(menuEntries, 0, newMenuEntries, 0, lastIndex);
            this.client.setMenuEntries(newMenuEntries);
        }
    }

    private boolean isInCombat() {
        if (this.lastCombatTime == null) {
            return false;
        }
        return this.lastCombatTime.plusSeconds(10L).isAfter(Instant.now());
    }

    private boolean isPlayerAttackAnimation(int animationId) {
        return animationId == 806 || animationId == 422;
    }
}

